/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.invoker;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.SystemOutLogger;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.Commandline;

public class MavenCommandLineBuilder {
    private static final InvokerLogger DEFAULT_LOGGER = new SystemOutLogger();
    private InvokerLogger logger = DEFAULT_LOGGER;
    private File baseDirectory;
    private File localRepositoryDirectory;
    private File mavenHome;
    private File mavenExecutable;

    public Commandline build(InvocationRequest request) throws CommandLineConfigurationException {
        Commandline cli = new Commandline();
        this.setupMavenHome(request);
        this.setupBaseDirectory(request);
        cli.setWorkingDirectory(this.baseDirectory);
        this.checkRequiredState();
        this.setupMavenExecutable(request);
        cli.setExecutable(this.mavenExecutable.getAbsolutePath());
        this.setShellEnvironment(request, cli);
        this.setFlags(request, cli);
        this.setReactorBehavior(request, cli);
        this.setLocalRepository(request, cli);
        this.setPomLocation(request, cli);
        this.setSettingsLocation(request, cli);
        this.setToolchainsLocation(request, cli);
        this.setProperties(request, cli);
        this.setProfiles(request, cli);
        this.setGoals(request, cli);
        this.setThreads(request, cli);
        this.setArgs(request, cli);
        return cli;
    }

    protected void checkRequiredState() {
        if (this.logger == null) {
            throw new IllegalStateException("A logger instance is required.");
        }
    }

    protected void setSettingsLocation(InvocationRequest request, Commandline cli) {
        File globalSettingsFile;
        File userSettingsFile = request.getUserSettingsFile();
        if (userSettingsFile != null) {
            try {
                userSettingsFile = userSettingsFile.getCanonicalFile();
            }
            catch (IOException e) {
                this.logger.debug("Failed to canonicalize user settings path: " + userSettingsFile.getAbsolutePath() + ". Using as-is.", e);
            }
            cli.createArg().setValue("-s");
            cli.createArg().setValue(userSettingsFile.getPath());
        }
        if ((globalSettingsFile = request.getGlobalSettingsFile()) != null) {
            try {
                globalSettingsFile = globalSettingsFile.getCanonicalFile();
            }
            catch (IOException e) {
                this.logger.debug("Failed to canonicalize global settings path: " + globalSettingsFile.getAbsolutePath() + ". Using as-is.", e);
            }
            cli.createArg().setValue("-gs");
            cli.createArg().setValue(globalSettingsFile.getPath());
        }
    }

    protected void setToolchainsLocation(InvocationRequest request, Commandline cli) {
        File toolchainsFile = request.getToolchainsFile();
        if (toolchainsFile != null) {
            try {
                toolchainsFile = toolchainsFile.getCanonicalFile();
            }
            catch (IOException e) {
                this.logger.debug("Failed to canonicalize toolchains path: " + toolchainsFile.getAbsolutePath() + ". Using as-is.", e);
            }
            cli.createArg().setValue("-t");
            cli.createArg().setValue(toolchainsFile.getPath());
        }
    }

    protected void setShellEnvironment(InvocationRequest request, Commandline cli) {
        if (request.isShellEnvironmentInherited()) {
            cli.addSystemEnvironment();
        }
        if (request.getJavaHome() != null) {
            cli.addEnvironment("JAVA_HOME", request.getJavaHome().getAbsolutePath());
        }
        if (request.getMavenOpts() != null) {
            cli.addEnvironment("MAVEN_OPTS", request.getMavenOpts());
        }
        for (Map.Entry<String, String> entry : request.getShellEnvironments().entrySet()) {
            cli.addEnvironment(entry.getKey(), entry.getValue());
        }
    }

    protected void setProfiles(InvocationRequest request, Commandline cli) {
        List<String> profiles = request.getProfiles();
        if (profiles != null && !profiles.isEmpty()) {
            cli.createArg().setValue("-P");
            cli.createArg().setValue(StringUtils.join(profiles.iterator(), (String)","));
        }
    }

    protected void setGoals(InvocationRequest request, Commandline cli) throws CommandLineConfigurationException {
        List<String> goals = request.getGoals();
        if (goals != null && !goals.isEmpty()) {
            try {
                cli.createArg().setLine(StringUtils.join(goals.iterator(), (String)" "));
            }
            catch (CommandLineException e) {
                throw new CommandLineConfigurationException("Problem to set goals: " + e.getMessage(), e);
            }
        }
    }

    protected void setProperties(InvocationRequest request, Commandline cli) {
        Properties properties = request.getProperties();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                cli.createArg().setValue("-D");
                cli.createArg().setValue(key + '=' + value);
            }
        }
    }

    protected void setPomLocation(InvocationRequest request, Commandline cli) {
        File pom = request.getPomFile();
        String pomFilename = request.getPomFileName();
        if (pom == null) {
            pom = pomFilename != null ? new File(this.baseDirectory, pomFilename) : new File(this.baseDirectory, "pom.xml");
        }
        try {
            pom = pom.getCanonicalFile();
        }
        catch (IOException e) {
            this.logger.debug("Failed to canonicalize the POM path: " + pom + ". Using as-is.", e);
        }
        if (pom.getParentFile().equals(this.baseDirectory)) {
            if (!"pom.xml".equals(pom.getName())) {
                this.logger.debug("Specified POM file is not named 'pom.xml'. Using the '-f' command-line option to accommodate non-standard filename...");
                cli.createArg().setValue("-f");
                cli.createArg().setValue(pom.getName());
            }
        } else {
            cli.createArg().setValue("-f");
            cli.createArg().setValue(pom.getPath());
        }
    }

    void setupBaseDirectory(InvocationRequest request) {
        File baseDirectoryFromRequest = null;
        if (request.getBaseDirectory() != null) {
            baseDirectoryFromRequest = request.getBaseDirectory();
        } else {
            File pomFile = request.getPomFile();
            if (pomFile != null) {
                baseDirectoryFromRequest = pomFile.getParentFile();
            }
        }
        if (baseDirectoryFromRequest != null) {
            this.baseDirectory = baseDirectoryFromRequest;
        }
        if (this.baseDirectory == null) {
            this.baseDirectory = new File(System.getProperty("user.dir"));
        } else if (this.baseDirectory.isFile()) {
            this.logger.warn("Specified base directory (" + this.baseDirectory + ") is a file. Using its parent directory...");
            this.baseDirectory = this.baseDirectory.getParentFile();
        }
        try {
            this.baseDirectory = this.baseDirectory.getCanonicalFile();
        }
        catch (IOException e) {
            this.logger.debug("Failed to canonicalize base directory: " + this.baseDirectory + ". Using as-is.", e);
        }
    }

    protected void setLocalRepository(InvocationRequest request, Commandline cli) {
        File localRepositoryDirectory = request.getLocalRepositoryDirectory(this.localRepositoryDirectory);
        if (localRepositoryDirectory != null) {
            try {
                localRepositoryDirectory = localRepositoryDirectory.getCanonicalFile();
            }
            catch (IOException e) {
                this.logger.debug("Failed to canonicalize local repository directory: " + localRepositoryDirectory + ". Using as-is.", e);
            }
            if (!localRepositoryDirectory.isDirectory()) {
                throw new IllegalArgumentException("Local repository location: '" + localRepositoryDirectory + "' is NOT a directory.");
            }
            cli.createArg().setValue("-D");
            cli.createArg().setValue("maven.repo.local=" + localRepositoryDirectory.getPath());
        }
    }

    protected void setReactorBehavior(InvocationRequest request, Commandline cli) {
        List<String> projectList;
        InvocationRequest.ReactorFailureBehavior failureBehavior = request.getReactorFailureBehavior();
        if (failureBehavior != null) {
            if (InvocationRequest.ReactorFailureBehavior.FailAtEnd.equals((Object)failureBehavior)) {
                cli.createArg().setValue("-" + InvocationRequest.ReactorFailureBehavior.FailAtEnd.getShortOption());
            } else if (InvocationRequest.ReactorFailureBehavior.FailNever.equals((Object)failureBehavior)) {
                cli.createArg().setValue("-" + InvocationRequest.ReactorFailureBehavior.FailNever.getShortOption());
            }
        }
        if (StringUtils.isNotEmpty((String)request.getResumeFrom())) {
            cli.createArg().setValue("-rf");
            cli.createArg().setValue(request.getResumeFrom());
        }
        if ((projectList = request.getProjects()) != null) {
            cli.createArg().setValue("-pl");
            cli.createArg().setValue(StringUtils.join(projectList.iterator(), (String)","));
            if (request.isAlsoMake()) {
                cli.createArg().setValue("-am");
            }
            if (request.isAlsoMakeDependents()) {
                cli.createArg().setValue("-amd");
            }
        }
    }

    protected void setFlags(InvocationRequest request, Commandline cli) {
        if (request.isBatchMode()) {
            cli.createArg().setValue("-B");
        }
        if (request.isOffline()) {
            cli.createArg().setValue("-o");
        }
        if (request.isUpdateSnapshots()) {
            cli.createArg().setValue("-U");
        }
        if (!request.isRecursive()) {
            cli.createArg().setValue("-N");
        }
        if (request.isDebug()) {
            cli.createArg().setValue("-X");
        } else if (request.isShowErrors()) {
            cli.createArg().setValue("-e");
        }
        InvocationRequest.CheckSumPolicy checksumPolicy = request.getGlobalChecksumPolicy();
        if (InvocationRequest.CheckSumPolicy.Fail.equals((Object)checksumPolicy)) {
            cli.createArg().setValue("-C");
        } else if (InvocationRequest.CheckSumPolicy.Warn.equals((Object)checksumPolicy)) {
            cli.createArg().setValue("-c");
        }
        if (request.isNonPluginUpdates()) {
            cli.createArg().setValue("-npu");
        }
        if (request.isShowVersion()) {
            cli.createArg().setValue("-V");
        }
        if (request.getBuilder() != null) {
            cli.createArg().setValue("-b");
            cli.createArg().setValue(request.getBuilder());
        }
        if (request.isQuiet()) {
            cli.createArg().setValue("-q");
        }
        if (request.isNoTransferProgress()) {
            cli.createArg().setValue("-ntp");
        }
    }

    protected void setThreads(InvocationRequest request, Commandline cli) {
        String threads = request.getThreads();
        if (StringUtils.isNotEmpty((String)threads)) {
            cli.createArg().setValue("-T");
            cli.createArg().setValue(threads);
        }
    }

    private void setArgs(InvocationRequest request, Commandline cli) {
        for (String arg : request.getArgs()) {
            cli.createArg().setValue(arg);
        }
    }

    private void setupMavenHome(InvocationRequest request) {
        File binDir;
        if (request.getMavenHome() != null) {
            this.mavenHome = request.getMavenHome();
        } else if (System.getProperty("maven.home") != null) {
            this.mavenHome = new File(System.getProperty("maven.home"));
        }
        if (this.mavenHome != null && !this.mavenHome.isDirectory() && (binDir = this.mavenHome.getParentFile()) != null && "bin".equals(binDir.getName())) {
            this.mavenHome = binDir.getParentFile();
        }
        if (this.mavenHome != null && !this.mavenHome.isDirectory()) {
            throw new IllegalStateException("Maven home is set to: '" + this.mavenHome + "' which is not a directory");
        }
        this.logger.debug("Using maven.home of: '" + this.mavenHome + "'.");
    }

    protected void setupMavenExecutable(InvocationRequest request) throws CommandLineConfigurationException {
        if (request.getMavenExecutable() != null) {
            this.mavenExecutable = request.getMavenExecutable();
        }
        if (this.mavenExecutable == null || !this.mavenExecutable.isAbsolute()) {
            String executable = this.mavenExecutable != null ? this.mavenExecutable.getPath() : "mvn";
            this.mavenExecutable = this.detectMavenExecutablePerOs(this.baseDirectory, executable);
            if (this.mavenExecutable == null) {
                this.mavenExecutable = this.detectMavenExecutablePerOs(this.mavenHome, "/bin/" + executable);
            }
            if (this.mavenExecutable != null) {
                try {
                    this.mavenExecutable = this.mavenExecutable.getCanonicalFile();
                }
                catch (IOException e) {
                    this.logger.debug("Failed to canonicalize maven executable: '" + this.mavenExecutable + "'. Using as-is.", e);
                }
            } else {
                throw new CommandLineConfigurationException("Maven executable: '" + executable + "' not found at project dir: '" + this.baseDirectory + "' nor maven home: '" + this.mavenHome + "'");
            }
        }
    }

    private File detectMavenExecutablePerOs(File baseDirectory, String executable) {
        File executableFile;
        if (Os.isFamily((String)"windows")) {
            executableFile = new File(baseDirectory, executable + ".cmd");
            if (executableFile.isFile()) {
                return executableFile;
            }
            executableFile = new File(baseDirectory, executable + ".bat");
            if (executableFile.isFile()) {
                return executableFile;
            }
        }
        if ((executableFile = new File(baseDirectory, executable)).isFile()) {
            return executableFile;
        }
        return null;
    }

    public File getLocalRepositoryDirectory() {
        return this.localRepositoryDirectory;
    }

    public void setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
    }

    public InvokerLogger getLogger() {
        return this.logger;
    }

    public void setLogger(InvokerLogger logger) {
        this.logger = logger;
    }

    public File getMavenHome() {
        return this.mavenHome;
    }

    public void setMavenHome(File mavenHome) {
        this.mavenHome = mavenHome;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setMavenExecutable(File mavenExecutable) {
        this.mavenExecutable = mavenExecutable;
    }

    public File getMavenExecutable() {
        return this.mavenExecutable;
    }
}

