/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.checkout;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitTransportConfigCallback;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.jgit.command.ScmProviderAwareSshdSessionFactory;
import org.apache.maven.scm.provider.git.jgit.command.branch.JGitBranchCommand;
import org.apache.maven.scm.provider.git.jgit.command.remoteinfo.JGitRemoteInfoCommand;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;

public class JGitCheckOutCommand
extends AbstractCheckOutCommand
implements GitCommand {
    private BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier = ScmProviderAwareSshdSessionFactory::new;

    public void setSshSessionFactorySupplier(BiFunction<GitScmProviderRepository, Logger, ScmProviderAwareSshdSessionFactory> sshSessionFactorySupplier) {
        this.sshSessionFactorySupplier = sshSessionFactorySupplier;
    }

    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version, boolean recursive, boolean shallow) throws ScmException {
        CheckOutScmResult checkOutScmResult;
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if ("file".equals(repository.getFetchInfo().getProtocol()) && repository.getFetchInfo().getPath().indexOf(fileSet.getBasedir().getPath()) >= 0) {
            throw new ScmException("remote repository must not be the working directory");
        }
        Git git = null;
        try {
            String branch;
            ProgressMonitor monitor = JGitUtils.getMonitor();
            String string = branch = version != null ? version.getName() : null;
            if (StringUtils.isBlank((String)branch)) {
                branch = "master";
            }
            JGitTransportConfigCallback transportConfigCallback = new JGitTransportConfigCallback(this.sshSessionFactorySupplier.apply((GitScmProviderRepository)repo, this.logger));
            this.logger.debug("try checkout of branch: " + branch);
            if (!fileSet.getBasedir().exists() || !new File(fileSet.getBasedir(), ".git").exists()) {
                if (fileSet.getBasedir().exists()) {
                    fileSet.getBasedir().delete();
                }
                WindowCacheConfig cfg = new WindowCacheConfig();
                cfg.setPackedGitMMAP(false);
                cfg.install();
                CredentialsProvider credentials = JGitUtils.getCredentials((GitScmProviderRepository)repo);
                this.logger.info("cloning [" + branch + "] to " + fileSet.getBasedir());
                CloneCommand command = Git.cloneRepository().setURI(repository.getFetchUrl());
                ((CloneCommand)command.setCredentialsProvider(credentials)).setBranch(branch).setDirectory(fileSet.getBasedir());
                command.setTransportConfigCallback((TransportConfigCallback)transportConfigCallback);
                command.setProgressMonitor(monitor);
                git = command.call();
            }
            JGitRemoteInfoCommand remoteInfoCommand = new JGitRemoteInfoCommand();
            remoteInfoCommand.setSshSessionFactorySupplier(this.sshSessionFactorySupplier);
            RemoteInfoScmResult result = remoteInfoCommand.executeRemoteInfoCommand((ScmProviderRepository)repository, fileSet, null);
            if (git == null) {
                git = Git.open((File)fileSet.getBasedir());
            }
            if (fileSet.getBasedir().exists() && new File(fileSet.getBasedir(), ".git").exists() && result.getBranches().size() > 0) {
                PullCommand command;
                CredentialsProvider credentials = JGitUtils.prepareSession(git, repository);
                if (version != null && StringUtils.isNotEmpty((String)version.getName()) && version instanceof ScmTag) {
                    this.logger.debug("fetch...");
                    command = ((FetchCommand)git.fetch().setCredentialsProvider(credentials)).setProgressMonitor(monitor);
                    command.setTransportConfigCallback((TransportConfigCallback)transportConfigCallback);
                    command.call();
                } else {
                    this.logger.debug("pull...");
                    command = ((PullCommand)git.pull().setCredentialsProvider(credentials)).setProgressMonitor(monitor);
                    command.setTransportConfigCallback((TransportConfigCallback)transportConfigCallback);
                    command.call();
                }
            }
            Set<String> localBranchNames = JGitBranchCommand.getShortLocalBranchNames(git);
            if (version instanceof ScmTag) {
                this.logger.info("checkout tag [" + branch + "] at " + fileSet.getBasedir());
                git.checkout().setName(branch).call();
            } else if (localBranchNames.contains(branch)) {
                this.logger.info("checkout [" + branch + "] at " + fileSet.getBasedir());
                git.checkout().setName(branch).call();
            } else {
                this.logger.info("checkout remote branch [" + branch + "] at " + fileSet.getBasedir());
                git.checkout().setName(branch).setCreateBranch(true).setStartPoint("origin/" + branch).call();
            }
            RevWalk revWalk = new RevWalk(git.getRepository());
            RevCommit commit = revWalk.parseCommit((AnyObjectId)git.getRepository().resolve("HEAD"));
            revWalk.close();
            TreeWalk walk = new TreeWalk(git.getRepository());
            walk.reset();
            walk.setRecursive(true);
            walk.addTree((AnyObjectId)commit.getTree());
            ArrayList<ScmFile> listedFiles = new ArrayList<ScmFile>();
            while (walk.next()) {
                listedFiles.add(new ScmFile(walk.getPathString(), ScmFileStatus.CHECKED_OUT));
            }
            walk.close();
            this.logger.debug("current branch: " + git.getRepository().getBranch());
            checkOutScmResult = new CheckOutScmResult("checkout via JGit", listedFiles);
        }
        catch (Exception e) {
            try {
                throw new ScmException("JGit checkout failure!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JGitUtils.closeRepo(git);
                throw throwable;
            }
        }
        JGitUtils.closeRepo(git);
        return checkOutScmResult;
    }
}

