/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import eu.stamp_project.PmpContext;
import eu.stamp_project.plugins.PmpNonEmptyProjectCheck;
import eu.stamp_project.plugins.PmpProject;
import eu.stamp_project.report.MethodThresholds;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.pitest.maven.AbstractPitMojo;
import org.pitest.maven.DependencyFilter;
import org.pitest.maven.GoalStrategy;
import org.pitest.maven.RunPitStrategy;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.tooling.CombinedStatistics;

@Mojo(name="run", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class PmpMojo
extends AbstractPitMojo {
    @Parameter(property="targetModules")
    protected ArrayList<String> targetModules;
    @Parameter(property="skippedModules")
    protected ArrayList<String> skippedModules;
    @Parameter(property="targetDependencies")
    protected ArrayList<String> targetDependencies;
    @Parameter(property="ignoredDependencies")
    protected ArrayList<String> ignoredDependencies;
    @Parameter(property="continueFromModule")
    protected String continueFromModule;
    private static Set<String> alreadyVisitedModules = new HashSet<String>();
    @Parameter(defaultValue="false", property="shouldDisplayOnly")
    protected boolean _ShouldDisplayOnly;
    @Parameter(defaultValue="0", property="pseudoTestedThreshold")
    private int pseudoTestedThreshold;
    @Parameter(defaultValue="0", property="partiallyTestedThreshold")
    private int partiallyTestedThreshold;

    public File getBaseDir() {
        return this.detectBaseDir();
    }

    public boolean shouldDisplayOnly() {
        return this._ShouldDisplayOnly;
    }

    public ArrayList<String> getTargetModules() {
        return this.targetModules;
    }

    public void setTargetModules(ArrayList<String> newClasses) {
        this.targetModules = newClasses;
    }

    public boolean isInTargetModules(String name) {
        boolean result = false;
        for (int i = 0; i < this.getTargetModules().size() && !result; ++i) {
            result = this.getTargetModules().get(i).equals(name);
        }
        return result;
    }

    public ArrayList<String> getSkippedModules() {
        return this.skippedModules;
    }

    public void setSkippedModules(ArrayList<String> newClasses) {
        this.skippedModules = newClasses;
    }

    public boolean isInSkippedModules(MavenProject module) {
        return this.isInSkippedModules(module.getArtifactId());
    }

    public boolean isInSkippedModules(String name) {
        boolean result = false;
        for (int i = 0; i < this.getSkippedModules().size() && !result; ++i) {
            result = this.getSkippedModules().get(i).equals(name);
        }
        return result;
    }

    public ArrayList<String> getTargetDependencies() {
        return this.targetDependencies;
    }

    public void setTargetDependencies(ArrayList<String> moduleList) {
        this.targetDependencies = moduleList;
    }

    public boolean isInTargetDependencies(String name) {
        boolean result = false;
        for (int i = 0; i < this.getTargetDependencies().size() && !result; ++i) {
            result = this.getTargetDependencies().get(i).equals(name);
        }
        return result;
    }

    public ArrayList<String> getIgnoredDependencies() {
        return this.ignoredDependencies;
    }

    public void setIgnoredDependencies(ArrayList<String> moduleList) {
        this.ignoredDependencies = moduleList;
    }

    public boolean isInIgnoredDependencies(String name) {
        boolean result = false;
        for (int i = 0; i < this.getIgnoredDependencies().size() && !result; ++i) {
            result = this.getIgnoredDependencies().get(i).equals(name);
        }
        return result;
    }

    public void setContinueFromModule(String continueFromModule) {
        this.continueFromModule = continueFromModule;
    }

    public String getContinueFromModule() {
        return this.continueFromModule;
    }

    public boolean isContinueFromModuleSatisfied(MavenProject module) {
        if (this.continueFromModule == null) {
            return true;
        }
        return alreadyVisitedModules.contains(this.continueFromModule);
    }

    public PmpMojo() {
        super((GoalStrategy)new RunPitStrategy(), (Predicate)new DependencyFilter(new PluginServices(AbstractPitMojo.class.getClassLoader())), new PluginServices(AbstractPitMojo.class.getClassLoader()), (Predicate)new PmpNonEmptyProjectCheck());
    }

    public void updateTargetClasses() {
        ArrayList<MavenProject> moduleList = null;
        List originaltargetClasses = this.getTargetClasses();
        ArrayList<String> targetClasses = new ArrayList<String>();
        if (originaltargetClasses != null && !originaltargetClasses.isEmpty()) {
            targetClasses.addAll(originaltargetClasses);
        } else {
            targetClasses.addAll(PmpContext.getClasses(this.getProject()));
        }
        moduleList = PmpContext.getInstance().getDependingModules(this.getProject());
        for (int i = 0; i < moduleList.size(); ++i) {
            ArrayList<String> classList;
            MavenProject module = moduleList.get(i);
            if (this.getTargetDependencies().size() != 0 && !this.isInTargetDependencies(module.getArtifactId()) || this.isInIgnoredDependencies(module.getArtifactId()) || (classList = PmpContext.getClasses(module)).isEmpty()) continue;
            PmpContext.addNewStrings(targetClasses, classList);
        }
        this.setTargetClasses(targetClasses);
    }

    public void updateTargetTests() {
        List targetTests = this.getTargetTests();
        if (targetTests == null || targetTests.isEmpty()) {
            this.setTargetTests(PmpContext.getTestClasses(this.getProject()));
        }
    }

    protected Optional<CombinedStatistics> analyse() throws MojoExecutionException {
        Optional<CombinedStatistics> result = null;
        result = Optional.ofNullable(PmpContext.getInstance().getCurrentProject().execute());
        return result;
    }

    protected AbstractPitMojo.RunDecision shouldRun() {
        String message;
        MethodThresholds.getInstance().setPartialyTestedThresold(this.partiallyTestedThreshold);
        MethodThresholds.getInstance().setPseudoTestedThresold(this.pseudoTestedThreshold);
        String projectName = this.getProject().getArtifactId();
        alreadyVisitedModules.add(projectName);
        boolean isTargetModule = this.getTargetModules() == null || this.getTargetModules().isEmpty() || this.isInTargetModules(projectName);
        PmpContext.getInstance().updateData(this);
        PmpProject myPmpProject = new PmpProject(this);
        PmpContext.getInstance().setCurrentProject(myPmpProject);
        this.updateTargetClasses();
        this.updateTargetTests();
        if (this.getProject().getPackaging().equals("pom") && myPmpProject.hasTestCompileSourceRoots().booleanValue() && myPmpProject.hasCompileSourceRoots().booleanValue()) {
            this.getProject().setPackaging("jar");
        }
        AbstractPitMojo.RunDecision theDecision = super.shouldRun();
        if (!isTargetModule) {
            message = projectName + " is not a target module";
            theDecision.addReason(message);
        }
        if (this.isInSkippedModules(projectName)) {
            message = projectName + " is a skipped module";
            theDecision.addReason(message);
        }
        if (!this.isContinueFromModuleSatisfied(this.getProject())) {
            message = projectName + " is before " + this.continueFromModule + " from which the execution shall be continued";
            theDecision.addReason(message);
        }
        if (this.shouldDisplayOnly()) {
            message = "Display only option is true";
            theDecision.addReason(message);
        }
        return theDecision;
    }

    public PluginServices getPlugins() {
        return super.getPlugins();
    }

    public Predicate<Artifact> getFilter() {
        return super.getFilter();
    }
}

