/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.plugins;

import eu.stamp_project.PmpContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.pitest.maven.AbstractPitMojo;
import org.pitest.maven.MojoToReportOptionsConverter;
import org.pitest.maven.PmpMojo;
import org.pitest.maven.SurefireConfigConverter;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.tooling.AnalysisResult;
import org.pitest.mutationtest.tooling.CombinedStatistics;
import org.pitest.mutationtest.tooling.EntryPoint;

public class PmpProject {
    private static final String ISSUES = "ISSUES";
    private static final String METHODS = "METHODS";
    protected PmpMojo _TheMojo = null;
    protected ReportOptions _PitOptions = null;
    protected CombinedStatistics _Results = null;
    protected String _PmpMutationEngine = null;
    protected Boolean _RunningDescartes = false;

    public String getName() {
        return this.getTheMojo().getProject().getArtifactId();
    }

    public String getPmpMutationEngine() {
        return this._PmpMutationEngine;
    }

    public void setPmpMutationEngine(String value) {
        this._PmpMutationEngine = value;
    }

    public Boolean getRunningDescartes() {
        return this._RunningDescartes;
    }

    public void setRunningDescartes(Boolean value) {
        this._RunningDescartes = value;
    }

    public PmpMojo getTheMojo() {
        return this._TheMojo;
    }

    public MavenProject getTheMavenProject() {
        return this.getTheMojo().getProject();
    }

    public ReportOptions getPitOptions() {
        return this._PitOptions;
    }

    public void setPitOptions(ReportOptions options) {
        this._PitOptions = options;
    }

    public CombinedStatistics getResults() {
        return this._Results;
    }

    public ArrayList<String> getSourceDirs() {
        ArrayList<String> completeList = new ArrayList<String>();
        Set dependList = this.getTheMavenProject().getArtifacts();
        Iterator myIt = dependList.iterator();
        this.addSourceDirs(completeList, this.getTheMavenProject());
        while (myIt.hasNext()) {
            Artifact currentDepend = (Artifact)myIt.next();
            MavenProject theProject = PmpContext.getInstance().getMavenProjectFromName(currentDepend.getArtifactId());
            if (theProject == null) continue;
            this.addSourceDirs(completeList, theProject);
        }
        return completeList;
    }

    public ArrayList<String> getDependsCodePaths() {
        ArrayList<String> codePaths = new ArrayList<String>();
        Set dependList = this.getTheMavenProject().getArtifacts();
        for (Artifact currentDepend : dependList) {
            MavenProject theProject = PmpContext.getInstance().getMavenProjectFromName(currentDepend.getArtifactId());
            if (theProject == null) continue;
            codePaths.add(theProject.getBuild().getOutputDirectory());
        }
        return codePaths;
    }

    public ArrayList<String> getDependsClassPathElements() {
        ArrayList<String> completeList = new ArrayList<String>();
        Set dependList = this.getTheMavenProject().getArtifacts();
        for (Artifact currentDepend : dependList) {
            MavenProject dependProject = PmpContext.getInstance().getMavenProjectFromName(currentDepend.getArtifactId());
            if (dependProject != null) {
                completeList.add(dependProject.getBuild().getOutputDirectory());
                completeList.add(dependProject.getBuild().getTestOutputDirectory());
            }
            if (currentDepend.getType().equals("pom")) continue;
            String pathName = currentDepend.getFile().getAbsolutePath();
            completeList.add(pathName);
        }
        return completeList;
    }

    public PmpProject(PmpMojo mojo) {
        this._TheMojo = mojo;
        this._PmpMutationEngine = mojo.getMutationEngine();
        this._RunningDescartes = false;
    }

    public CombinedStatistics execute() throws MojoExecutionException {
        EntryPoint pitEntryPoint = null;
        AnalysisResult execResult = null;
        this.setPitOptions(new MojoToReportOptionsConverter((AbstractPitMojo)this.getTheMojo(), new SurefireConfigConverter(), this.getTheMojo().getFilter()).convert());
        this.modifyReportOptions();
        pitEntryPoint = new EntryPoint();
        execResult = pitEntryPoint.execute(this.getTheMojo().getBaseDir(), this.getPitOptions(), this.getTheMojo().getPlugins(), this.getTheMojo().getEnvironmentVariables());
        if (execResult.getError().isPresent()) {
            throw new MojoExecutionException("fail", (Exception)execResult.getError().get());
        }
        this._Results = (CombinedStatistics)execResult.getStatistics().get();
        return this.getResults();
    }

    private boolean isDefaultNotConfiguredReportOutput() {
        Collection outputFormats = this.getPitOptions().getOutputFormats();
        return outputFormats.isEmpty() || outputFormats.size() == 1 && outputFormats.contains("HTML");
    }

    public void modifyReportOptions() {
        ArrayList<File> fileList = null;
        ArrayList<String> sourceDirList = null;
        ArrayList<String> codePaths = null;
        ArrayList<String> dependsCodePaths = null;
        ArrayList<String> classPathElts = null;
        ArrayList<String> dependsClassPathElts = null;
        ArrayList<String> features = null;
        if (this.getRunningDescartes().booleanValue()) {
            this.setPmpMutationEngine("descartes");
            if (this.isDefaultNotConfiguredReportOutput()) {
                this.getPitOptions().addOutputFormats(Arrays.asList(ISSUES, METHODS));
            }
        } else {
            features = new ArrayList<String>(this.getPitOptions().getFeatures());
            Optional<String> result = features.stream().filter(str -> str.startsWith("+STOP_METHODS")).findAny();
            if (!result.isPresent()) {
                features.add("-STOP_METHODS()");
                this.getPitOptions().setFeatures(features);
            }
        }
        if ((sourceDirList = this.getSourceDirs()) != null && !sourceDirList.isEmpty()) {
            fileList = PmpContext.stringsToFiles(sourceDirList);
            this.getPitOptions().setSourceDirs(fileList);
        }
        dependsCodePaths = this.getDependsCodePaths();
        if (this.getPitOptions().getCodePaths() != null && !this.getPitOptions().getCodePaths().isEmpty()) {
            codePaths = new ArrayList(this.getPitOptions().getCodePaths());
            if (dependsCodePaths != null && !dependsCodePaths.isEmpty()) {
                PmpContext.addNewStrings(codePaths, dependsCodePaths);
            }
        } else {
            codePaths = dependsCodePaths;
        }
        if (codePaths != null && !codePaths.isEmpty()) {
            this.getPitOptions().setCodePaths(codePaths);
        }
        dependsClassPathElts = this.getDependsClassPathElements();
        if (this.getPitOptions().getClassPathElements() != null && !this.getPitOptions().getClassPathElements().isEmpty()) {
            classPathElts = new ArrayList(this.getPitOptions().getClassPathElements());
            if (dependsClassPathElts != null && !dependsClassPathElts.isEmpty()) {
                PmpContext.addNewStrings(classPathElts, dependsClassPathElts);
            }
        } else {
            classPathElts = dependsClassPathElts;
        }
        if (classPathElts != null && !classPathElts.isEmpty()) {
            this.getPitOptions().setClassPathElements(classPathElts);
        }
        this.getPitOptions().setClassPathElements(classPathElts);
        this.getPitOptions().setMutationEngine(this.getPmpMutationEngine());
    }

    public Boolean hasCompileSourceRoots() {
        Boolean result = PmpContext.oneFileExists(this.getTheMojo().getProject().getCompileSourceRoots());
        ArrayList<MavenProject> dependList = PmpContext.getInstance().getDependingModules(this.getTheMojo().getProject());
        Iterator<MavenProject> myIt = dependList.iterator();
        while (myIt.hasNext() && !result.booleanValue()) {
            MavenProject currentModule = myIt.next();
            result = PmpContext.oneFileExists(currentModule.getCompileSourceRoots());
        }
        return result;
    }

    public Boolean hasTestCompileSourceRoots() {
        Boolean result = PmpContext.oneFileExists(this.getTheMojo().getProject().getTestCompileSourceRoots());
        return result;
    }

    public void addSourceDirs(List<String> listToComplete, MavenProject theProject) {
        List nameList = theProject.getCompileSourceRoots();
        if (nameList != null && !nameList.isEmpty()) {
            listToComplete.addAll(nameList);
        }
        if ((nameList = theProject.getTestCompileSourceRoots()) != null && !nameList.isEmpty()) {
            listToComplete.addAll(nameList);
        }
    }

    public void printInfo() {
        System.out.println("#### project: " + this.getName());
        System.out.println("#");
        if (this.getTheMojo().getProject().getParent() != null) {
            System.out.println("# Mvn Parent: " + this.getTheMojo().getProject().getParent().getArtifactId());
        }
        System.out.println("# Mvn all dependencies: " + this.getTheMojo().getProject().getArtifacts());
        System.out.println("");
        System.out.println("####");
    }

    public void printMojoInfo() {
        System.out.println("######## mojo attributes");
        System.out.println("#");
        System.out.println("# targetTests: " + this.getTheMojo().getTargetTests());
        System.out.println("# mutationEngine: " + this.getTheMojo().getMutationEngine());
        System.out.println("# targetClasses: " + this.getTheMojo().getTargetClasses());
        System.out.println("# modified targetClasses: " + this.getTheMojo().getTargetClasses());
        System.out.println("#");
        System.out.println("########");
    }

    public void printOptionsInfo(ReportOptions data) {
        System.out.println("####");
        System.out.println("#### BaseDir: " + this.getTheMojo().getBaseDir());
        System.out.println("#### mutationEngine: " + data.getMutationEngine());
        System.out.println("#### outputFormats: " + data.getOutputFormats());
        System.out.println("#### features: " + data.getFeatures());
        System.out.println("#### targetTests: " + data.getTargetTests());
        System.out.println("#### excludedClasses: " + data.getExcludedClasses());
        System.out.println("#### excludedMethods: " + data.getExcludedMethods());
        System.out.println("#### targetClasses: " + data.getTargetClasses());
        System.out.println("#### codePaths: " + data.getCodePaths());
        System.out.println("#### sourceDirs: " + data.getSourceDirs());
        System.out.println("#### classPathElements: " + data.getClassPathElements());
        System.out.println("####");
    }
}

