/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.interceptors;

import eu.stamp_project.interceptors.DiffInfo;
import java.util.Collection;
import java.util.stream.Collectors;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class DiffMutationFilter
implements MutationInterceptor {
    private ClassTree classTree;
    private DiffInfo diff;

    public DiffMutationFilter(DiffInfo diff) {
        this.diff = diff;
    }

    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    public void begin(ClassTree clazz) {
        this.classTree = clazz;
    }

    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return mutations.stream().filter(mutation -> this.diff.contains(mutation.getClassName().getPackage().asInternalName() + "/" + mutation.getFilename())).collect(Collectors.toList());
    }

    public void end() {
        this.classTree = null;
    }
}

