/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.interceptors;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;

public class DiffInfo {
    private List<String> fileEntries;

    public DiffInfo(BufferedReader reader) {
        try {
            String line;
            this.fileEntries = new LinkedList<String>();
            while ((line = reader.readLine()) != null) {
                int colonIndex = line.indexOf(58);
                this.fileEntries.add(colonIndex < 0 ? line : line.substring(0, colonIndex));
            }
        }
        catch (IOException exc) {
            throw new RuntimeException("Error while reading the diff file", exc);
        }
    }

    public boolean contains(String path) {
        for (String entry : this.fileEntries) {
            if (!entry.endsWith(path)) continue;
            return true;
        }
        return false;
    }

    public static DiffInfo fromFile(String path) {
        try {
            return new DiffInfo(Files.newBufferedReader(Paths.get(path, new String[0])));
        }
        catch (IOException exc) {
            throw new RuntimeException("Could not open file: " + path, exc);
        }
    }
}

