/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.operators;

import eu.stamp_project.mutationtest.descartes.operators.ConstantMutationOperator;
import eu.stamp_project.mutationtest.descartes.operators.EmptyArrayMutationOperator;
import eu.stamp_project.mutationtest.descartes.operators.NullMutationOperator;
import eu.stamp_project.mutationtest.descartes.operators.VoidMutationOperator;
import eu.stamp_project.mutationtest.descartes.operators.WrongOperatorException;
import eu.stamp_project.mutationtest.descartes.operators.parsing.OperatorParser;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.commons.Method;

public abstract class MutationOperator {
    public abstract boolean canMutate(Method var1);

    public abstract void generateCode(Method var1, MethodVisitor var2);

    public abstract String getID();

    public abstract String getDescription();

    public static MutationOperator fromID(String id) {
        OperatorParser parser = new OperatorParser(id);
        Object value = parser.parse();
        if (parser.hasErrors()) {
            throw new WrongOperatorException("Invalid operator id: " + parser.getErrors().get(0));
        }
        if (value == null) {
            return new NullMutationOperator();
        }
        if (value.equals(Void.class)) {
            return new VoidMutationOperator();
        }
        EmptyArrayMutationOperator potentialOperator = new EmptyArrayMutationOperator();
        if (value.equals(potentialOperator.getID())) {
            return potentialOperator;
        }
        try {
            return new ConstantMutationOperator(id, value);
        }
        catch (IllegalArgumentException exc) {
            throw new WrongOperatorException("Invalid operator id", exc);
        }
    }
}

