/*
 * Decompiled with CFR 0.152.
 */
package de.tototec.cmdoption;

import de.tototec.cmdoption.CmdlineModel;
import de.tototec.cmdoption.CmdlineParser;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandHandle {
    private final String[] names;
    private final String description;
    private final CmdlineParser cmdlineParser;
    private final Object object;
    private final boolean hidden;

    public CommandHandle(String[] names, String description, CmdlineParser cmdlineParser, Object object, boolean hidden) {
        this.names = names;
        this.description = description;
        this.cmdlineParser = cmdlineParser;
        this.object = object;
        this.hidden = hidden;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getDescription() {
        return this.description;
    }

    public CmdlineParser getCmdlineParser() {
        return this.cmdlineParser;
    }

    public CmdlineModel getCommandCmdlineModel() {
        return this.cmdlineParser.getCmdlineModel();
    }

    public Object getObject() {
        return this.object;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommandHandleComparator
    implements Comparator<CommandHandle> {
        @Override
        public int compare(CommandHandle c1, CommandHandle c2) {
            return this.sanitizeString(c1.getNames()[0]).compareTo(this.sanitizeString(c2.getNames()[0]));
        }

        public String sanitizeString(String string) {
            Pattern pattern = Pattern.compile("^[^A-Za-z0-9]*(.*)$");
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            return string;
        }
    }
}

