/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.writers;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.pmw.tinylog.Configuration;
import org.pmw.tinylog.EnvironmentHelper;
import org.pmw.tinylog.InternalLogger;
import org.pmw.tinylog.LogEntry;
import org.pmw.tinylog.writers.LogEntryValue;
import org.pmw.tinylog.writers.PropertiesSupport;
import org.pmw.tinylog.writers.Property;
import org.pmw.tinylog.writers.VMShutdownHook;
import org.pmw.tinylog.writers.Writer;

@PropertiesSupport(name="jdbc", properties={@Property(name="url", type=String.class), @Property(name="table", type=String.class), @Property(name="columns", type=String[].class, optional=true), @Property(name="values", type=String[].class), @Property(name="batch", type=boolean.class, optional=true), @Property(name="username", type=String.class, optional=true), @Property(name="password", type=String.class, optional=true), @Property(name="reconnect", type=int.class, optional=true)})
public final class JdbcWriter
implements Writer {
    private static final int MAX_BATCH_SIZE = 128;
    private static final String NEW_LINE = EnvironmentHelper.getNewLine();
    private final String url;
    private final String table;
    private final List<String> columns;
    private final List<Value> values;
    private final Set<LogEntryValue> requiredLogEntryValues;
    private final boolean batchMode;
    private final String username;
    private final String password;
    private final long interval;
    private final Object lock = new Object();
    private String sql;
    private volatile Connection connection;
    private PreparedStatement statement;
    private int batchCount;
    private long lostTimestamp;

    public JdbcWriter(String string, String string2, List<Value> list) {
        this(string, string2, null, list, false, null, null, -1);
    }

    public JdbcWriter(String string, String string2, List<Value> list, boolean bl) {
        this(string, string2, null, list, bl, null, null, -1);
    }

    public JdbcWriter(String string, String string2, List<Value> list, boolean bl, int n) {
        this(string, string2, null, list, bl, null, null, n);
    }

    public JdbcWriter(String string, String string2, List<Value> list, String string3, String string4) {
        this(string, string2, null, list, false, string3, string4, -1);
    }

    public JdbcWriter(String string, String string2, List<Value> list, boolean bl, String string3, String string4) {
        this(string, string2, null, list, bl, string3, string4, -1);
    }

    public JdbcWriter(String string, String string2, List<Value> list, boolean bl, String string3, String string4, int n) {
        this(string, string2, null, list, bl, string3, string4, n);
    }

    public JdbcWriter(String string, String string2, List<String> list, List<Value> list2) {
        this(string, string2, list, list2, false, null, null, -1);
    }

    public JdbcWriter(String string, String string2, List<String> list, List<Value> list2, boolean bl) {
        this(string, string2, list, list2, bl, null, null, -1);
    }

    public JdbcWriter(String string, String string2, List<String> list, List<Value> list2, boolean bl, int n) {
        this(string, string2, list, list2, bl, null, null, n);
    }

    public JdbcWriter(String string, String string2, List<String> list, List<Value> list2, String string3, String string4) {
        this(string, string2, list, list2, false, string3, string4, -1);
    }

    public JdbcWriter(String string, String string2, List<String> list, List<Value> list2, boolean bl, String string3, String string4) {
        this(string, string2, list, list2, bl, string3, string4, -1);
    }

    public JdbcWriter(String string, String string2, List<String> list, List<Value> list2, boolean bl, String string3, String string4, int n) {
        this.url = string;
        this.table = string2;
        this.columns = list;
        this.values = list2;
        this.requiredLogEntryValues = JdbcWriter.calculateRequiredLogEntryValues(list2);
        this.batchMode = bl;
        this.username = string3;
        this.password = string4;
        this.interval = (long)n * 1000L;
    }

    JdbcWriter(String string, String string2, String[] stringArray, String[] stringArray2, String string3, String string4) {
        this(string, string2, stringArray == null ? null : Arrays.asList(stringArray), JdbcWriter.renderValues(stringArray2), false, string3, string4, -1);
    }

    JdbcWriter(String string, String string2, String[] stringArray, String[] stringArray2, String string3, String string4, int n) {
        this(string, string2, stringArray == null ? null : Arrays.asList(stringArray), JdbcWriter.renderValues(stringArray2), false, string3, string4, n);
    }

    JdbcWriter(String string, String string2, String[] stringArray, String[] stringArray2, boolean bl, String string3, String string4) {
        this(string, string2, stringArray == null ? null : Arrays.asList(stringArray), JdbcWriter.renderValues(stringArray2), bl, string3, string4, -1);
    }

    JdbcWriter(String string, String string2, String[] stringArray, String[] stringArray2, boolean bl, String string3, String string4, int n) {
        this(string, string2, stringArray == null ? null : Arrays.asList(stringArray), JdbcWriter.renderValues(stringArray2), bl, string3, string4, n);
    }

    public String getUrl() {
        return this.url;
    }

    public String getTable() {
        return this.table;
    }

    public List<String> getColumns() {
        return this.columns == null ? null : Collections.unmodifiableList(this.columns);
    }

    public List<Value> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public long getReconnetInterval() {
        return this.interval;
    }

    @Override
    public Set<LogEntryValue> getRequiredLogEntryValues() {
        return this.requiredLogEntryValues;
    }

    @Override
    public void init(Configuration configuration) throws SQLException, NamingException {
        if (this.columns != null && this.columns.size() != this.values.size()) {
            throw new SQLException("Number of columns and values must be equal, but columns = " + this.columns.size() + " and values = " + this.values.size());
        }
        this.connect();
        VMShutdownHook.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LogEntry logEntry) throws SQLException {
        this.repairConnectionIfBroken();
        Object object = this.lock;
        synchronized (object) {
            if (this.connection != null) {
                if (this.batchMode) {
                    try {
                        if (this.batchCount >= 128) {
                            this.executeBatch();
                        }
                        JdbcWriter.fillStatement(this.statement, this.values, logEntry);
                        this.statement.addBatch();
                        ++this.batchCount;
                    }
                    catch (SQLException sQLException) {
                        this.failed(sQLException);
                    }
                } else {
                    try {
                        JdbcWriter.fillStatement(this.statement, this.values, logEntry);
                        this.statement.executeUpdate();
                    }
                    catch (SQLException sQLException) {
                        this.failed(sQLException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws SQLException {
        if (this.batchMode) {
            Object object = this.lock;
            synchronized (object) {
                if (this.connection != null && this.batchCount > 0) {
                    this.executeBatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        VMShutdownHook.unregister(this);
        Object object = this.lock;
        synchronized (object) {
            if (this.connection != null) {
                this.flush();
                this.connection.close();
            }
        }
    }

    private static Set<LogEntryValue> calculateRequiredLogEntryValues(List<Value> list) {
        EnumSet<LogEntryValue> enumSet = EnumSet.noneOf(LogEntryValue.class);
        for (Value value : list) {
            enumSet.add(value.requiredLogEntryValue);
        }
        return enumSet;
    }

    private static List<Value> renderValues(String[] stringArray) {
        ArrayList<Value> arrayList = new ArrayList<Value>(stringArray.length);
        for (String string : stringArray) {
            if ("date".equalsIgnoreCase(string)) {
                arrayList.add(Value.DATE);
                continue;
            }
            if ("pid".equalsIgnoreCase(string)) {
                arrayList.add(Value.PROCESS_ID);
                continue;
            }
            if ("thread".equalsIgnoreCase(string)) {
                arrayList.add(Value.THREAD_NAME);
                continue;
            }
            if ("thread_id".equalsIgnoreCase(string)) {
                arrayList.add(Value.THREAD_ID);
                continue;
            }
            if ("context".equalsIgnoreCase(string)) {
                arrayList.add(Value.CONTEXT);
                continue;
            }
            if ("class".equalsIgnoreCase(string)) {
                arrayList.add(Value.CLASS);
                continue;
            }
            if ("class_name".equalsIgnoreCase(string)) {
                arrayList.add(Value.CLASS_NAME);
                continue;
            }
            if ("package".equalsIgnoreCase(string)) {
                arrayList.add(Value.PACKAGE);
                continue;
            }
            if ("method".equalsIgnoreCase(string)) {
                arrayList.add(Value.METHOD);
                continue;
            }
            if ("file".equalsIgnoreCase(string)) {
                arrayList.add(Value.FILE);
                continue;
            }
            if ("line".equalsIgnoreCase(string)) {
                arrayList.add(Value.LINE);
                continue;
            }
            if ("level".equalsIgnoreCase(string)) {
                arrayList.add(Value.LEVEL);
                continue;
            }
            if ("message".equalsIgnoreCase(string)) {
                arrayList.add(Value.MESSAGE);
                continue;
            }
            if ("exception".equalsIgnoreCase(string)) {
                arrayList.add(Value.EXCEPTION);
                continue;
            }
            if ("log_entry".equalsIgnoreCase(string)) {
                arrayList.add(Value.RENDERED_LOG_ENTRY);
                continue;
            }
            InternalLogger.warn("Unknown value type: \"{}\"", string);
        }
        return arrayList;
    }

    private static String renderSql(Connection connection, String string, List<String> list, List<Value> list2) throws SQLException {
        char c;
        int n;
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("INSERT INTO ");
        String string2 = connection.getMetaData().getIdentifierQuoteString();
        if (string2 == null || string2.trim().length() == 0) {
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c2 == '\n' || c2 == '\r') {
                    throw new SQLException("Table name contains line breaks: " + string);
                }
                if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '@' || c2 == '$' || c2 == '#') continue;
                throw new SQLException("Illegal table name: " + string);
            }
            stringBuilder.append(string);
            if (list != null) {
                stringBuilder.append(" (");
                ListIterator<String> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    if (listIterator.hasPrevious()) {
                        stringBuilder.append(", ");
                    }
                    String string3 = listIterator.next();
                    for (n = 0; n < string3.length(); ++n) {
                        c = string3.charAt(n);
                        if (c == '\n' || c == '\r') {
                            throw new SQLException("Column name contains line breaks: " + string3);
                        }
                        if (Character.isLetterOrDigit(c) || c == '_' || c == '@' || c == '$' || c == '#') continue;
                        throw new SQLException("Illegal column name: " + string3);
                    }
                    stringBuilder.append(string3);
                }
                stringBuilder.append(")");
            }
        } else {
            for (int i = 0; i < string.length(); ++i) {
                char c3 = string.charAt(i);
                if (c3 != '\n' && c3 != '\r') continue;
                throw new SQLException("Table name contains line breaks: " + string);
            }
            stringBuilder.append(string2).append(string.replace(string2, string2 + string2)).append(string2);
            if (list != null) {
                stringBuilder.append(" (");
                ListIterator<String> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    if (listIterator.hasPrevious()) {
                        stringBuilder.append(", ");
                    }
                    String string4 = listIterator.next();
                    for (n = 0; n < string4.length(); ++n) {
                        c = string4.charAt(n);
                        if (c != '\n' && c != '\r') continue;
                        throw new SQLException("Column name contains line breaks: " + string4);
                    }
                    stringBuilder.append(string2).append(string4.replace(string2, string2 + string2)).append(string2);
                }
                stringBuilder.append(")");
            }
        }
        stringBuilder.append(" VALUES (");
        for (int i = 0; i < list2.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ?");
                continue;
            }
            stringBuilder.append("?");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static String getNameOfClass(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static String getPackageOfClass(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    private static String formatMap(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder(256);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static String formatException(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        JdbcWriter.formatExceptionWithStackTrace(stringBuilder, throwable);
        return stringBuilder.toString();
    }

    private static void formatExceptionWithStackTrace(StringBuilder stringBuilder, Throwable throwable) {
        stringBuilder.append(throwable.getClass().getName());
        String string = throwable.getMessage();
        if (string != null) {
            stringBuilder.append(": ");
            stringBuilder.append(string);
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuilder.append(NEW_LINE);
            stringBuilder.append('\t');
            stringBuilder.append("at ");
            stringBuilder.append(stackTraceElementArray[i]);
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            stringBuilder.append(NEW_LINE);
            stringBuilder.append("Caused by: ");
            JdbcWriter.formatExceptionWithStackTrace(stringBuilder, throwable2);
        }
    }

    private static void fillStatement(PreparedStatement preparedStatement, List<Value> list, LogEntry logEntry) throws SQLException {
        block17: for (int i = 0; i < list.size(); ++i) {
            switch (list.get(i)) {
                case DATE: {
                    preparedStatement.setTimestamp(i + 1, logEntry.getTimestamp());
                    continue block17;
                }
                case PROCESS_ID: {
                    preparedStatement.setString(i + 1, logEntry.getProcessId());
                    continue block17;
                }
                case THREAD_NAME: {
                    preparedStatement.setString(i + 1, logEntry.getThread().getName());
                    continue block17;
                }
                case THREAD_ID: {
                    preparedStatement.setLong(i + 1, logEntry.getThread().getId());
                    continue block17;
                }
                case CONTEXT: {
                    Map<String, String> map = logEntry.getContext();
                    if (map == null || map.isEmpty()) {
                        preparedStatement.setNull(i + 1, 12);
                        continue block17;
                    }
                    preparedStatement.setString(i + 1, JdbcWriter.formatMap(map));
                    continue block17;
                }
                case CLASS: {
                    preparedStatement.setString(i + 1, logEntry.getClassName());
                    continue block17;
                }
                case CLASS_NAME: {
                    preparedStatement.setString(i + 1, JdbcWriter.getNameOfClass(logEntry.getClassName()));
                    continue block17;
                }
                case PACKAGE: {
                    preparedStatement.setString(i + 1, JdbcWriter.getPackageOfClass(logEntry.getClassName()));
                    continue block17;
                }
                case METHOD: {
                    if (logEntry.getMethodName() == null) {
                        preparedStatement.setNull(i + 1, 12);
                        continue block17;
                    }
                    preparedStatement.setString(i + 1, logEntry.getMethodName());
                    continue block17;
                }
                case FILE: {
                    if (logEntry.getFilename() == null) {
                        preparedStatement.setNull(i + 1, 12);
                        continue block17;
                    }
                    preparedStatement.setString(i + 1, logEntry.getFilename());
                    continue block17;
                }
                case LINE: {
                    if (logEntry.getLineNumber() < 0) {
                        preparedStatement.setNull(i + 1, 12);
                        continue block17;
                    }
                    preparedStatement.setInt(i + 1, logEntry.getLineNumber());
                    continue block17;
                }
                case LEVEL: {
                    preparedStatement.setString(i + 1, logEntry.getLevel().name());
                    continue block17;
                }
                case MESSAGE: {
                    if (logEntry.getMessage() == null) {
                        preparedStatement.setNull(i + 1, 12);
                        continue block17;
                    }
                    preparedStatement.setString(i + 1, logEntry.getMessage());
                    continue block17;
                }
                case EXCEPTION: {
                    if (logEntry.getException() == null) {
                        preparedStatement.setNull(i + 1, 12);
                        continue block17;
                    }
                    preparedStatement.setString(i + 1, JdbcWriter.formatException(logEntry.getException()));
                    continue block17;
                }
                case RENDERED_LOG_ENTRY: {
                    String string = logEntry.getRenderedLogEntry();
                    if (string.endsWith(NEW_LINE)) {
                        string = string.substring(0, string.length() - NEW_LINE.length());
                    }
                    preparedStatement.setString(i + 1, string);
                    continue block17;
                }
                default: {
                    InternalLogger.warn("Unknown value type: \"{}\"", new Object[]{list.get(i)});
                }
            }
        }
    }

    private void connect() throws SQLException, NamingException {
        if (this.url.toLowerCase(Locale.ENGLISH).startsWith("java:")) {
            DataSource dataSource = (DataSource)new InitialContext().lookup(this.url);
            this.connection = this.username == null ? dataSource.getConnection() : dataSource.getConnection(this.username, this.password);
        } else {
            this.connection = this.username == null ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.username, this.password);
        }
        if (this.sql == null) {
            this.sql = JdbcWriter.renderSql(this.connection, this.table, this.columns, this.values);
        }
        this.statement = this.connection.prepareStatement(this.sql);
        if (this.batchMode) {
            this.batchCount = 0;
        }
    }

    private void executeBatch() throws SQLException {
        this.statement.executeBatch();
        this.batchCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairConnectionIfBroken() {
        if (this.connection == null && this.interval >= 0L) {
            Object object = this.lock;
            synchronized (object) {
                if (this.connection == null && System.currentTimeMillis() >= this.lostTimestamp + this.interval) {
                    try {
                        this.connect();
                        InternalLogger.error("Broken database connection has been reestablished");
                    }
                    catch (SQLException sQLException) {
                        this.connection = null;
                        this.lostTimestamp = System.currentTimeMillis();
                    }
                    catch (NamingException namingException) {
                        this.connection = null;
                        this.lostTimestamp = System.currentTimeMillis();
                    }
                }
            }
        }
    }

    private void failed(SQLException sQLException) {
        this.lostTimestamp = System.currentTimeMillis();
        InternalLogger.error(sQLException, "Database connection is broken");
        try {
            this.connection.close();
        }
        catch (SQLException sQLException2) {
        }
        finally {
            this.connection = null;
        }
    }

    public static enum Value {
        DATE(LogEntryValue.PRECISE_DATE),
        PROCESS_ID(LogEntryValue.PROCESS_ID),
        THREAD_NAME(LogEntryValue.THREAD),
        THREAD_ID(LogEntryValue.THREAD),
        CONTEXT(LogEntryValue.CONTEXT),
        CLASS(LogEntryValue.CLASS),
        CLASS_NAME(LogEntryValue.CLASS),
        PACKAGE(LogEntryValue.CLASS),
        METHOD(LogEntryValue.METHOD),
        FILE(LogEntryValue.FILE),
        LINE(LogEntryValue.LINE),
        LEVEL(LogEntryValue.LEVEL),
        MESSAGE(LogEntryValue.MESSAGE),
        EXCEPTION(LogEntryValue.EXCEPTION),
        RENDERED_LOG_ENTRY(LogEntryValue.RENDERED_LOG_ENTRY);

        private final LogEntryValue requiredLogEntryValue;

        private Value(LogEntryValue logEntryValue) {
            this.requiredLogEntryValue = logEntryValue;
        }
    }
}

