/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.writers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Set;
import org.pmw.tinylog.Configuration;
import org.pmw.tinylog.EnvironmentHelper;
import org.pmw.tinylog.LogEntry;
import org.pmw.tinylog.writers.LogEntryValue;
import org.pmw.tinylog.writers.PathResolver;
import org.pmw.tinylog.writers.PropertiesSupport;
import org.pmw.tinylog.writers.Property;
import org.pmw.tinylog.writers.VMShutdownHook;
import org.pmw.tinylog.writers.Writer;

@PropertiesSupport(name="file", properties={@Property(name="filename", type=String.class), @Property(name="buffered", type=boolean.class, optional=true), @Property(name="append", type=boolean.class, optional=true)})
public final class FileWriter
implements Writer {
    private static final int BUFFER_SIZE = 65536;
    private final String filename;
    private final boolean buffered;
    private final boolean append;
    private OutputStream stream;

    public FileWriter(String string) {
        this(string, false, false);
    }

    public FileWriter(String string, boolean bl) {
        this(string, bl, false);
    }

    public FileWriter(String string, boolean bl, boolean bl2) {
        this.filename = PathResolver.resolve(string);
        this.buffered = bl;
        this.append = bl2;
    }

    FileWriter(String string, Boolean bl, Boolean bl2) {
        this.filename = PathResolver.resolve(string);
        this.buffered = bl == null ? false : bl;
        this.append = bl2 == null ? false : bl2;
    }

    @Override
    public Set<LogEntryValue> getRequiredLogEntryValues() {
        return EnumSet.of(LogEntryValue.RENDERED_LOG_ENTRY);
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public boolean isAppending() {
        return this.append;
    }

    @Override
    public void init(Configuration configuration) throws IOException {
        File file = new File(this.filename);
        EnvironmentHelper.makeDirectories(file);
        this.stream = this.buffered ? new BufferedOutputStream(new FileOutputStream(file, this.append), 65536) : new FileOutputStream(file, this.append);
        VMShutdownHook.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LogEntry logEntry) throws IOException {
        byte[] byArray = logEntry.getRenderedLogEntry().getBytes();
        OutputStream outputStream = this.stream;
        synchronized (outputStream) {
            this.stream.write(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.buffered) {
            OutputStream outputStream = this.stream;
            synchronized (outputStream) {
                this.stream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        OutputStream outputStream = this.stream;
        synchronized (outputStream) {
            VMShutdownHook.unregister(this);
            this.stream.close();
        }
    }
}

