/*
 * Decompiled with CFR 0.152.
 */
package org.pmw.tinylog.policies;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pmw.tinylog.Configuration;
import org.pmw.tinylog.policies.Policy;
import org.pmw.tinylog.policies.PropertiesSupport;

@PropertiesSupport(name="count")
public final class CountPolicy
implements Policy {
    private static final Pattern NEW_LINE_PATTERN = Pattern.compile("\r\n|\\\\r\\\\n|\n|\\\\n|\r|\\\\r");
    private final long limit;
    private long lines;
    private long count;

    public CountPolicy(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("limit must be > 0");
        }
        this.limit = l;
        this.count = 0L;
    }

    CountPolicy(String string) throws IllegalArgumentException {
        try {
            this.limit = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Size \"" + string + "\" is not numberic");
        }
        if (this.limit <= 0L) {
            throw new IllegalArgumentException("Size must be > 0, but is " + this.limit);
        }
        this.count = 0L;
    }

    @Override
    public void init(Configuration configuration) {
        String string = configuration.getFormatPattern();
        Matcher matcher = NEW_LINE_PATTERN.matcher(string);
        this.lines = 1L;
        while (matcher.find()) {
            ++this.lines;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(File file) throws IOException {
        if (file.exists()) {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
            try {
                lineNumberReader.skip(Long.MAX_VALUE);
                this.count = (long)lineNumberReader.getLineNumber() / this.lines;
                boolean bl = this.count <= this.limit;
                return bl;
            }
            finally {
                lineNumberReader.close();
            }
        }
        return true;
    }

    @Override
    public boolean check(String string) {
        ++this.count;
        return this.count <= this.limit;
    }

    @Override
    public void reset() {
        this.count = 0L;
    }
}

