/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.feed;

import com.rometools.fetcher.FeedFetcher;
import java.net.URL;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.feed.inbound.FeedEntryMessageSource;
import org.springframework.integration.metadata.MetadataStore;

public class FeedEntryMessageSourceSpec
extends MessageSourceSpec<FeedEntryMessageSourceSpec, FeedEntryMessageSource> {
    private final URL feedUrl;
    private final String metadataKey;
    private FeedFetcher feedFetcher;
    private MetadataStore metadataStore;

    FeedEntryMessageSourceSpec(URL feedUrl, String metadataKey) {
        this.feedUrl = feedUrl;
        this.metadataKey = metadataKey;
    }

    public FeedEntryMessageSourceSpec feedFetcher(FeedFetcher feedFetcher) {
        this.feedFetcher = feedFetcher;
        return this;
    }

    public FeedEntryMessageSourceSpec metadataStore(MetadataStore metadataStore) {
        this.metadataStore = metadataStore;
        return this;
    }

    @Override
    protected FeedEntryMessageSource doGet() {
        FeedEntryMessageSource feedEntryMessageSource = this.feedFetcher == null ? new FeedEntryMessageSource(this.feedUrl, this.metadataKey) : new FeedEntryMessageSource(this.feedUrl, this.metadataKey, this.feedFetcher);
        if (this.metadataStore != null) {
            feedEntryMessageSource.setMetadataStore(this.metadataStore);
        }
        return feedEntryMessageSource;
    }
}

