/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.integration.channel.interceptor.WireTap;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.IntegrationComponentSpec;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class WireTapSpec
extends IntegrationComponentSpec<WireTapSpec, WireTap>
implements ComponentsRegistration {
    private final MessageChannel channel;
    private MessageSelector selector;
    private Long timeout;

    WireTapSpec(MessageChannel channel) {
        Assert.notNull((Object)channel, (String)"'channel' must not be null");
        this.channel = channel;
    }

    public WireTapSpec selector(String selectorExpression) {
        this.selector = new ExpressionEvaluatingSelector(PARSER.parseExpression(selectorExpression));
        return this;
    }

    public WireTapSpec selector(MessageSelector selector) {
        this.selector = selector;
        return this;
    }

    public WireTapSpec timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    protected WireTap doGet() {
        WireTap wireTap = new WireTap(this.channel, this.selector);
        if (this.timeout != null) {
            wireTap.setTimeout(this.timeout.longValue());
        }
        return wireTap;
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        if (this.selector != null) {
            return Arrays.asList(this.selector, this.target);
        }
        return Collections.singletonList(this.target);
    }
}

