/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management.micrometer;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.function.Function;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.support.management.AbstractMessageChannelMetrics;
import org.springframework.integration.support.management.AbstractMessageHandlerMetrics;
import org.springframework.integration.support.management.DefaultMessageChannelMetrics;
import org.springframework.integration.support.management.DefaultMessageHandlerMetrics;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.MessageSourceMetricsConfigurer;
import org.springframework.integration.support.management.MetricsFactory;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;

@Deprecated
public class MicrometerMetricsFactory
implements MetricsFactory,
MessageSourceMetricsConfigurer,
ApplicationContextAware,
SmartInitializingSingleton {
    private static final Function<String, String[]> NO_TAGS = n -> new String[0];
    private final MeterRegistry meterRegistry;
    private ApplicationContext applicationContext;
    private Function<String, String> timerNameProvider = n -> n + ".timer";
    private Function<String, String> counterNameProvider = n -> n + ".counter";
    private Function<String, String> errorCounterNameProvider = n -> n + ".errorCounter";
    private Function<String, String> receiveCounterNameProvider = n -> n + ".receive.counter";
    private Function<String, String> receiveErrorCounterNameProvider = n -> n + ".receive.errorCounter";
    private Function<String, String[]> timerTagProvider = NO_TAGS;
    private Function<String, String[]> counterTagProvider = NO_TAGS;
    private Function<String, String[]> errorCounterTagProvider = NO_TAGS;
    private Function<String, String[]> receiveCounterTagProvider = NO_TAGS;
    private Function<String, String[]> receiveErrorCounterTagProvider = NO_TAGS;
    private Function<String, String[]> componentCountTagProvider = NO_TAGS;

    public MicrometerMetricsFactory(MeterRegistry meterRegistry) {
        Assert.notNull((Object)meterRegistry, (String)"'meterRegistry' cannot be null");
        this.meterRegistry = meterRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Assert.notNull((Object)this.applicationContext, (String)"An application context is required");
        this.registerComponentGauges();
    }

    public void setTimerNameProvider(Function<String, String> timerNameProvider) {
        Assert.notNull(timerNameProvider, (String)"'timerNameProvider' cannot be null");
        this.timerNameProvider = timerNameProvider;
    }

    public void setCounterNameProvider(Function<String, String> counterNameProvider) {
        Assert.notNull(counterNameProvider, (String)"'counterNameProvider' cannot be null");
        this.counterNameProvider = counterNameProvider;
    }

    public void setErrorCounterNameProvider(Function<String, String> errorCounterNameProvider) {
        Assert.notNull(errorCounterNameProvider, (String)"'errorCounterNameProvider' cannot be null");
        this.errorCounterNameProvider = errorCounterNameProvider;
    }

    public void setReceiveCounterNameProvider(Function<String, String> counterNameProvider) {
        Assert.notNull(counterNameProvider, (String)"'counterNameProvider' cannot be null");
        this.receiveCounterNameProvider = counterNameProvider;
    }

    public void setReceiveErrorCounterNameProvider(Function<String, String> errorCounterNameProvider) {
        Assert.notNull(errorCounterNameProvider, (String)"'errorCounterNameProvider' cannot be null");
        this.receiveErrorCounterNameProvider = errorCounterNameProvider;
    }

    public void setTimerTagProvider(Function<String, String[]> timerTagProvider) {
        Assert.notNull(timerTagProvider, (String)"'timerTagProvider' cannot be null");
        this.timerTagProvider = timerTagProvider;
    }

    public void setCounterTagProvider(Function<String, String[]> counterTagProvider) {
        Assert.notNull(counterTagProvider, (String)"'counterTagProvider' cannot be null");
        this.counterTagProvider = counterTagProvider;
    }

    public void setErrorCounterTagProvider(Function<String, String[]> counterTagProvider) {
        Assert.notNull(counterTagProvider, (String)"'counterTagProvider' cannot be null");
        this.errorCounterTagProvider = counterTagProvider;
    }

    public void setReceiveCounterTagProvider(Function<String, String[]> counterTagProvider) {
        Assert.notNull(counterTagProvider, (String)"'counterTagProvider' cannot be null");
        this.receiveCounterTagProvider = counterTagProvider;
    }

    public void setReceiveErrorCounterTagProvider(Function<String, String[]> counterTagProvider) {
        Assert.notNull(counterTagProvider, (String)"'counterTagProvider' cannot be null");
        this.receiveErrorCounterTagProvider = counterTagProvider;
    }

    public void setComponentCountTagProvider(Function<String, String[]> componentCountTagProvider) {
        this.componentCountTagProvider = componentCountTagProvider;
    }

    @Override
    public AbstractMessageChannelMetrics createChannelMetrics(String name) {
        return new DefaultMessageChannelMetrics(name, this.meterRegistry.timer(this.timerNameProvider.apply(name), this.timerTagProvider.apply(name)), this.meterRegistry.counter(this.errorCounterNameProvider.apply(name), this.errorCounterTagProvider.apply(name)), null, null);
    }

    @Override
    public AbstractMessageChannelMetrics createPollableChannelMetrics(String name) {
        return new DefaultMessageChannelMetrics(name, this.meterRegistry.timer(this.timerNameProvider.apply(name), this.timerTagProvider.apply(name)), this.meterRegistry.counter(this.errorCounterNameProvider.apply(name), this.errorCounterTagProvider.apply(name)), this.meterRegistry.counter(this.receiveCounterNameProvider.apply(name), this.receiveCounterTagProvider.apply(name)), this.meterRegistry.counter(this.receiveErrorCounterNameProvider.apply(name), this.receiveErrorCounterTagProvider.apply(name)));
    }

    @Override
    public AbstractMessageHandlerMetrics createHandlerMetrics(String name) {
        return new DefaultMessageHandlerMetrics(name, this.meterRegistry.timer(this.timerNameProvider.apply(name), this.timerTagProvider.apply(name)), this.meterRegistry.counter(this.errorCounterNameProvider.apply(name), this.errorCounterTagProvider.apply(name)));
    }

    @Override
    public void configure(MessageSourceMetrics metrics, String name) {
        metrics.setCounter(this.meterRegistry.counter(this.counterNameProvider.apply(name), this.counterTagProvider.apply(name)));
    }

    private void registerComponentGauges() {
        Gauge.Builder builder = Gauge.builder((String)"spring.integration.channels", (Object)this, c -> this.applicationContext.getBeansOfType(MessageChannel.class).size());
        builder.tags(this.componentCountTagProvider.apply("channels")).description("The Number of Message Channels").register(this.meterRegistry);
        builder = Gauge.builder((String)"spring.integration.handlers", (Object)this, c -> this.applicationContext.getBeansOfType(MessageHandler.class).size());
        builder.tags(this.componentCountTagProvider.apply("handlers")).description("The Number of Message Handlers").register(this.meterRegistry);
        builder = Gauge.builder((String)"spring.integration.sources", (Object)this, c -> this.applicationContext.getBeansOfType(MessageSource.class).size());
        builder.tags(this.componentCountTagProvider.apply("sources")).description("The number of Message Sources").register(this.meterRegistry);
    }
}

