/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.integration.support.management.AbstractMessageHandlerMetrics;
import org.springframework.integration.support.management.ExponentialMovingAverage;
import org.springframework.integration.support.management.MetricsContext;
import org.springframework.integration.support.management.Statistics;

public class DefaultMessageHandlerMetrics
extends AbstractMessageHandlerMetrics {
    private static final int DEFAULT_MOVING_AVERAGE_WINDOW = 10;
    protected final AtomicLong activeCount = new AtomicLong();
    protected final AtomicLong handleCount = new AtomicLong();
    protected final AtomicLong errorCount = new AtomicLong();
    protected final ExponentialMovingAverage duration;

    public DefaultMessageHandlerMetrics() {
        this(null);
    }

    public DefaultMessageHandlerMetrics(String name) {
        this(name, null, null);
    }

    public DefaultMessageHandlerMetrics(String name, Timer timer, Counter errorCounter) {
        this(name, new ExponentialMovingAverage(10, 1000000.0), timer, errorCounter);
    }

    public DefaultMessageHandlerMetrics(String name, ExponentialMovingAverage duration) {
        this(name, duration, null, null);
    }

    public DefaultMessageHandlerMetrics(String name, ExponentialMovingAverage duration, Timer timer, Counter errorCounter) {
        super(name, timer, errorCounter);
        this.duration = duration;
    }

    @Override
    public MetricsContext beforeHandle() {
        long start = 0L;
        if (this.isFullStatsEnabled()) {
            start = System.nanoTime();
        }
        this.handleCount.incrementAndGet();
        this.activeCount.incrementAndGet();
        return new DefaultHandlerMetricsContext(start);
    }

    @Override
    public void afterHandle(MetricsContext context, boolean success) {
        this.activeCount.decrementAndGet();
        if (this.isFullStatsEnabled() && success) {
            this.duration.append(System.nanoTime() - ((DefaultHandlerMetricsContext)context).start);
        } else if (!success) {
            this.errorCount.incrementAndGet();
        }
    }

    @Override
    public synchronized void reset() {
        this.duration.reset();
        this.errorCount.set(0L);
        this.handleCount.set(0L);
    }

    @Override
    public long getHandleCountLong() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Getting Handle Count:" + this));
        }
        return this.handleCount.get();
    }

    @Override
    public int getHandleCount() {
        return (int)this.getHandleCountLong();
    }

    @Override
    public int getErrorCount() {
        return (int)this.errorCount.get();
    }

    @Override
    public long getErrorCountLong() {
        return this.errorCount.get();
    }

    @Override
    public double getMeanDuration() {
        return this.duration.getMean();
    }

    @Override
    public double getMinDuration() {
        return this.duration.getMin();
    }

    @Override
    public double getMaxDuration() {
        return this.duration.getMax();
    }

    @Override
    public double getStandardDeviationDuration() {
        return this.duration.getStandardDeviation();
    }

    @Override
    public int getActiveCount() {
        return (int)this.activeCount.get();
    }

    @Override
    public long getActiveCountLong() {
        return this.activeCount.get();
    }

    @Override
    public Statistics getDuration() {
        return this.duration.getStatistics();
    }

    protected static class DefaultHandlerMetricsContext
    implements MetricsContext {
        protected final long start;

        protected DefaultHandlerMetricsContext(long start) {
            this.start = start;
        }
    }
}

