/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.integration.support.management.AbstractMessageChannelMetrics;
import org.springframework.integration.support.management.ExponentialMovingAverage;
import org.springframework.integration.support.management.ExponentialMovingAverageRate;
import org.springframework.integration.support.management.ExponentialMovingAverageRatio;
import org.springframework.integration.support.management.MetricsContext;
import org.springframework.integration.support.management.Statistics;

public class DefaultMessageChannelMetrics
extends AbstractMessageChannelMetrics {
    public static final long ONE_SECOND_SECONDS = 1L;
    public static final long ONE_MINUTE_SECONDS = 60L;
    public static final int DEFAULT_MOVING_AVERAGE_WINDOW = 10;
    protected final ExponentialMovingAverage sendDuration;
    protected final ExponentialMovingAverageRate sendErrorRate;
    protected final ExponentialMovingAverageRatio sendSuccessRatio;
    protected final ExponentialMovingAverageRate sendRate;
    protected final AtomicLong sendCount = new AtomicLong();
    protected final AtomicLong sendErrorCount = new AtomicLong();
    protected final AtomicLong receiveCount = new AtomicLong();
    protected final AtomicLong receiveErrorCount = new AtomicLong();

    public DefaultMessageChannelMetrics() {
        this(null);
    }

    public DefaultMessageChannelMetrics(String name) {
        this(name, null, null, null, (Counter)null);
    }

    public DefaultMessageChannelMetrics(String name, Timer timer, Counter errorCounter, Counter receiveCounter, Counter receiveErrorCounter) {
        this(name, new ExponentialMovingAverage(10, 1000000.0), new ExponentialMovingAverageRate(1.0, 60.0, 10, true), new ExponentialMovingAverageRatio(60.0, 10, true), new ExponentialMovingAverageRate(1.0, 60.0, 10, true), timer, errorCounter, receiveCounter, receiveErrorCounter);
    }

    public DefaultMessageChannelMetrics(String name, ExponentialMovingAverage sendDuration, ExponentialMovingAverageRate sendErrorRate, ExponentialMovingAverageRatio sendSuccessRatio, ExponentialMovingAverageRate sendRate) {
        this(name, sendDuration, sendErrorRate, sendSuccessRatio, sendRate, null, null, null, null);
    }

    public DefaultMessageChannelMetrics(String name, ExponentialMovingAverage sendDuration, ExponentialMovingAverageRate sendErrorRate, ExponentialMovingAverageRatio sendSuccessRatio, ExponentialMovingAverageRate sendRate, Timer timer, Counter errorCounter, Counter receiveCounter, Counter receiveErrorCounter) {
        super(name, timer, errorCounter, receiveCounter, receiveErrorCounter);
        this.sendDuration = sendDuration;
        this.sendErrorRate = sendErrorRate;
        this.sendSuccessRatio = sendSuccessRatio;
        this.sendRate = sendRate;
    }

    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.sendDuration);
        }
    }

    @Override
    public MetricsContext beforeSend() {
        long start = 0L;
        if (this.isFullStatsEnabled()) {
            start = System.nanoTime();
            this.sendRate.increment(start);
        }
        this.sendCount.incrementAndGet();
        return new DefaultChannelMetricsContext(start);
    }

    @Override
    public void afterSend(MetricsContext context, boolean result) {
        if (result) {
            if (this.isFullStatsEnabled()) {
                long now = System.nanoTime();
                this.sendSuccessRatio.success(now);
                this.sendDuration.append(now - ((DefaultChannelMetricsContext)context).start);
            }
        } else {
            if (this.isFullStatsEnabled()) {
                long now = System.nanoTime();
                this.sendSuccessRatio.failure(now);
                this.sendErrorRate.increment(now);
            }
            this.sendErrorCount.incrementAndGet();
        }
    }

    @Override
    public synchronized void reset() {
        this.sendDuration.reset();
        this.sendErrorRate.reset();
        this.sendSuccessRatio.reset();
        this.sendRate.reset();
        this.sendCount.set(0L);
        this.sendErrorCount.set(0L);
        this.receiveErrorCount.set(0L);
        this.receiveCount.set(0L);
    }

    @Override
    public int getSendCount() {
        return (int)this.sendCount.get();
    }

    @Override
    public long getSendCountLong() {
        return this.sendCount.get();
    }

    @Override
    public int getSendErrorCount() {
        return (int)this.sendErrorCount.get();
    }

    @Override
    public long getSendErrorCountLong() {
        return this.sendErrorCount.get();
    }

    @Override
    public double getTimeSinceLastSend() {
        return this.sendRate.getTimeSinceLastMeasurement();
    }

    @Override
    public double getMeanSendRate() {
        return this.sendRate.getMean();
    }

    @Override
    public double getMeanErrorRate() {
        return this.sendErrorRate.getMean();
    }

    @Override
    public double getMeanErrorRatio() {
        return 1.0 - this.sendSuccessRatio.getMean();
    }

    @Override
    public double getMeanSendDuration() {
        return this.sendDuration.getMean();
    }

    @Override
    public double getMinSendDuration() {
        return this.sendDuration.getMin();
    }

    @Override
    public double getMaxSendDuration() {
        return this.sendDuration.getMax();
    }

    @Override
    public double getStandardDeviationSendDuration() {
        return this.sendDuration.getStandardDeviation();
    }

    @Override
    public Statistics getSendDuration() {
        return this.sendDuration.getStatistics();
    }

    @Override
    public Statistics getSendRate() {
        return this.sendRate.getStatistics();
    }

    @Override
    public Statistics getErrorRate() {
        return this.sendErrorRate.getStatistics();
    }

    @Override
    public void afterReceive() {
        if (this.getReceiveCounter() != null) {
            this.getReceiveCounter().increment();
        } else {
            this.receiveCount.incrementAndGet();
        }
    }

    @Override
    public void afterError() {
        if (this.getReceiveErrorCounter() != null) {
            this.getReceiveErrorCounter().increment();
        } else {
            this.receiveErrorCount.incrementAndGet();
        }
    }

    @Override
    public int getReceiveCount() {
        return (int)this.receiveCount.get();
    }

    @Override
    public long getReceiveCountLong() {
        return this.receiveCount.get();
    }

    @Override
    public int getReceiveErrorCount() {
        return (int)this.receiveErrorCount.get();
    }

    @Override
    public long getReceiveErrorCountLong() {
        return this.receiveErrorCount.get();
    }

    public String toString() {
        return String.format("MessageChannelMonitor: [name=%s, sends=%d" + (this.receiveCount.get() == 0L ? "" : Long.valueOf(this.receiveCount.get())) + "]", this.name, this.sendCount.get());
    }

    protected static class DefaultChannelMetricsContext
    implements MetricsContext {
        protected final long start;

        protected DefaultChannelMetricsContext(long start) {
            this.start = start;
        }
    }
}

