/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.converter;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.integration.support.converter.ObjectStringMessageConverter;
import org.springframework.integration.support.json.JacksonPresent;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.GenericMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;

public class ConfigurableCompositeMessageConverter
extends CompositeMessageConverter {
    public ConfigurableCompositeMessageConverter() {
        super(ConfigurableCompositeMessageConverter.initDefaults());
    }

    public ConfigurableCompositeMessageConverter(Collection<MessageConverter> converters) {
        this(converters, false);
    }

    public ConfigurableCompositeMessageConverter(Collection<MessageConverter> converters, boolean registerDefaults) {
        super(registerDefaults ? (Collection)Stream.concat(converters.stream(), ConfigurableCompositeMessageConverter.initDefaults().stream()).collect(Collectors.toList()) : converters);
    }

    private static Collection<MessageConverter> initDefaults() {
        LinkedList<MessageConverter> converters = new LinkedList<MessageConverter>();
        if (JacksonPresent.isJackson2Present()) {
            converters.add((MessageConverter)new MappingJackson2MessageConverter());
        }
        converters.add((MessageConverter)new ByteArrayMessageConverter());
        converters.add((MessageConverter)new ObjectStringMessageConverter());
        converters.add((MessageConverter)new GenericMessageConverter());
        return converters;
    }
}

