/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.channel;

import java.util.Queue;
import java.util.concurrent.Executor;
import org.springframework.integration.dsl.channel.DirectChannelSpec;
import org.springframework.integration.dsl.channel.ExecutorChannelSpec;
import org.springframework.integration.dsl.channel.FluxMessageChannelSpec;
import org.springframework.integration.dsl.channel.PriorityChannelSpec;
import org.springframework.integration.dsl.channel.PublishSubscribeChannelSpec;
import org.springframework.integration.dsl.channel.QueueChannelSpec;
import org.springframework.integration.dsl.channel.RendezvousChannelSpec;
import org.springframework.integration.store.ChannelMessageStore;
import org.springframework.integration.store.PriorityCapableChannelMessageStore;
import org.springframework.messaging.Message;

public final class MessageChannels {
    public static DirectChannelSpec direct() {
        return new DirectChannelSpec();
    }

    public static DirectChannelSpec direct(String id) {
        return (DirectChannelSpec)MessageChannels.direct().id(id);
    }

    public static QueueChannelSpec queue() {
        return new QueueChannelSpec();
    }

    public static QueueChannelSpec queue(String id) {
        return (QueueChannelSpec)MessageChannels.queue().id(id);
    }

    public static QueueChannelSpec queue(Queue<Message<?>> queue) {
        return new QueueChannelSpec(queue);
    }

    public static QueueChannelSpec queue(String id, Queue<Message<?>> queue) {
        return (QueueChannelSpec)MessageChannels.queue(queue).id(id);
    }

    public static QueueChannelSpec queue(Integer capacity) {
        return new QueueChannelSpec(capacity);
    }

    public static QueueChannelSpec queue(String id, Integer capacity) {
        return (QueueChannelSpec)MessageChannels.queue(capacity).id(id);
    }

    public static QueueChannelSpec.MessageStoreSpec queue(ChannelMessageStore messageGroupStore, Object groupId) {
        return new QueueChannelSpec.MessageStoreSpec(messageGroupStore, groupId);
    }

    public static QueueChannelSpec.MessageStoreSpec queue(String id, ChannelMessageStore messageGroupStore, Object groupId) {
        return MessageChannels.queue(messageGroupStore, groupId).id(id);
    }

    public static ExecutorChannelSpec executor(Executor executor) {
        return new ExecutorChannelSpec(executor);
    }

    public static ExecutorChannelSpec executor(String id, Executor executor) {
        return (ExecutorChannelSpec)MessageChannels.executor(executor).id(id);
    }

    public static RendezvousChannelSpec rendezvous() {
        return new RendezvousChannelSpec();
    }

    public static RendezvousChannelSpec rendezvous(String id) {
        return (RendezvousChannelSpec)MessageChannels.rendezvous().id(id);
    }

    public static PriorityChannelSpec priority() {
        return new PriorityChannelSpec();
    }

    public static PriorityChannelSpec priority(String id) {
        return (PriorityChannelSpec)MessageChannels.priority().id(id);
    }

    public static PriorityChannelSpec priority(PriorityCapableChannelMessageStore messageGroupStore, Object groupId) {
        return MessageChannels.priority().messageStore(messageGroupStore, groupId);
    }

    public static PriorityChannelSpec priority(String id, PriorityCapableChannelMessageStore messageGroupStore, Object groupId) {
        return (PriorityChannelSpec)MessageChannels.priority(messageGroupStore, groupId).id(id);
    }

    public static <S extends PublishSubscribeChannelSpec<S>> PublishSubscribeChannelSpec<S> publishSubscribe() {
        return new PublishSubscribeChannelSpec();
    }

    public static <S extends PublishSubscribeChannelSpec<S>> PublishSubscribeChannelSpec<S> publishSubscribe(String id) {
        return (PublishSubscribeChannelSpec)MessageChannels.publishSubscribe().id(id);
    }

    public static <S extends PublishSubscribeChannelSpec<S>> PublishSubscribeChannelSpec<S> publishSubscribe(Executor executor) {
        return new PublishSubscribeChannelSpec(executor);
    }

    public static <S extends PublishSubscribeChannelSpec<S>> PublishSubscribeChannelSpec<S> publishSubscribe(String id, Executor executor) {
        return (PublishSubscribeChannelSpec)MessageChannels.publishSubscribe(executor).id(id);
    }

    public static FluxMessageChannelSpec flux() {
        return new FluxMessageChannelSpec();
    }

    public static FluxMessageChannelSpec flux(String id) {
        return (FluxMessageChannelSpec)MessageChannels.flux().id(id);
    }

    private MessageChannels() {
    }
}

