/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.expression.Expression;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.dsl.ConsumerEndpointSpec;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.handler.BeanNameMessageProcessor;
import org.springframework.integration.handler.ExpressionEvaluatingMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.support.MapBuilder;
import org.springframework.integration.support.StringStringMapBuilder;
import org.springframework.integration.transformer.HeaderEnricher;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.support.ExpressionEvaluatingHeaderValueMessageProcessor;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.integration.transformer.support.StaticHeaderValueMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.util.function.Tuple2;

public class HeaderEnricherSpec
extends ConsumerEndpointSpec<HeaderEnricherSpec, MessageTransformingHandler> {
    private final Map<String, HeaderValueMessageProcessor<?>> headerToAdd = new HashMap();
    private boolean defaultOverwrite = false;
    private boolean shouldSkipNulls = true;
    private MessageProcessor<?> messageProcessor;

    HeaderEnricherSpec() {
        super(null);
    }

    public HeaderEnricherSpec defaultOverwrite(boolean defaultOverwrite) {
        this.defaultOverwrite = defaultOverwrite;
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec shouldSkipNulls(boolean shouldSkipNulls) {
        this.shouldSkipNulls = shouldSkipNulls;
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec messageProcessor(MessageProcessor<?> messageProcessor) {
        this.messageProcessor = messageProcessor;
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec messageProcessor(String expression) {
        return this.messageProcessor(new ExpressionEvaluatingMessageProcessor(PARSER.parseExpression(expression)));
    }

    public HeaderEnricherSpec messageProcessor(String beanName, String methodName) {
        return this.messageProcessor(new BeanNameMessageProcessor(beanName, methodName));
    }

    public HeaderEnricherSpec headers(MapBuilder<?, String, Object> headers) {
        return this.headers(headers, null);
    }

    public HeaderEnricherSpec headers(MapBuilder<?, String, Object> headers, Boolean overwrite) {
        Assert.notNull(headers, (String)"'headers' must not be null");
        return this.headers(headers.get(), overwrite);
    }

    public HeaderEnricherSpec headers(Map<String, Object> headers) {
        return this.headers(headers, null);
    }

    public HeaderEnricherSpec headers(Map<String, Object> headers, Boolean overwrite) {
        Assert.notNull(headers, (String)"'headers' must not be null");
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Expression) {
                ExpressionEvaluatingHeaderValueMessageProcessor processor = new ExpressionEvaluatingHeaderValueMessageProcessor((Expression)value, null);
                processor.setOverwrite(overwrite);
                this.header(name, processor);
                continue;
            }
            this.header(name, value, overwrite);
        }
        return this;
    }

    public HeaderEnricherSpec headerExpressions(MapBuilder<?, String, String> headers) {
        return this.headerExpressions(headers, null);
    }

    public HeaderEnricherSpec headerExpressions(MapBuilder<?, String, String> headers, Boolean overwrite) {
        Assert.notNull(headers, (String)"'headers' must not be null");
        return this.headerExpressions(headers.get(), overwrite);
    }

    public HeaderEnricherSpec headerExpressions(Consumer<StringStringMapBuilder> configurer) {
        return this.headerExpressions(configurer, null);
    }

    public HeaderEnricherSpec headerExpressions(Consumer<StringStringMapBuilder> configurer, Boolean overwrite) {
        Assert.notNull(configurer, (String)"'configurer' must not be null");
        StringStringMapBuilder builder = new StringStringMapBuilder();
        configurer.accept(builder);
        return this.headerExpressions(builder.get(), overwrite);
    }

    public HeaderEnricherSpec headerExpressions(Map<String, String> headers) {
        return this.headerExpressions(headers, null);
    }

    public HeaderEnricherSpec headerExpressions(Map<String, String> headers, Boolean overwrite) {
        Assert.notNull(headers, (String)"'headers' must not be null");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            ExpressionEvaluatingHeaderValueMessageProcessor processor = new ExpressionEvaluatingHeaderValueMessageProcessor(entry.getValue(), null);
            processor.setOverwrite(overwrite);
            this.header(entry.getKey(), processor);
        }
        return this;
    }

    public <V> HeaderEnricherSpec header(String name, V value) {
        return this.header(name, value, null);
    }

    public <V> HeaderEnricherSpec header(String name, V value, Boolean overwrite) {
        StaticHeaderValueMessageProcessor<V> headerValueMessageProcessor = new StaticHeaderValueMessageProcessor<V>(value);
        headerValueMessageProcessor.setOverwrite(overwrite);
        return this.header(name, (HeaderValueMessageProcessor<V>)headerValueMessageProcessor);
    }

    public HeaderEnricherSpec headerExpression(String name, String expression) {
        return this.headerExpression(name, expression, null);
    }

    public HeaderEnricherSpec headerExpression(String name, String expression, Boolean overwrite) {
        Assert.hasText((String)expression, (String)"'expression' must not be empty");
        return this.headerExpression(name, PARSER.parseExpression(expression), overwrite);
    }

    public <P> HeaderEnricherSpec headerFunction(String name, Function<Message<P>, Object> function) {
        return this.headerFunction(name, function, null);
    }

    public <P> HeaderEnricherSpec headerFunction(String name, Function<Message<P>, Object> function, Boolean overwrite) {
        return this.headerExpression(name, new FunctionExpression<Message<P>>(function), overwrite);
    }

    private HeaderEnricherSpec headerExpression(String name, Expression expression, Boolean overwrite) {
        ExpressionEvaluatingHeaderValueMessageProcessor headerValueMessageProcessor = new ExpressionEvaluatingHeaderValueMessageProcessor(expression, null);
        headerValueMessageProcessor.setOverwrite(overwrite);
        return this.header(name, headerValueMessageProcessor);
    }

    public <V> HeaderEnricherSpec header(String headerName, HeaderValueMessageProcessor<V> headerValueMessageProcessor) {
        Assert.hasText((String)headerName, (String)"'headerName' must not be empty");
        this.headerToAdd.put(headerName, headerValueMessageProcessor);
        return (HeaderEnricherSpec)this._this();
    }

    public HeaderEnricherSpec headerChannelsToString() {
        return this.headerChannelsToString(null);
    }

    public HeaderEnricherSpec headerChannelsToString(String timeToLiveExpression) {
        return this.headerExpression("replyChannel", "@integrationHeaderChannelRegistry.channelToChannelName(headers.replyChannel" + (StringUtils.hasText((String)timeToLiveExpression) ? ", " + timeToLiveExpression : "") + ")", (Boolean)true).headerExpression("errorChannel", "@integrationHeaderChannelRegistry.channelToChannelName(headers.errorChannel" + (StringUtils.hasText((String)timeToLiveExpression) ? ", " + timeToLiveExpression : "") + ")", (Boolean)true);
    }

    @Override
    protected Tuple2<ConsumerEndpointFactoryBean, MessageTransformingHandler> doGet() {
        HeaderEnricher headerEnricher = new HeaderEnricher(new HashMap(this.headerToAdd));
        headerEnricher.setDefaultOverwrite(this.defaultOverwrite);
        headerEnricher.setShouldSkipNulls(this.shouldSkipNulls);
        headerEnricher.setMessageProcessor(this.messageProcessor);
        this.componentsToRegister.put(headerEnricher, null);
        this.handler = new MessageTransformingHandler(headerEnricher);
        return super.doGet();
    }
}

