/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.ResolvableType;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.IntegrationComponentSpec;
import org.springframework.integration.dsl.PollerFactory;
import org.springframework.integration.dsl.PollerSpec;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.util.Assert;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public abstract class EndpointSpec<S extends EndpointSpec<S, F, H>, F extends BeanNameAware, H>
extends IntegrationComponentSpec<S, Tuple2<F, H>>
implements ComponentsRegistration {
    protected final Map<Object, String> componentsToRegister = new LinkedHashMap<Object, String>();
    protected H handler;
    protected F endpointFactoryBean;

    protected EndpointSpec(H handler) {
        try {
            Class fClass = ResolvableType.forClass(this.getClass()).as(EndpointSpec.class).resolveGenerics()[1];
            this.endpointFactoryBean = (BeanNameAware)fClass.newInstance();
            this.handler = handler;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public S id(String id) {
        this.endpointFactoryBean.setBeanName(id);
        return (S)((EndpointSpec)super.id(id));
    }

    public S poller(Function<PollerFactory, PollerSpec> pollers) {
        return this.poller(pollers.apply(new PollerFactory()));
    }

    public S poller(PollerSpec pollerMetadataSpec) {
        Map<Object, String> componentsToRegister = pollerMetadataSpec.getComponentsToRegister();
        if (componentsToRegister != null) {
            this.componentsToRegister.putAll(componentsToRegister);
        }
        return this.poller((PollerMetadata)pollerMetadataSpec.get());
    }

    public abstract S poller(PollerMetadata var1);

    public abstract S phase(int var1);

    public abstract S autoStartup(boolean var1);

    public abstract S role(String var1);

    @Override
    public Map<Object, String> getComponentsToRegister() {
        return this.componentsToRegister.isEmpty() ? null : this.componentsToRegister;
    }

    @Override
    protected Tuple2<F, H> doGet() {
        return Tuples.of(this.endpointFactoryBean, this.handler);
    }

    protected void assertHandler() {
        Assert.state((this.handler != null ? 1 : 0) != 0, (String)"'this.handler' must not be null.");
    }
}

