/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dsl.ConsumerEndpointSpec;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class AbstractRouterSpec<S extends AbstractRouterSpec<S, R>, R extends AbstractMessageRouter>
extends ConsumerEndpointSpec<S, R> {
    private boolean defaultToParentFlow;

    AbstractRouterSpec(R router) {
        super(router);
    }

    public S ignoreSendFailures(boolean ignoreSendFailures) {
        ((AbstractMessageRouter)this.handler).setIgnoreSendFailures(ignoreSendFailures);
        return (S)((AbstractRouterSpec)this._this());
    }

    public S applySequence(boolean applySequence) {
        ((AbstractMessageRouter)this.handler).setApplySequence(applySequence);
        return (S)((AbstractRouterSpec)this._this());
    }

    public S defaultOutputChannel(String channelName) {
        ((AbstractMessageRouter)this.handler).setDefaultOutputChannelName(channelName);
        return (S)((AbstractRouterSpec)this._this());
    }

    public S defaultOutputChannel(MessageChannel channel) {
        ((AbstractMessageRouter)this.handler).setDefaultOutputChannel(channel);
        return (S)((AbstractRouterSpec)this._this());
    }

    public S defaultSubFlowMapping(IntegrationFlow subFlow) {
        Assert.notNull((Object)subFlow, (String)"'subFlow' must not be null");
        DirectChannel channel = new DirectChannel();
        IntegrationFlowBuilder flowBuilder = IntegrationFlows.from(channel);
        subFlow.configure(flowBuilder);
        this.componentsToRegister.put(flowBuilder, null);
        return this.defaultOutputChannel(channel);
    }

    public S defaultOutputToParentFlow() {
        this.defaultToParentFlow = true;
        return (S)((AbstractRouterSpec)this._this());
    }

    boolean isDefaultToParentFlow() {
        return this.defaultToParentFlow;
    }
}

