/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.config.AbstractSimpleMessageHandlerFactoryBean;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractStandardMessageHandlerFactoryBean
extends AbstractSimpleMessageHandlerFactoryBean<MessageHandler> {
    private static final ExpressionParser expressionParser = new SpelExpressionParser();
    private static final Set<MessageHandler> referencedReplyProducers = new HashSet<MessageHandler>();
    private volatile Boolean requiresReply;
    private volatile Object targetObject;
    private volatile String targetMethodName;
    private volatile Expression expression;
    private volatile Long sendTimeout;

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public void setTargetMethodName(String targetMethodName) {
        this.targetMethodName = targetMethodName;
    }

    public void setExpressionString(String expressionString) {
        this.expression = expressionParser.parseExpression(expressionString);
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void setRequiresReply(Boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public Long getSendTimeout() {
        return this.sendTimeout;
    }

    @Override
    protected MessageHandler createHandler() {
        MessageHandler handler;
        if (this.targetObject == null) {
            Assert.isTrue((!StringUtils.hasText((String)this.targetMethodName) ? 1 : 0) != 0, (String)"The target method is only allowed when a target object (ref or inner bean) is also provided.");
        }
        if (this.targetObject != null) {
            boolean targetIsDirectReplyProducingHandler;
            Assert.state((this.expression == null ? 1 : 0) != 0, (String)"The 'targetObject' and 'expression' properties are mutually exclusive.");
            AbstractMessageProducingHandler actualHandler = this.extractTypeIfPossible(this.targetObject, AbstractMessageProducingHandler.class);
            boolean bl = targetIsDirectReplyProducingHandler = actualHandler != null && this.canBeUsedDirect(actualHandler) && this.methodIsHandleMessageOrEmpty(this.targetMethodName);
            if (this.targetObject instanceof MessageProcessor) {
                handler = this.createMessageProcessingHandler((MessageProcessor)this.targetObject);
            } else if (targetIsDirectReplyProducingHandler) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Wiring handler (" + this.targetObject + ") directly into endpoint"));
                }
                this.checkReuse(actualHandler);
                this.postProcessReplyProducer(actualHandler);
                handler = (MessageHandler)this.targetObject;
            } else {
                handler = this.createMethodInvokingHandler(this.targetObject, this.targetMethodName);
            }
        } else {
            handler = this.expression != null ? this.createExpressionEvaluatingHandler(this.expression) : this.createDefaultHandler();
        }
        return handler;
    }

    protected void checkForIllegalTarget(Object targetObject, String targetMethodName) {
        if (targetObject instanceof AbstractReplyProducingMessageHandler && this.methodIsHandleMessageOrEmpty(targetMethodName)) {
            throw new IllegalArgumentException("AbstractReplyProducingMessageHandler.handleMessage() is not allowed for a MethodInvokingHandler");
        }
    }

    private void checkReuse(AbstractMessageProducingHandler replyHandler) {
        Assert.isTrue((!referencedReplyProducers.contains(replyHandler) ? 1 : 0) != 0, (String)("An AbstractMessageProducingMessageHandler may only be referenced once (" + replyHandler.getComponentName() + ") - use scope=\"prototype\""));
        referencedReplyProducers.add(replyHandler);
    }

    protected abstract MessageHandler createMethodInvokingHandler(Object var1, String var2);

    protected MessageHandler createExpressionEvaluatingHandler(Expression expression) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support expressions.");
    }

    protected <T> MessageHandler createMessageProcessingHandler(MessageProcessor<T> processor) {
        return this.createMethodInvokingHandler(processor, null);
    }

    protected MessageHandler createDefaultHandler() {
        throw new IllegalArgumentException("Exactly one of the 'targetObject' or 'expression' property is required.");
    }

    protected <T> T extractTypeIfPossible(Object targetObject, Class<T> expectedType) {
        if (targetObject == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(targetObject.getClass())) {
            return (T)targetObject;
        }
        if (targetObject instanceof Advised) {
            TargetSource targetSource = ((Advised)targetObject).getTargetSource();
            try {
                return this.extractTypeIfPossible(targetSource.getTarget(), expectedType);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    protected boolean methodIsHandleMessageOrEmpty(String targetMethodName) {
        return !StringUtils.hasText((String)targetMethodName) || "handleMessage".equals(targetMethodName);
    }

    protected boolean canBeUsedDirect(AbstractMessageProducingHandler handler) {
        return false;
    }

    protected void postProcessReplyProducer(AbstractMessageProducingHandler handler) {
        if (this.sendTimeout != null) {
            handler.setSendTimeout(this.sendTimeout);
        }
        if (this.requiresReply != null) {
            if (handler instanceof AbstractReplyProducingMessageHandler) {
                ((AbstractReplyProducingMessageHandler)handler).setRequiresReply(this.requiresReply);
            } else if (this.requiresReply.booleanValue() && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("requires-reply can only be set to AbstractReplyProducingMessageHandler or its subclass, " + handler.getComponentName() + " doesn't support it."));
            }
        }
    }
}

