/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.orm.jpa;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jpa.HibernateMetrics;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, HibernateJpaAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@ConditionalOnClass(value={EntityManagerFactory.class, SessionFactory.class, MeterRegistry.class})
@ConditionalOnBean(value={EntityManagerFactory.class, MeterRegistry.class})
public class HibernateMetricsAutoConfiguration {
    private static final String ENTITY_MANAGER_FACTORY_SUFFIX = "entityManagerFactory";
    private final MeterRegistry registry;

    public HibernateMetricsAutoConfiguration(MeterRegistry registry) {
        this.registry = registry;
    }

    @Autowired
    public void bindEntityManagerFactoriesToRegistry(Map<String, EntityManagerFactory> entityManagerFactories) {
        entityManagerFactories.forEach(this::bindEntityManagerFactoryToRegistry);
    }

    private void bindEntityManagerFactoryToRegistry(String beanName, EntityManagerFactory entityManagerFactory) {
        String entityManagerFactoryName = this.getEntityManagerFactoryName(beanName);
        new HibernateMetrics(entityManagerFactory, entityManagerFactoryName, Collections.emptyList()).bindTo(this.registry);
    }

    private String getEntityManagerFactoryName(String beanName) {
        if (beanName.length() > ENTITY_MANAGER_FACTORY_SUFFIX.length() && StringUtils.endsWithIgnoreCase((String)beanName, (String)ENTITY_MANAGER_FACTORY_SUFFIX)) {
            return beanName.substring(0, beanName.length() - ENTITY_MANAGER_FACTORY_SUFFIX.length());
        }
        return beanName;
    }
}

