/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/UnsupportedSyntheticCallableReferenceChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
public final class UnsupportedSyntheticCallableReferenceChecker
implements CallChecker {
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Call call = resolvedCall.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"resolvedCall.call");
        KtCallableReferenceExpression ktCallableReferenceExpression = CallUtilKt.extractCallableReferenceExpression((Call)call);
        if (ktCallableReferenceExpression == null) {
            return;
        }
        KtCallableReferenceExpression callableReferenceExpression = ktCallableReferenceExpression;
        if (PsiUtilsKt.unwrapParenthesesLabelsAndAnnotationsDeeply((PsiElement)((PsiElement)callableReferenceExpression)) instanceof KtPropertyDelegate) {
            return;
        }
        if (resolvedCall.getResultingDescriptor() instanceof SyntheticJavaPropertyDescriptor) {
            ParametrizedDiagnostic parametrizedDiagnostic = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference) && context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReferencesToSyntheticJavaProperties) ? (ParametrizedDiagnostic)Errors.CALLABLE_REFERENCE_TO_JAVA_SYNTHETIC_PROPERTY.on(reportOn) : Errors.UNSUPPORTED.on(reportOn, (Object)"reference to the synthetic extension property for a Java get/set method");
            Intrinsics.checkNotNullExpressionValue((Object)parametrizedDiagnostic, (String)"if (\n                con\u2026et method\")\n            }");
            ParametrizedDiagnostic diagnostic = parametrizedDiagnostic;
            context.getTrace().report((Diagnostic)diagnostic);
        }
    }
}

