/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsTestModuleProperties;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.build.BuildMetaInfoFactory;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.PluginClasspathsComparator;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl;
import org.jetbrains.kotlin.incremental.components.EnumWhenTracker;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.KotlinJpsBundle;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinChunk;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolderKt;
import org.jetbrains.kotlin.jps.build.KotlinIncludedModuleSourceRoot;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesDiff;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManagerKt;
import org.jetbrains.kotlin.jps.incremental.CacheVersionManager;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.LocalKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0006\u008c\u0001\u008d\u0001\u008e\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010X\u001a\u00020Y2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000$H\u0002J\u0010\u0010X\u001a\u00020Y2\u0006\u0010\u001d\u001a\u00020ZH\u0002J\u0010\u0010X\u001a\u00020Y2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010[\u001a\f0\\R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010]\u001a\u00020^H\u0004J \u0010_\u001a\u00020,2\u0006\u0010`\u001a\u00020a2\u0006\u0010]\u001a\u00020^2\u0006\u0010b\u001a\u00020cH&J\u001c\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010e\u001a\u000206H\u0002J\u0010\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020iH&J\b\u0010j\u001a\u00020YH\u0016J\u0010\u0010k\u001a\u00020,2\u0006\u0010l\u001a\u00020aH\u0016J\u000e\u0010m\u001a\u00020,2\u0006\u0010n\u001a\u00020\fJ\u0016\u0010o\u001a\u00020,2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010p\u001a\u00020\u0002JH\u0010q\u001a\u00020Y2\u0006\u0010r\u001a\u00020s2\u0016\u0010t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0000\u0012\u0004\u0012\u00020g0\u000b2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020x2\u0006\u0010y\u001a\u00020z2\u0006\u0010{\u001a\u00020|H\u0016J\u000e\u0010}\u001a\u00020Y2\u0006\u0010e\u001a\u000206J!\u0010~\u001a\u00020Y2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u000e\u0010\u0081\u0001\u001a\t\u0012\u0005\u0012\u00030\u0082\u00010$H\u0016J\u0011\u0010\u0083\u0001\u001a\u00020,2\u0006\u0010b\u001a\u00020cH\u0004J\t\u0010\u0084\u0001\u001a\u00020\u001aH\u0016J<\u0010\u0085\u0001\u001a\u00020Y2\u0006\u0010]\u001a\u00020^2\u0007\u0010\u0086\u0001\u001a\u00020g2\u000e\u0010\u0087\u0001\u001a\t\u0012\u0005\u0012\u00030\u0082\u00010$2\b\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0006\u0010b\u001a\u00020cH\u0016J^\u0010\u008a\u0001\u001a\u00020Y2\u0006\u0010e\u001a\u0002062\u0006\u0010\u001d\u001a\u00020Z2\u0006\u0010]\u001a\u00020^2\u001b\u0010\u0081\u0001\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0082\u00010\u008b\u00010\u000b2\u0016\u0010t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0000\u0012\u0004\u0012\u00020g0\u000b2\u0006\u0010b\u001a\u00020cH\u0016R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001b\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0$8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0012\u0010)\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001cR\u0014\u0010+\u001a\u00020,X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0015\u0010/\u001a\u0006\u0012\u0002\b\u000300\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0012\u00103\u001a\u00020,X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010.R\u0011\u00104\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010.R\u0011\u00105\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0017\u0010=\u001a\u00020>\u00a2\u0006\u000e\n\u0000\u0012\u0004\b?\u0010@\u001a\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020D8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u001b\u0010G\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010\u0014\u001a\u0004\bH\u0010IR\u0016\u0010K\u001a\u0004\u0018\u00010D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010FR\u0017\u0010M\u001a\b\u0012\u0004\u0012\u00020\f0N8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u001d\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0014\u0010T\u001a\u00020U8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010W\u00a8\u0006\u008f\u0001"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "BuildMetaInfoType", "Lorg/jetbrains/kotlin/build/BuildMetaInfo;", "", "kotlinContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "jpsModuleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "_sources", "Lkotlin/Lazy;", "", "Ljava/io/File;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Source;", "allDependencies", "Lorg/jetbrains/jps/model/java/JpsJavaDependenciesEnumerator;", "Lorg/jetbrains/annotations/NotNull;", "getAllDependencies", "()Lorg/jetbrains/jps/model/java/JpsJavaDependenciesEnumerator;", "allDependencies$delegate", "Lkotlin/Lazy;", "buildMetaInfoFactory", "Lorg/jetbrains/kotlin/build/BuildMetaInfoFactory;", "getBuildMetaInfoFactory", "()Lorg/jetbrains/kotlin/build/BuildMetaInfoFactory;", "buildMetaInfoFileName", "", "getBuildMetaInfoFileName", "()Ljava/lang/String;", "chunk", "Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "getChunk", "()Lorg/jetbrains/kotlin/jps/build/KotlinChunk;", "setChunk", "(Lorg/jetbrains/kotlin/jps/build/KotlinChunk;)V", "friendBuildTargets", "", "getFriendBuildTargets", "()Ljava/util/List;", "friendOutputDirs", "getFriendOutputDirs", "globalLookupCacheId", "getGlobalLookupCacheId", "hasCaches", "", "getHasCaches", "()Z", "initialLocalCacheAttributesDiff", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesDiff;", "getInitialLocalCacheAttributesDiff", "()Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesDiff;", "isIncrementalCompilationEnabled", "isTests", "jpsGlobalContext", "Lorg/jetbrains/jps/incremental/CompileContext;", "getJpsGlobalContext", "()Lorg/jetbrains/jps/incremental/CompileContext;", "getJpsModuleBuildTarget", "()Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "getKotlinContext", "()Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "localCacheVersionManager", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "getLocalCacheVersionManager$annotations", "()V", "getLocalCacheVersionManager", "()Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "getModule", "()Lorg/jetbrains/jps/model/module/JpsModule;", "outputDir", "getOutputDir", "()Ljava/io/File;", "outputDir$delegate", "relatedProductionModule", "getRelatedProductionModule", "sourceFiles", "", "getSourceFiles", "()Ljava/util/Collection;", "sources", "getSources", "()Ljava/util/Map;", "targetId", "Lorg/jetbrains/kotlin/modules/TargetId;", "getTargetId", "()Lorg/jetbrains/kotlin/modules/TargetId;", "checkRepresentativeTarget", "", "Lorg/jetbrains/jps/ModuleChunk;", "collectSourcesToCompile", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$SourcesToCompile;", "dirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "compileModuleChunk", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "computeSourcesList", "localContext", "createCacheStorage", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "doAfterBuild", "isEnabled", "chunkCompilerArguments", "isFromIncludedSourceRoot", "file", "isVersionChanged", "buildMetaInfo", "makeServices", "builder", "Lorg/jetbrains/kotlin/config/Services$Builder;", "incrementalCaches", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "enumWhenTracker", "Lorg/jetbrains/kotlin/incremental/components/EnumWhenTracker;", "nextRound", "registerOutputItems", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "outputItems", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "reportAndSkipCircular", "toString", "updateCaches", "jpsIncrementalCache", "files", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "updateChunkMappings", "", "Dependency", "Source", "SourcesToCompile", "jps-plugin"})
public abstract class KotlinModuleBuildTarget<BuildMetaInfoType extends BuildMetaInfo> {
    @NotNull
    private final KotlinCompileContext kotlinContext;
    @NotNull
    private final ModuleBuildTarget jpsModuleBuildTarget;
    public KotlinChunk chunk;
    @NotNull
    private final CacheVersionManager localCacheVersionManager;
    @NotNull
    private final CacheAttributesDiff<?> initialLocalCacheAttributesDiff;
    @NotNull
    private final Lazy outputDir$delegate;
    @NotNull
    private final Lazy allDependencies$delegate;
    @NotNull
    private volatile Lazy<? extends Map<File, Source>> _sources;
    private final boolean hasCaches;

    public KotlinModuleBuildTarget(@NotNull KotlinCompileContext kotlinContext, @NotNull ModuleBuildTarget jpsModuleBuildTarget) {
        Intrinsics.checkNotNullParameter((Object)kotlinContext, (String)"kotlinContext");
        Intrinsics.checkNotNullParameter((Object)jpsModuleBuildTarget, (String)"jpsModuleBuildTarget");
        this.kotlinContext = kotlinContext;
        this.jpsModuleBuildTarget = jpsModuleBuildTarget;
        Path path = this.kotlinContext.getDataPaths().getTargetDataRoot((BuildTarget)this.jpsModuleBuildTarget).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"kotlinContext.dataPaths.\u2026duleBuildTarget).toPath()");
        this.localCacheVersionManager = LocalKt.localCacheVersionManager(path, this.isIncrementalCompilationEnabled());
        this.initialLocalCacheAttributesDiff = CacheAttributesManagerKt.loadDiff$default(this.localCacheVersionManager, null, null, 3, null);
        this.outputDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ KotlinModuleBuildTarget<BuildMetaInfoType> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final File invoke() {
                File explicitOutputDir;
                File file;
                File file2;
                String explicitOutputPath;
                String string = explicitOutputPath = this.this$0.isTests() ? ModuleSettingsKt.getTestOutputFilePath(this.this$0.getModule()) : ModuleSettingsKt.getProductionOutputFilePath(this.this$0.getModule());
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    file2 = new File(it).getAbsoluteFile().getParentFile();
                } else {
                    file2 = null;
                }
                if ((file = (explicitOutputDir = file2)) == null && (file = this.this$0.getJpsModuleBuildTarget().getOutputDir()) == null) {
                    Object[] objectArray = new Object[]{this.this$0};
                    throw new ProjectBuildException(KotlinJpsBundle.message("error.message.no.output.directory.found.for.0", objectArray));
                }
                return file;
            }
        }));
        this.allDependencies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JpsJavaDependenciesEnumerator>(this){
            final /* synthetic */ KotlinModuleBuildTarget<BuildMetaInfoType> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JpsJavaDependenciesEnumerator invoke() {
                return JpsJavaExtensionService.dependencies((JpsModule)this.this$0.getModule()).recursively().exportedOnly().includedIn(JpsJavaClasspathKind.compile((boolean)this.this$0.isTests()));
            }
        }));
        this._sources = LazyKt.lazy((Function0)((Function0)new Function0<Map<File, ? extends Source>>(this){
            final /* synthetic */ KotlinModuleBuildTarget<BuildMetaInfoType> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<File, Source> invoke() {
                return KotlinModuleBuildTarget.access$computeSourcesList(this.this$0, this.this$0.getJpsGlobalContext());
            }
        }));
        this.hasCaches = true;
    }

    @NotNull
    public final KotlinCompileContext getKotlinContext() {
        return this.kotlinContext;
    }

    @NotNull
    public final ModuleBuildTarget getJpsModuleBuildTarget() {
        return this.jpsModuleBuildTarget;
    }

    @NotNull
    public final CompileContext getJpsGlobalContext() {
        return this.kotlinContext.getJpsContext();
    }

    @NotNull
    public final KotlinChunk getChunk() {
        KotlinChunk kotlinChunk = this.chunk;
        if (kotlinChunk != null) {
            return kotlinChunk;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"chunk");
        return null;
    }

    public final void setChunk(@NotNull KotlinChunk kotlinChunk) {
        Intrinsics.checkNotNullParameter((Object)kotlinChunk, (String)"<set-?>");
        this.chunk = kotlinChunk;
    }

    @NotNull
    public abstract String getGlobalLookupCacheId();

    public abstract boolean isIncrementalCompilationEnabled();

    public boolean isEnabled(@NotNull CommonCompilerArguments chunkCompilerArguments) {
        Intrinsics.checkNotNullParameter((Object)chunkCompilerArguments, (String)"chunkCompilerArguments");
        return true;
    }

    @NotNull
    public final CacheVersionManager getLocalCacheVersionManager() {
        return this.localCacheVersionManager;
    }

    public static /* synthetic */ void getLocalCacheVersionManager$annotations() {
    }

    @NotNull
    public final CacheAttributesDiff<?> getInitialLocalCacheAttributesDiff() {
        return this.initialLocalCacheAttributesDiff;
    }

    @NotNull
    public final JpsModule getModule() {
        JpsModule jpsModule = this.jpsModuleBuildTarget.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"jpsModuleBuildTarget.module");
        return jpsModule;
    }

    public final boolean isTests() {
        return this.jpsModuleBuildTarget.isTests();
    }

    @NotNull
    public TargetId getTargetId() {
        Object object = this.getRelatedProductionModule();
        if (object == null || (object = object.getName()) == null) {
            object = this.jpsModuleBuildTarget.getId();
        }
        Object name = object;
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        String string = this.jpsModuleBuildTarget.getTargetType().getTypeId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jpsModuleBuildTarget.targetType.typeId");
        return new TargetId((String)name, string);
    }

    @NotNull
    public final File getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        return (File)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinModuleBuildTarget<?>> getFriendBuildTargets() {
        void $this$filterTo$iv$iv;
        List result = new ArrayList();
        if (this.isTests()) {
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result, this.kotlinContext.getTargetsBinding().get(JpsUtilKt.getProductionBuildTarget(this.getModule())));
            Map<ModuleBuildTarget, KotlinModuleBuildTarget<?>> map = this.kotlinContext.getTargetsBinding();
            JpsModule jpsModule = this.getRelatedProductionModule();
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull(result, map.get(jpsModule != null ? JpsUtilKt.getProductionBuildTarget(jpsModule) : null));
        }
        Iterable $this$filter$iv = result;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !it.getSources().isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getFriendOutputDirs() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getFriendBuildTargets();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            File it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv$iv;
            boolean bl2 = false;
            if (JpsJavaExtensionService.getInstance().getOutputDirectory(it.getModule(), false) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final JpsModule getRelatedProductionModule() {
        JpsTestModuleProperties jpsTestModuleProperties = JpsJavaExtensionService.getInstance().getTestModuleProperties(this.getModule());
        return jpsTestModuleProperties != null ? jpsTestModuleProperties.getProductionModule() : null;
    }

    @NotNull
    public final JpsJavaDependenciesEnumerator getAllDependencies() {
        Lazy lazy = this.allDependencies$delegate;
        return (JpsJavaDependenciesEnumerator)lazy.getValue();
    }

    @NotNull
    public final Map<File, Source> getSources() {
        return (Map)this._sources.getValue();
    }

    public final void nextRound(@NotNull CompileContext localContext) {
        Intrinsics.checkNotNullParameter((Object)localContext, (String)"localContext");
        this._sources = LazyKt.lazy((Function0)((Function0)new Function0<Map<File, ? extends Source>>(this, localContext){
            final /* synthetic */ KotlinModuleBuildTarget<BuildMetaInfoType> this$0;
            final /* synthetic */ CompileContext $localContext;
            {
                this.this$0 = $receiver;
                this.$localContext = $localContext;
                super(0);
            }

            @NotNull
            public final Map<File, Source> invoke() {
                return KotlinModuleBuildTarget.access$computeSourcesList(this.this$0, this.$localContext);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<File, Source> computeSourcesList(CompileContext localContext) {
        void $this$mapTo$iv;
        Map result = new LinkedHashMap();
        List list = this.getModule().getExcludeRootsList().getUrls();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"module.excludeRootsList.urls");
        Iterable iterable = list;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void p0;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(JpsPathUtil.urlToFile((String)p0));
        }
        HashSet moduleExcludes = (HashSet)destination$iv;
        JpsCompilerExcludes jpsCompilerExcludes = JpsJavaExtensionService.getInstance().getCompilerConfiguration(this.getModule().getProject()).getCompilerExcludes();
        Intrinsics.checkNotNullExpressionValue((Object)jpsCompilerExcludes, (String)"getInstance()\n          \u2026        .compilerExcludes");
        JpsCompilerExcludes compilerExcludes = jpsCompilerExcludes;
        BuildRootIndex buildRootIndex = localContext.getProjectDescriptor().getBuildRootIndex();
        List list2 = buildRootIndex.getTargetRoots((BuildTarget)this.jpsModuleBuildTarget, localContext);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"buildRootIndex.getTarget\u2026uildTarget, localContext)");
        List roots = list2;
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            JavaSourceRootDescriptor rootDescriptor = (JavaSourceRootDescriptor)element$iv;
            boolean bl = false;
            boolean isCrossCompiled = rootDescriptor instanceof KotlinIncludedModuleSourceRoot;
            File file = rootDescriptor.root;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootDescriptor.root");
            Sequence sequence = (Sequence)FilesKt.walkTopDown((File)file).onEnter((Function1)new Function1<File, Boolean>((HashSet<File>)moduleExcludes){
                final /* synthetic */ HashSet<File> $moduleExcludes;
                {
                    this.$moduleExcludes = $moduleExcludes;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    return !this.$moduleExcludes.contains(file);
                }
            });
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File file2 = (File)element$iv2;
                boolean bl2 = false;
                if (compilerExcludes.isExcluded(file2) || !file2.isFile() || !KotlinDirtySourceFilesHolderKt.isKotlinSourceFile(file2)) continue;
                result.put(file2, new Source(file2, isCrossCompiled));
            }
        }
        return result;
    }

    public final boolean isFromIncludedSourceRoot(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Source source = this.getSources().get(file);
        return source != null ? source.isCrossCompiled() : false;
    }

    @NotNull
    public final Collection<File> getSourceFiles() {
        return this.getSources().keySet();
    }

    @NotNull
    public String toString() {
        String string = this.jpsModuleBuildTarget.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jpsModuleBuildTarget.toString()");
        return string;
    }

    public abstract boolean compileModuleChunk(@NotNull CommonCompilerArguments var1, @NotNull KotlinDirtySourceFilesHolder var2, @NotNull JpsCompilerEnvironment var3);

    /*
     * WARNING - void declaration
     */
    public void registerOutputItems(@NotNull ModuleLevelBuilder.OutputConsumer outputConsumer, @NotNull List<? extends GeneratedFile> outputItems) {
        Intrinsics.checkNotNullParameter((Object)outputConsumer, (String)"outputConsumer");
        Intrinsics.checkNotNullParameter(outputItems, (String)"outputItems");
        for (GeneratedFile generatedFile : outputItems) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = generatedFile.getSourceFiles();
            File file = generatedFile.getOutputFile();
            BuildTarget buildTarget = (BuildTarget)this.jpsModuleBuildTarget;
            ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPath());
            }
            collection = (List)destination$iv$iv;
            outputConsumer2.registerOutputFile(buildTarget, file, (Collection)collection);
        }
    }

    protected final boolean reportAndSkipCircular(@NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (this.getChunk().getTargets().size() > 1) {
            MessageCollector.report$default(environment.getMessageCollector(), CompilerMessageSeverity.STRONG_WARNING, "Circular dependencies are not supported. The following modules depend on each other: " + this.getChunk().getPresentableShortName() + " Kotlin is not compiled for these modules", null, 4, null);
            return true;
        }
        return false;
    }

    public void doAfterBuild() {
    }

    public boolean getHasCaches() {
        return this.hasCaches;
    }

    @NotNull
    public abstract JpsIncrementalCache createCacheStorage(@NotNull BuildDataPaths var1);

    public void updateChunkMappings(@NotNull CompileContext localContext, @NotNull ModuleChunk chunk, @NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull Map<ModuleBuildTarget, ? extends Iterable<? extends GeneratedFile>> outputItems, @NotNull Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)localContext, (String)"localContext");
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter(outputItems, (String)"outputItems");
        Intrinsics.checkNotNullParameter(incrementalCaches, (String)"incrementalCaches");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
    }

    public void updateCaches(@NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull JpsIncrementalCache jpsIncrementalCache, @NotNull List<? extends GeneratedFile> files, @NotNull ChangesCollector changesCollector, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkNotNullParameter((Object)jpsIncrementalCache, (String)"jpsIncrementalCache");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Set changedAndRemovedFiles = SetsKt.plus(dirtyFilesHolder2.getDirtyFiles(this.jpsModuleBuildTarget).keySet(), (Iterable)dirtyFilesHolder2.getRemovedFiles(this.jpsModuleBuildTarget));
        ExpectActualTracker expectActualTracker = environment.getServices().get(ExpectActualTracker.class);
        Intrinsics.checkNotNull((Object)expectActualTracker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.ExpectActualTrackerImpl");
        ExpectActualTrackerImpl expectActualTracker2 = (ExpectActualTrackerImpl)expectActualTracker;
        jpsIncrementalCache.updateComplementaryFiles(changedAndRemovedFiles, expectActualTracker2);
    }

    public void makeServices(@NotNull Services.Builder builder, @NotNull Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, @NotNull LookupTracker lookupTracker, @NotNull ExpectActualTracker exceptActualTracer, @NotNull InlineConstTracker inlineConstTracker, @NotNull EnumWhenTracker enumWhenTracker) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(incrementalCaches, (String)"incrementalCaches");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkNotNullParameter((Object)exceptActualTracer, (String)"exceptActualTracer");
        Intrinsics.checkNotNullParameter((Object)inlineConstTracker, (String)"inlineConstTracker");
        Intrinsics.checkNotNullParameter((Object)enumWhenTracker, (String)"enumWhenTracker");
        Services.Builder $this$makeServices_u24lambda_u245 = builder;
        boolean bl = false;
        $this$makeServices_u24lambda_u245.register(LookupTracker.class, lookupTracker);
        $this$makeServices_u24lambda_u245.register(ExpectActualTracker.class, exceptActualTracer);
        $this$makeServices_u24lambda_u245.register(CompilationCanceledStatus.class, new CompilationCanceledStatus(this){
            final /* synthetic */ KotlinModuleBuildTarget<BuildMetaInfoType> this$0;
            {
                this.this$0 = $receiver;
            }

            public void checkCanceled() {
                if (this.this$0.getJpsGlobalContext().getCancelStatus().isCanceled()) {
                    throw new CompilationCanceledException();
                }
            }
        });
        $this$makeServices_u24lambda_u245.register(InlineConstTracker.class, inlineConstTracker);
        $this$makeServices_u24lambda_u245.register(EnumWhenTracker.class, enumWhenTracker);
    }

    @NotNull
    protected final SourcesToCompile collectSourcesToCompile(@NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2) {
        Intrinsics.checkNotNullParameter((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        return new SourcesToCompile(this.getChunk().getRepresentativeTarget().isIncrementalCompilationEnabled() ? dirtyFilesHolder2.getDirtyFiles(this.jpsModuleBuildTarget).values() : this.getSources().values(), dirtyFilesHolder2.getRemovedFiles(this.jpsModuleBuildTarget));
    }

    @NotNull
    public abstract BuildMetaInfoFactory<BuildMetaInfoType> getBuildMetaInfoFactory();

    @NotNull
    public abstract String getBuildMetaInfoFileName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isVersionChanged(@NotNull KotlinChunk chunk, @NotNull BuildMetaInfo buildMetaInfo) {
        String reasonToRebuild;
        BuildMetaInfo buildMetaInfo2;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)buildMetaInfo, (String)"buildMetaInfo");
        Path file = chunk.buildMetaInfoFile(this.jpsModuleBuildTarget);
        if (Files.notExists(file, new LinkOption[0])) {
            return false;
        }
        try {
            BuildMetaInfoFactory<BuildMetaInfoType> buildMetaInfoFactory = this.getBuildMetaInfoFactory();
            InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(file)");
            Closeable closeable = inputStream;
            Object object = Charsets.UTF_8;
            Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            BuildMetaInfoFactory<BuildMetaInfoType> buildMetaInfoFactory2 = buildMetaInfoFactory;
            object = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                object2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            BuildMetaInfo buildMetaInfo3 = buildMetaInfoFactory2.deserializeFromString((String)object2);
            if (buildMetaInfo3 == null) {
                return false;
            }
            buildMetaInfo2 = buildMetaInfo3;
        }
        catch (Exception e) {
            KotlinBuilder.Companion.getLOG().error("Could not deserialize build meta info", (Throwable)e);
            return false;
        }
        BuildMetaInfo prevBuildMetaInfo = buildMetaInfo2;
        LanguageVersion prevLangVersion = LanguageVersion.Companion.fromVersionString(prevBuildMetaInfo.getLanguageVersionString());
        ApiVersion prevApiVersion = ApiVersion.Companion.parse(prevBuildMetaInfo.getApiVersionString());
        String string = chunk.getLangVersion() != prevLangVersion ? "Language version was changed (" + prevLangVersion + " -> " + chunk.getLangVersion() + ')' : (!Intrinsics.areEqual((Object)chunk.getApiVersion(), (Object)prevApiVersion) ? "Api version was changed (" + prevApiVersion + " -> " + chunk.getApiVersion() + ')' : (reasonToRebuild = prevLangVersion != LanguageVersion.KOTLIN_1_0 && prevBuildMetaInfo.isEAP() && !buildMetaInfo.isEAP() ? "Last build was compiled with EAP-plugin" : new PluginClasspathsComparator(prevBuildMetaInfo.getPluginClasspaths(), buildMetaInfo.getPluginClasspaths()).describeDifferencesOrNull()));
        if (reasonToRebuild != null) {
            KotlinBuilder.Companion.getLOG().info(reasonToRebuild + ". Performing non-incremental rebuild (kotlin only)");
            return true;
        }
        return false;
    }

    private final void checkRepresentativeTarget(KotlinChunk chunk) {
        if (!Intrinsics.areEqual(chunk.getRepresentativeTarget(), (Object)this)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void checkRepresentativeTarget(ModuleChunk chunk) {
        if (!Intrinsics.areEqual((Object)chunk.representativeTarget(), (Object)this.jpsModuleBuildTarget)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void checkRepresentativeTarget(List<? extends KotlinModuleBuildTarget<?>> chunk) {
        if (!Intrinsics.areEqual((Object)CollectionsKt.first(chunk), (Object)this)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public static final /* synthetic */ Map access$computeSourcesList(KotlinModuleBuildTarget $this, CompileContext localContext) {
        return $this.computeSourcesList(localContext);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Source;", "", "file", "Ljava/io/File;", "isCrossCompiled", "", "(Ljava/io/File;Z)V", "getFile", "()Ljava/io/File;", "()Z", "jps-plugin"})
    public static final class Source {
        @NotNull
        private final File file;
        private final boolean isCrossCompiled;

        public Source(@NotNull File file, boolean isCrossCompiled) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.isCrossCompiled = isCrossCompiled;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final boolean isCrossCompiled() {
            return this.isCrossCompiled;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$SourcesToCompile;", "", "sources", "", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Source;", "removedFiles", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;Ljava/util/Collection;Ljava/util/Collection;)V", "allFiles", "", "getAllFiles", "()Ljava/util/List;", "crossCompiledFiles", "getCrossCompiledFiles", "getRemovedFiles", "()Ljava/util/Collection;", "logFiles", "", "jps-plugin"})
    public final class SourcesToCompile {
        @NotNull
        private final Collection<File> removedFiles;
        @NotNull
        private final List<File> allFiles;
        @NotNull
        private final List<File> crossCompiledFiles;

        /*
         * WARNING - void declaration
         */
        public SourcesToCompile(@NotNull Collection<Source> sources, Collection<? extends File> removedFiles) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Source it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            Intrinsics.checkNotNullParameter(removedFiles, (String)"removedFiles");
            this.removedFiles = removedFiles;
            Iterable iterable = sources;
            SourcesToCompile sourcesToCompile = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Source source = (Source)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFile());
            }
            sourcesToCompile.allFiles = (List)destination$iv$iv;
            $this$map$iv = sources;
            sourcesToCompile = this;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Source)element$iv$iv;
                boolean bl = false;
                if (!it.isCrossCompiled()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Source)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFile());
            }
            sourcesToCompile.crossCompiledFiles = (List)destination$iv$iv;
        }

        @NotNull
        public final Collection<File> getRemovedFiles() {
            return this.removedFiles;
        }

        @NotNull
        public final List<File> getAllFiles() {
            return this.allFiles;
        }

        @NotNull
        public final List<File> getCrossCompiledFiles() {
            return this.crossCompiledFiles;
        }

        public final boolean logFiles() {
            boolean hasDirtyOrRemovedSources;
            boolean hasRemovedSources = !this.removedFiles.isEmpty();
            boolean bl = hasDirtyOrRemovedSources = !((Collection)this.allFiles).isEmpty() || hasRemovedSources;
            if (hasDirtyOrRemovedSources) {
                ProjectBuilderLogger projectBuilderLogger = KotlinModuleBuildTarget.this.getJpsGlobalContext().getLoggingManager().getProjectBuilderLogger();
                Intrinsics.checkNotNullExpressionValue((Object)projectBuilderLogger, (String)"jpsGlobalContext.logging\u2026ager.projectBuilderLogger");
                ProjectBuilderLogger logger = projectBuilderLogger;
                if (logger.isEnabled()) {
                    logger.logCompiledFiles((Collection)this.allFiles, "Kotlin Builder", "Compiling files:");
                }
            }
            return hasDirtyOrRemovedSources;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\r\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J/\u0010\u0010\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget$Dependency;", "", "src", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "target", "exported", "", "(Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;Z)V", "getExported", "()Z", "getSrc", "()Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "getTarget", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "jps-plugin"})
    public static final class Dependency {
        @NotNull
        private final KotlinModuleBuildTarget<?> src;
        @NotNull
        private final KotlinModuleBuildTarget<?> target;
        private final boolean exported;

        public Dependency(@NotNull KotlinModuleBuildTarget<?> src, @NotNull KotlinModuleBuildTarget<?> target, boolean exported) {
            Intrinsics.checkNotNullParameter(src, (String)"src");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            this.src = src;
            this.target = target;
            this.exported = exported;
        }

        @NotNull
        public final KotlinModuleBuildTarget<?> getSrc() {
            return this.src;
        }

        @NotNull
        public final KotlinModuleBuildTarget<?> getTarget() {
            return this.target;
        }

        public final boolean getExported() {
            return this.exported;
        }

        @NotNull
        public final KotlinModuleBuildTarget<?> component1() {
            return this.src;
        }

        @NotNull
        public final KotlinModuleBuildTarget<?> component2() {
            return this.target;
        }

        public final boolean component3() {
            return this.exported;
        }

        @NotNull
        public final Dependency copy(@NotNull KotlinModuleBuildTarget<?> src, @NotNull KotlinModuleBuildTarget<?> target, boolean exported) {
            Intrinsics.checkNotNullParameter(src, (String)"src");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            return new Dependency(src, target, exported);
        }

        public static /* synthetic */ Dependency copy$default(Dependency dependency, KotlinModuleBuildTarget kotlinModuleBuildTarget, KotlinModuleBuildTarget kotlinModuleBuildTarget2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                kotlinModuleBuildTarget = dependency.src;
            }
            if ((n & 2) != 0) {
                kotlinModuleBuildTarget2 = dependency.target;
            }
            if ((n & 4) != 0) {
                bl = dependency.exported;
            }
            return dependency.copy(kotlinModuleBuildTarget, kotlinModuleBuildTarget2, bl);
        }

        @NotNull
        public String toString() {
            return "Dependency(src=" + this.src + ", target=" + this.target + ", exported=" + this.exported + ')';
        }

        public int hashCode() {
            int result = this.src.hashCode();
            result = result * 31 + this.target.hashCode();
            int n = this.exported ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Dependency)) {
                return false;
            }
            Dependency dependency = (Dependency)other;
            if (!Intrinsics.areEqual(this.src, dependency.src)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.target, dependency.target)) {
                return false;
            }
            return this.exported == dependency.exported;
        }
    }
}

