/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.utils;

import java.io.File;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.WorkResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compilerRunner.KonanCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunnerKt;
import org.jetbrains.kotlin.gradle.logging.GradleLoggingUtilsKt;
import org.jetbrains.kotlin.gradle.utils.FormattingUtilsKt;
import org.jetbrains.kotlin.gradle.utils.NativeCompilerDownloader;
import org.jetbrains.kotlin.gradle.utils.ResourceUtilsKt;
import org.jetbrains.kotlin.konan.KonanVersion;
import org.jetbrains.kotlin.konan.MetaVersion;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.util.DependencyProcessor;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020%H\u0002J\u0006\u0010&\u001a\u00020%J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\bH\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\nR\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader;", "", "project", "Lorg/gradle/api/Project;", "compilerVersion", "Lorg/jetbrains/kotlin/konan/KonanVersion;", "(Lorg/gradle/api/Project;Lorg/jetbrains/kotlin/konan/KonanVersion;)V", "archiveExtension", "", "getArchiveExtension", "()Ljava/lang/String;", "compilerDirectory", "Ljava/io/File;", "getCompilerDirectory", "()Ljava/io/File;", "dependencyFileName", "getDependencyFileName", "dependencyName", "getDependencyName", "dependencyNameWithVersion", "getDependencyNameWithVersion", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "getProject", "()Lorg/gradle/api/Project;", "simpleOsName", "getSimpleOsName", "useZip", "", "getUseZip", "()Z", "archiveFileTree", "Lorg/gradle/api/file/FileTree;", "archive", "downloadAndExtract", "", "downloadIfNeeded", "removeRepo", "repo", "Lorg/gradle/api/artifacts/repositories/ArtifactRepository;", "setupRepo", "repoUrl", "Companion", "kotlin-gradle-plugin"})
public final class NativeCompilerDownloader {
    @NotNull
    private final Project project;
    private final KonanVersion compilerVersion;
    @NotNull
    private static final Lazy DEFAULT_KONAN_VERSION$delegate;
    private static final String BASE_DOWNLOAD_URL = "https://download.jetbrains.com/kotlin/native/builds";
    public static final Companion Companion;

    @NotNull
    public final File getCompilerDirectory() {
        return FilesKt.resolve((File)DependencyProcessor.Companion.getLocalKonanDir(), (String)this.getDependencyNameWithVersion());
    }

    private final Logger getLogger() {
        Logger logger = this.project.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
        return logger;
    }

    private final String getSimpleOsName() {
        return HostManager.Companion.simpleOsName();
    }

    private final String getDependencyName() {
        return "kotlin-native-" + this.getSimpleOsName();
    }

    private final String getDependencyNameWithVersion() {
        return this.getDependencyName() + '-' + this.compilerVersion;
    }

    private final String getDependencyFileName() {
        return this.getDependencyNameWithVersion() + '.' + this.getArchiveExtension();
    }

    private final boolean getUseZip() {
        return HostManager.Companion.getHostIsMingw();
    }

    private final String getArchiveExtension() {
        return this.getUseZip() ? "zip" : "tar.gz";
    }

    private final FileTree archiveFileTree(File archive) {
        FileTree fileTree;
        if (this.getUseZip()) {
            FileTree fileTree2 = this.project.zipTree((Object)archive);
            fileTree = fileTree2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree2, (String)"project.zipTree(archive)");
        } else {
            FileTree fileTree3 = this.project.tarTree((Object)archive);
            fileTree = fileTree3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTree3, (String)"project.tarTree(archive)");
        }
        return fileTree;
    }

    private final ArtifactRepository setupRepo(String repoUrl) {
        IvyArtifactRepository ivyArtifactRepository = this.project.getRepositories().ivy((Action)new Action<IvyArtifactRepository>(repoUrl){
            final /* synthetic */ String $repoUrl;

            public final void execute(IvyArtifactRepository repo2) {
                repo2.setUrl((Object)this.$repoUrl);
                repo2.layout("pattern", (Action)setupRepo.1.INSTANCE);
                repo2.metadataSources((Action)setupRepo.2.INSTANCE);
            }
            {
                this.$repoUrl = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactRepository, (String)"project.repositories.ivy\u2026)\n            }\n        }");
        return (ArtifactRepository)ivyArtifactRepository;
    }

    private final void removeRepo(ArtifactRepository repo2) {
        this.project.getRepositories().remove((Object)repo2);
    }

    private final void downloadAndExtract() {
        Logger $receiver$iv;
        String string;
        boolean bl;
        Long l2;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $receiver = stringBuilder;
        boolean l2 = false;
        $receiver.append("https://download.jetbrains.com/kotlin/native/builds/");
        $receiver.append(this.compilerVersion.getMeta() == MetaVersion.DEV ? "dev/" : "releases/");
        $receiver.append("" + this.compilerVersion + '/');
        $receiver.append(this.getSimpleOsName());
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        String repoUrl = string2;
        String dependencyUrl = repoUrl + '/' + this.getDependencyFileName();
        ArtifactRepository repo2 = this.setupRepo(repoUrl);
        Dependency compilerDependency = this.project.getDependencies().create((Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"name", (Object)this.getDependencyName()), TuplesKt.to((Object)"version", (Object)this.compilerVersion.toString()), TuplesKt.to((Object)"ext", (Object)this.getArchiveExtension())}));
        Configuration configuration2 = this.project.getConfigurations().detachedConfiguration(new Dependency[]{compilerDependency});
        this.getLogger().lifecycle("\nPlease wait while Kotlin/Native compiler " + this.compilerVersion + " is being installed.");
        Long l3 = ResourceUtilsKt.probeRemoteFileLength(this.project, dependencyUrl, 200);
        if (l3 != null) {
            l2 = l3;
            bl = false;
            boolean bl5 = false;
            long it = ((Number)l2).longValue();
            boolean bl6 = false;
            string = " (" + FormattingUtilsKt.formatContentLength(it) + ')';
        } else {
            string = null;
        }
        l2 = string;
        bl = false;
        Object object = l2;
        if (object == null) {
            object = "";
        }
        Long suffix = object;
        this.getLogger().lifecycle("Download " + dependencyUrl + (String)((Object)suffix));
        Logger logger = this.getLogger();
        String messagePrefix$iv = "Download " + dependencyUrl + " finished,";
        boolean $i$f$lifecycleWithDuration = false;
        long startTime$iv = System.currentTimeMillis();
        boolean bl7 = false;
        Configuration configuration3 = configuration2;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
        Set set2 = configuration3.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"configuration.files");
        File result$iv = (File)CollectionsKt.single((Iterable)set2);
        long finishTime$iv = System.currentTimeMillis();
        $receiver$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv - startTime$iv));
        File archive = result$iv;
        Logger logger2 = this.getLogger();
        StringBuilder stringBuilder2 = new StringBuilder().append("Using Kotlin/Native compiler archive: ");
        File file = archive;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"archive");
        GradleLoggingUtilsKt.kotlinInfo(logger2, stringBuilder2.append(file.getAbsolutePath()).toString());
        this.getLogger().lifecycle("Unpack Kotlin/Native compiler to " + this.getCompilerDirectory());
        $receiver$iv = this.getLogger();
        messagePrefix$iv = "Unpack Kotlin/Native compiler to " + this.getCompilerDirectory() + " finished,";
        $i$f$lifecycleWithDuration = false;
        startTime$iv = System.currentTimeMillis();
        boolean bl8 = false;
        WorkResult result$iv2 = this.project.copy((Action)new Action<CopySpec>(this, archive){
            final /* synthetic */ NativeCompilerDownloader this$0;
            final /* synthetic */ File $archive$inlined;
            {
                this.this$0 = nativeCompilerDownloader;
                this.$archive$inlined = file;
            }

            public final void execute(CopySpec it) {
                Object[] objectArray = new Object[1];
                File file = this.$archive$inlined;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"archive");
                objectArray[0] = NativeCompilerDownloader.access$archiveFileTree(this.this$0, file);
                it.from(objectArray);
                it.into((Object)DependencyProcessor.Companion.getLocalKonanDir());
            }
        });
        finishTime$iv = System.currentTimeMillis();
        $receiver$iv.lifecycle(messagePrefix$iv + " took " + FormattingUtilsKt.formatDuration(finishTime$iv - startTime$iv));
        this.removeRepo(repo2);
    }

    public final void downloadIfNeeded() {
        if (new KonanCompilerRunner(this.project, null, false, 6, null).getClasspath().isEmpty()) {
            this.downloadAndExtract();
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public NativeCompilerDownloader(@NotNull Project project, @NotNull KonanVersion compilerVersion) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)compilerVersion, (String)"compilerVersion");
        this.project = project;
        this.compilerVersion = compilerVersion;
    }

    public /* synthetic */ NativeCompilerDownloader(Project project, KonanVersion konanVersion, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            konanVersion = KotlinNativeToolRunnerKt.getKonanVersion(project);
        }
        this(project, konanVersion);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_KONAN_VERSION$delegate = LazyKt.lazy((Function0)Companion.DEFAULT_KONAN_VERSION.2.INSTANCE);
    }

    public static final /* synthetic */ FileTree access$archiveFileTree(NativeCompilerDownloader $this, File archive) {
        return $this.archiveFileTree(archive);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/gradle/utils/NativeCompilerDownloader$Companion;", "", "()V", "BASE_DOWNLOAD_URL", "", "DEFAULT_KONAN_VERSION", "Lorg/jetbrains/kotlin/konan/KonanVersion;", "getDEFAULT_KONAN_VERSION$kotlin_gradle_plugin", "()Lorg/jetbrains/kotlin/konan/KonanVersion;", "DEFAULT_KONAN_VERSION$delegate", "Lkotlin/Lazy;", "kotlin-gradle-plugin"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "DEFAULT_KONAN_VERSION", "getDEFAULT_KONAN_VERSION$kotlin_gradle_plugin()Lorg/jetbrains/kotlin/konan/KonanVersion;"))};
        }

        @NotNull
        public final KonanVersion getDEFAULT_KONAN_VERSION$kotlin_gradle_plugin() {
            Lazy lazy = DEFAULT_KONAN_VERSION$delegate;
            Companion companion = Companion;
            KProperty kProperty = $$delegatedProperties[0];
            boolean bl = false;
            return (KonanVersion)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

