/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.js.yarn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.targets.js.nodejs.NodeJsExtensionKt;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmApi;
import org.jetbrains.kotlin.gradle.targets.js.npm.NpmProjectPackage;
import org.jetbrains.kotlin.gradle.targets.js.npm.PackageJson;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnBasics;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnImportedPackagesVersionResolver;
import org.jetbrains.kotlin.gradle.targets.js.yarn.YarnUpToDateCheck;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002J&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnWorkspaces;", "Lorg/jetbrains/kotlin/gradle/targets/js/yarn/YarnBasics;", "()V", "resolveProject", "", "resolvedNpmProject", "Lorg/jetbrains/kotlin/gradle/targets/js/npm/NpmProjectPackage;", "resolveRootProject", "rootProject", "Lorg/gradle/api/Project;", "subProjects", "", "resolveWorkspaces", "npmProjects", "saveRootProjectWorkspacesPackageJson", "nodeJsWorldDir", "Ljava/io/File;", "kotlin-gradle-plugin"})
public final class YarnWorkspaces
extends YarnBasics {
    public static final YarnWorkspaces INSTANCE;

    @Override
    public void resolveProject(@NotNull NpmProjectPackage resolvedNpmProject) {
        Intrinsics.checkParameterIsNotNull((Object)resolvedNpmProject, (String)"resolvedNpmProject");
    }

    @Override
    public void resolveRootProject(@NotNull Project rootProject, @NotNull List<NpmProjectPackage> subProjects) {
        Intrinsics.checkParameterIsNotNull((Object)rootProject, (String)"rootProject");
        Intrinsics.checkParameterIsNotNull(subProjects, (String)"subProjects");
        boolean bl = Intrinsics.areEqual((Object)rootProject, (Object)rootProject.getRootProject());
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.setup(rootProject);
        this.resolveWorkspaces(rootProject, subProjects);
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveWorkspaces(Project rootProject, List<NpmProjectPackage> npmProjects) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object element$iv2;
        boolean bl;
        List upToDateChecks;
        Object object;
        Object object2;
        block7: {
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv = npmProjects;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                NpmProjectPackage npmProjectPackage = (NpmProjectPackage)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl2 = false;
                object = new YarnUpToDateCheck(it.getNpmProject());
                object2.add(object);
            }
            upToDateChecks = (List)destination$iv$iv;
            Iterable $this$all$iv = upToDateChecks;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    YarnUpToDateCheck it = (YarnUpToDateCheck)element$iv2;
                    boolean bl3 = false;
                    if (it.getUpToDate()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        File nodeJsWorldDir = NodeJsExtensionKt.getNodeJs(rootProject).getRoot().getRootPackageDir();
        this.saveRootProjectWorkspacesPackageJson(rootProject, npmProjects, nodeJsWorldDir);
        this.yarnExec(rootProject, nodeJsWorldDir, NpmApi.Companion.resolveOperationDescription("yarn"), new String[0]);
        Iterable $i$f$all = npmProjects;
        object = nodeJsWorldDir;
        object2 = this;
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NpmProjectPackage it = (NpmProjectPackage)element$iv$iv;
            boolean bl4 = false;
            Iterable list$iv$iv = it.getNpmDependencies();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        ((YarnBasics)object2).yarnLockReadTransitiveDependencies((File)object, list2);
        Iterable $this$forEach$iv = upToDateChecks;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            YarnUpToDateCheck it = (YarnUpToDateCheck)element$iv3;
            boolean bl5 = false;
            it.commit();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveRootProjectWorkspacesPackageJson(Project rootProject, List<NpmProjectPackage> npmProjects, File nodeJsWorldDir) {
        void $this$mapTo$iv$iv;
        String string = rootProject.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"rootProject.name");
        PackageJson rootPackageJson = new PackageJson(string, rootProject.getVersion().toString());
        rootPackageJson.setPrivate(true);
        Iterable $this$map$iv = npmProjects;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NpmProjectPackage npmProjectPackage = (NpmProjectPackage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = FilesKt.relativeTo((File)it.getNpmProject().getDir(), (File)nodeJsWorldDir).getPath();
            collection.add(string2);
        }
        List npmProjectWorkspaces = (List)destination$iv$iv;
        List<String> importedProjectWorkspaces = new YarnImportedPackagesVersionResolver(rootProject, npmProjects, nodeJsWorldDir).resolveAndUpdatePackages();
        rootPackageJson.setWorkspaces(CollectionsKt.plus((Collection)npmProjectWorkspaces, (Iterable)importedProjectWorkspaces));
        Iterable $this$forEach$iv = NodeJsExtensionKt.getNodeJs(rootProject).getPackageJsonHandlers$kotlin_gradle_plugin();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)rootPackageJson);
        }
        rootPackageJson.saveTo(FilesKt.resolve((File)nodeJsWorldDir, (String)"package.json"));
    }

    private YarnWorkspaces() {
    }

    static {
        YarnWorkspaces yarnWorkspaces;
        INSTANCE = yarnWorkspaces = new YarnWorkspaces();
    }
}

