/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.Processor;

public class CommonProcessors {
    private static final Processor FALSE = t -> false;
    private static final Processor TRUE = t -> true;

    public static class FindFirstProcessor<T>
    extends FindProcessor<T> {
        @Override
        protected boolean accept(T t) {
            return true;
        }
    }

    public static abstract class FindProcessor<T>
    implements Processor<T> {
        private T myValue;

        public boolean isFound() {
            return this.myValue != null;
        }

        @Nullable
        public T getFoundValue() {
            return this.myValue;
        }

        @Nullable
        public T reset() {
            T prev = this.myValue;
            this.myValue = null;
            return prev;
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myValue = t;
                return false;
            }
            return true;
        }

        protected abstract boolean accept(T var1);
    }

    public static class CollectProcessor<T>
    implements Processor<T> {
        private final Collection<T> myCollection;

        public CollectProcessor(@NotNull Collection<T> collection) {
            if (collection == null) {
                CollectProcessor.$$$reportNull$$$0(0);
            }
            this.myCollection = collection;
        }

        public CollectProcessor() {
            this.myCollection = new ArrayList<T>();
        }

        @Override
        public boolean process(T t) {
            if (this.accept(t)) {
                this.myCollection.add(t);
            }
            return true;
        }

        protected boolean accept(T t) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/CommonProcessors$CollectProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CommonProcessors$CollectProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

