/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.ClockHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcTimestampJavaType
extends AbstractTemporalJavaType<java.util.Date>
implements VersionJavaType<java.util.Date> {
    public static final JdbcTimestampJavaType INSTANCE = new JdbcTimestampJavaType();
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final DateTimeFormatter LITERAL_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.from(ZoneOffset.UTC));

    public JdbcTimestampJavaType() {
        super(Timestamp.class, TimestampMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof java.util.Date;
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        int n2;
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        long t1 = one.getTime();
        long t2 = another.getTime();
        boolean oneIsTimestamp = one instanceof Timestamp;
        boolean anotherIsTimestamp = another instanceof Timestamp;
        int n1 = oneIsTimestamp ? ((Timestamp)one).getNanos() : 0;
        int n = n2 = anotherIsTimestamp ? ((Timestamp)another).getNanos() : 0;
        if (t1 != t2) {
            return false;
        }
        if (oneIsTimestamp && anotherIsTimestamp) {
            int nn1 = n1 % 1000000;
            int nn2 = n2 % 1000000;
            return nn1 == nn2;
        }
        return true;
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        return Long.valueOf(value.getTime() / 1000L).hashCode();
    }

    @Override
    public java.util.Date coerce(Object value, JavaType.CoercionContext coercionContext) {
        return this.wrap(value, (WrapperOptions)null);
    }

    @Override
    public Object unwrap(java.util.Date value, Class type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return value instanceof Timestamp ? (Timestamp)value : new Timestamp(value.getTime());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return cal;
        }
        if (Long.class.isAssignableFrom(type)) {
            return value.getTime();
        }
        if (Date.class.isAssignableFrom(type)) {
            return value instanceof Date ? (Date)value : new Date(value.getTime());
        }
        if (Time.class.isAssignableFrom(type)) {
            return value instanceof Time ? (Time)value : new Time(value.getTime());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> java.util.Date wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        switch (javaType.getJavaType().getTypeName()) {
            case "java.sql.Date": 
            case "java.sql.Timestamp": 
            case "java.util.Date": 
            case "java.util.Calendar": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString(java.util.Date value) {
        return LITERAL_FORMATTER.format(value.toInstant());
    }

    @Override
    public java.util.Date fromString(CharSequence string) {
        try {
            TemporalAccessor accessor = LITERAL_FORMATTER.parse(string);
            return new Timestamp(accessor.getLong(ChronoField.INSTANT_SECONDS) * 1000L + (long)(accessor.get(ChronoField.NANO_OF_SECOND) / 1000000));
        }
        catch (DateTimeParseException pe) {
            throw new HibernateException("could not parse timestamp string" + string, pe);
        }
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(93);
    }

    @Override
    protected <X> TemporalJavaType<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    protected <X> TemporalJavaType<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return JdbcDateJavaType.INSTANCE;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    public java.util.Date next(java.util.Date current, Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return this.seed(length, precision, scale, session);
    }

    @Override
    public java.util.Date seed(Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return Timestamp.from(ClockHelper.forPrecision(precision, session).instant());
    }

    public static class TimestampMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final TimestampMutabilityPlan INSTANCE = new TimestampMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            if (value instanceof Timestamp) {
                Timestamp orig = (Timestamp)value;
                Timestamp copy = new Timestamp(orig.getTime());
                copy.setNanos(orig.getNanos());
                return copy;
            }
            return new Timestamp(value.getTime());
        }
    }
}

