/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SqmJoinable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralPartJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.spi.NavigablePath;

public class EntitySqmPathSource<J>
extends AbstractSqmPathSource<J>
implements SqmJoinable<Object, J> {
    public EntitySqmPathSource(String localPathName, EntityDomainType<J> domainType, Bindable.BindableType jpaBindableType) {
        super(localPathName, domainType, jpaBindableType);
    }

    @Override
    public EntityDomainType<J> getSqmPathType() {
        return (EntityDomainType)super.getSqmPathType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        DomainType sqmPathType = this.getSqmPathType();
        return sqmPathType.findSubPathSource(name);
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        NavigablePath navigablePath = intermediatePathSource == null ? lhs.getNavigablePath().append(this.getPathName()) : lhs.getNavigablePath().append(intermediatePathSource.getPathName()).append(this.getPathName());
        return new SqmEntityValuedSimplePath(navigablePath, this, lhs, lhs.nodeBuilder());
    }

    @Override
    public SqmPluralPartJoin<Object, J> createSqmJoin(SqmFrom<?, Object> lhs, SqmJoinType joinType, String alias, boolean fetched, SqmCreationState creationState) {
        return new SqmPluralPartJoin(lhs, this, alias, joinType, creationState.getCreationContext().getNodeBuilder());
    }

    @Override
    public String getName() {
        return this.getPathName();
    }
}

