/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.access;

import java.util.Optional;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.LockOptions;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.loader.access.LoadAccessContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class IdentifierLoadAccessImpl<T>
implements IdentifierLoadAccess<T>,
JavaType.CoercionContext {
    private final LoadAccessContext context;
    private final EntityPersister entityPersister;
    private LockOptions lockOptions;
    private CacheMode cacheMode;
    private Boolean readOnly;
    private RootGraphImplementor<T> rootGraph;
    private GraphSemantic graphSemantic;

    public IdentifierLoadAccessImpl(LoadAccessContext context, EntityPersister entityPersister) {
        this.context = context;
        this.entityPersister = entityPersister;
    }

    @Override
    public final IdentifierLoadAccessImpl<T> with(LockOptions lockOptions) {
        this.lockOptions = lockOptions;
        return this;
    }

    @Override
    public IdentifierLoadAccess<T> with(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public IdentifierLoadAccess<T> withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public IdentifierLoadAccess<T> with(RootGraph<T> graph, GraphSemantic semantic) {
        this.rootGraph = (RootGraphImplementor)graph;
        this.graphSemantic = semantic;
        return this;
    }

    @Override
    public final T getReference(Object id) {
        return (T)this.perform(() -> this.doGetReference(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T perform(Supplier<T> executor) {
        SessionImplementor session = this.context.getSession();
        CacheMode sessionCacheMode = session.getCacheMode();
        boolean cacheModeChanged = false;
        if (this.cacheMode != null && this.cacheMode != sessionCacheMode) {
            session.setCacheMode(this.cacheMode);
            cacheModeChanged = true;
        }
        try {
            T t;
            block11: {
                if (this.graphSemantic != null) {
                    if (this.rootGraph == null) {
                        throw new IllegalArgumentException("Graph semantic specified, but no RootGraph was supplied");
                    }
                    session.getLoadQueryInfluencers().getEffectiveEntityGraph().applyGraph(this.rootGraph, this.graphSemantic);
                }
                try {
                    t = executor.get();
                    if (this.graphSemantic == null) break block11;
                    session.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
                }
                catch (Throwable throwable) {
                    if (this.graphSemantic != null) {
                        session.getLoadQueryInfluencers().getEffectiveEntityGraph().clear();
                    }
                    throw throwable;
                }
            }
            return t;
        }
        finally {
            if (cacheModeChanged) {
                session.setCacheMode(sessionCacheMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doGetReference(Object id) {
        Boolean readOnly;
        SessionImplementor session = this.context.getSession();
        EventSource eventSource = (EventSource)session;
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        JpaCompliance jpaCompliance = session.getFactory().getSessionFactoryOptions().getJpaCompliance();
        if (!jpaCompliance.isLoadByIdComplianceEnabled()) {
            id = this.entityPersister.getIdentifierMapping().getJavaType().coerce(id, this);
        }
        String entityName = this.entityPersister.getEntityName();
        Boolean bl = readOnly = this.readOnly != null ? this.readOnly : loadQueryInfluencers.getReadOnly();
        if (this.lockOptions != null) {
            LoadEvent event = new LoadEvent(id, entityName, this.lockOptions, eventSource, readOnly);
            this.context.fireLoad(event, LoadEventListener.LOAD);
            return (T)event.getResult();
        }
        LoadEvent event = new LoadEvent(id, entityName, false, eventSource, readOnly);
        boolean success = false;
        try {
            this.context.fireLoad(event, LoadEventListener.LOAD);
            if (event.getResult() == null) {
                session.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityName, id);
            }
            success = true;
            Object object = event.getResult();
            return (T)object;
        }
        finally {
            this.context.afterOperation(success);
        }
    }

    @Override
    public final T load(Object id) {
        return (T)this.perform(() -> this.doLoad(id));
    }

    @Override
    public Optional<T> loadOptional(Object id) {
        return Optional.ofNullable(this.perform(() -> this.doLoad(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T doLoad(Object id) {
        Boolean readOnly;
        SessionImplementor session = this.context.getSession();
        EventSource eventSource = (EventSource)session;
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        JpaCompliance jpaCompliance = session.getFactory().getSessionFactoryOptions().getJpaCompliance();
        if (!jpaCompliance.isLoadByIdComplianceEnabled()) {
            id = this.entityPersister.getIdentifierMapping().getJavaType().coerce(id, this);
        }
        String entityName = this.entityPersister.getEntityName();
        Boolean bl = readOnly = this.readOnly != null ? this.readOnly : loadQueryInfluencers.getReadOnly();
        if (this.lockOptions != null) {
            LoadEvent event = new LoadEvent(id, entityName, this.lockOptions, eventSource, readOnly);
            this.context.fireLoad(event, LoadEventListener.GET);
            Object result = event.getResult();
            this.initializeIfNecessary(result);
            return (T)result;
        }
        LoadEvent event = new LoadEvent(id, entityName, false, eventSource, readOnly);
        boolean success = false;
        try {
            this.context.fireLoad(event, LoadEventListener.GET);
            success = true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
        }
        finally {
            this.context.afterOperation(success);
        }
        Object result = event.getResult();
        this.initializeIfNecessary(result);
        return (T)result;
    }

    private void initializeIfNecessary(Object result) {
        if (result == null) {
            return;
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(result);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                lazyInitializer.initialize();
            }
        } else {
            BytecodeLazyAttributeInterceptor interceptor;
            BytecodeEnhancementMetadata enhancementMetadata = this.entityPersister.getEntityMetamodel().getBytecodeEnhancementMetadata();
            if (enhancementMetadata.isEnhancedForLazyLoading() && (interceptor = enhancementMetadata.extractLazyInterceptor(result)) instanceof EnhancementAsProxyLazinessInterceptor) {
                ((EnhancementAsProxyLazinessInterceptor)interceptor).forceInitialize(result, null);
            }
        }
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.context.getSession().getSessionFactory().getTypeConfiguration();
    }
}

