/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.Remove;
import org.hibernate.annotations.Index;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitCollectionTableNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.NamingStrategyHelper;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AnnotatedJoinColumn;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.IndexOrUniqueKeySecondPass;
import org.hibernate.cfg.JPAIndexHolder;
import org.hibernate.cfg.ObjectNameSource;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

public class TableBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TableBinder.class.getName());
    MetadataBuildingContext buildingContext;
    private String schema;
    private String catalog;
    private String name;
    private boolean isAbstract;
    private List<UniqueConstraintHolder> uniqueConstraints;
    String constraints;
    private String ownerEntityTable;
    private String associatedEntityTable;
    private String propertyName;
    private String ownerClassName;
    private String ownerEntity;
    private String ownerJpaEntity;
    private String associatedClassName;
    private String associatedEntity;
    private String associatedJpaEntity;
    private boolean isJPA2ElementCollection;
    private List<JPAIndexHolder> jpaIndexHolders;

    public void setBuildingContext(MetadataBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public void setUniqueConstraints(UniqueConstraint[] uniqueConstraints) {
        this.uniqueConstraints = TableBinder.buildUniqueConstraintHolders(uniqueConstraints);
    }

    public void setJpaIndex(jakarta.persistence.Index[] jpaIndex) {
        this.jpaIndexHolders = TableBinder.buildJpaIndexHolder(jpaIndex);
    }

    public void setConstraints(String constraints) {
        this.constraints = constraints;
    }

    public void setJPA2ElementCollection(boolean isJPA2ElementCollection) {
        this.isJPA2ElementCollection = isJPA2ElementCollection;
    }

    public Table bind() {
        final Identifier ownerEntityTableNameIdentifier = this.toIdentifier(this.ownerEntityTable);
        final String unquotedOwnerTable = StringHelper.unquote(this.ownerEntityTable);
        final String unquotedAssocTable = StringHelper.unquote(this.associatedEntityTable);
        ObjectNameSource nameSource = this.buildNameContext();
        final boolean ownerEntityTableQuoted = StringHelper.isQuoted(this.ownerEntityTable);
        final boolean associatedEntityTableQuoted = StringHelper.isQuoted(this.associatedEntityTable);
        NamingStrategyHelper namingStrategyHelper = new NamingStrategyHelper(){

            @Override
            public Identifier determineImplicitName(final MetadataBuildingContext buildingContext) {
                ImplicitNamingStrategy namingStrategy = buildingContext.getBuildingOptions().getImplicitNamingStrategy();
                Identifier name = TableBinder.this.isJPA2ElementCollection ? namingStrategy.determineCollectionTableName(new ImplicitCollectionTableNameSource(){
                    private final EntityNaming entityNaming = new EntityNaming(){

                        @Override
                        public String getClassName() {
                            return TableBinder.this.ownerClassName;
                        }

                        @Override
                        public String getEntityName() {
                            return TableBinder.this.ownerEntity;
                        }

                        @Override
                        public String getJpaEntityName() {
                            return TableBinder.this.ownerJpaEntity;
                        }
                    };

                    @Override
                    public Identifier getOwningPhysicalTableName() {
                        return ownerEntityTableNameIdentifier;
                    }

                    @Override
                    public EntityNaming getOwningEntityNaming() {
                        return this.entityNaming;
                    }

                    @Override
                    public AttributePath getOwningAttributePath() {
                        return AttributePath.parse(TableBinder.this.propertyName);
                    }

                    @Override
                    public MetadataBuildingContext getBuildingContext() {
                        return buildingContext;
                    }
                }) : namingStrategy.determineJoinTableName(new ImplicitJoinTableNameSource(){
                    private final EntityNaming owningEntityNaming = new EntityNaming(){

                        @Override
                        public String getClassName() {
                            return TableBinder.this.ownerClassName;
                        }

                        @Override
                        public String getEntityName() {
                            return TableBinder.this.ownerEntity;
                        }

                        @Override
                        public String getJpaEntityName() {
                            return TableBinder.this.ownerJpaEntity;
                        }
                    };
                    private final EntityNaming nonOwningEntityNaming = new EntityNaming(){

                        @Override
                        public String getClassName() {
                            return TableBinder.this.associatedClassName;
                        }

                        @Override
                        public String getEntityName() {
                            return TableBinder.this.associatedEntity;
                        }

                        @Override
                        public String getJpaEntityName() {
                            return TableBinder.this.associatedJpaEntity;
                        }
                    };

                    @Override
                    public String getOwningPhysicalTableName() {
                        return unquotedOwnerTable;
                    }

                    @Override
                    public EntityNaming getOwningEntityNaming() {
                        return this.owningEntityNaming;
                    }

                    @Override
                    public String getNonOwningPhysicalTableName() {
                        return unquotedAssocTable;
                    }

                    @Override
                    public EntityNaming getNonOwningEntityNaming() {
                        return this.nonOwningEntityNaming;
                    }

                    @Override
                    public AttributePath getAssociationOwningAttributePath() {
                        return AttributePath.parse(TableBinder.this.propertyName);
                    }

                    @Override
                    public MetadataBuildingContext getBuildingContext() {
                        return buildingContext;
                    }
                });
                if (ownerEntityTableQuoted || associatedEntityTableQuoted) {
                    name = Identifier.quote(name);
                }
                return name;
            }

            @Override
            public Identifier handleExplicitName(String explicitName, MetadataBuildingContext buildingContext) {
                return buildingContext.getMetadataCollector().getDatabase().toIdentifier(explicitName);
            }

            @Override
            public Identifier toPhysicalName(Identifier logicalName, MetadataBuildingContext buildingContext) {
                return buildingContext.getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalName, buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment());
            }
        };
        return TableBinder.buildAndFillTable(this.schema, this.catalog, nameSource, namingStrategyHelper, this.isAbstract, this.uniqueConstraints, this.jpaIndexHolders, this.constraints, this.buildingContext, null, null);
    }

    private Identifier toIdentifier(String tableName) {
        return this.buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(tableName);
    }

    private ObjectNameSource buildNameContext() {
        if (this.name != null) {
            return new AssociationTableNameSource(this.name, null);
        }
        Identifier logicalName = this.isJPA2ElementCollection ? this.buildingContext.getBuildingOptions().getImplicitNamingStrategy().determineCollectionTableName(new ImplicitCollectionTableNameSource(){
            private final EntityNaming owningEntityNaming = new EntityNaming(){

                @Override
                public String getClassName() {
                    return TableBinder.this.ownerClassName;
                }

                @Override
                public String getEntityName() {
                    return TableBinder.this.ownerEntity;
                }

                @Override
                public String getJpaEntityName() {
                    return TableBinder.this.ownerJpaEntity;
                }
            };

            @Override
            public Identifier getOwningPhysicalTableName() {
                return TableBinder.this.toIdentifier(TableBinder.this.ownerEntityTable);
            }

            @Override
            public EntityNaming getOwningEntityNaming() {
                return this.owningEntityNaming;
            }

            @Override
            public AttributePath getOwningAttributePath() {
                return AttributePath.parse(TableBinder.this.propertyName);
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return TableBinder.this.buildingContext;
            }
        }) : this.buildingContext.getBuildingOptions().getImplicitNamingStrategy().determineJoinTableName(new ImplicitJoinTableNameSource(){
            private final EntityNaming owningEntityNaming = new EntityNaming(){

                @Override
                public String getClassName() {
                    return TableBinder.this.ownerClassName;
                }

                @Override
                public String getEntityName() {
                    return TableBinder.this.ownerEntity;
                }

                @Override
                public String getJpaEntityName() {
                    return TableBinder.this.ownerJpaEntity;
                }
            };
            private final EntityNaming nonOwningEntityNaming = new EntityNaming(){

                @Override
                public String getClassName() {
                    return TableBinder.this.associatedClassName;
                }

                @Override
                public String getEntityName() {
                    return TableBinder.this.associatedEntity;
                }

                @Override
                public String getJpaEntityName() {
                    return TableBinder.this.associatedJpaEntity;
                }
            };

            @Override
            public String getOwningPhysicalTableName() {
                return TableBinder.this.ownerEntityTable;
            }

            @Override
            public EntityNaming getOwningEntityNaming() {
                return this.owningEntityNaming;
            }

            @Override
            public String getNonOwningPhysicalTableName() {
                return TableBinder.this.associatedEntityTable;
            }

            @Override
            public EntityNaming getNonOwningEntityNaming() {
                return this.nonOwningEntityNaming;
            }

            @Override
            public AttributePath getAssociationOwningAttributePath() {
                return AttributePath.parse(TableBinder.this.propertyName);
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return TableBinder.this.buildingContext;
            }
        });
        return new AssociationTableNameSource(this.name, logicalName.render());
    }

    public static Table buildAndFillTable(String schema, String catalog, ObjectNameSource nameSource, NamingStrategyHelper namingStrategyHelper, boolean isAbstract, List<UniqueConstraintHolder> uniqueConstraints, List<JPAIndexHolder> jpaIndexHolders, String constraints, MetadataBuildingContext buildingContext, String subselect, InFlightMetadataCollector.EntityTableXref denormalizedSuperTableXref) {
        Identifier logicalName = StringHelper.isNotEmpty(nameSource.getExplicitName()) ? namingStrategyHelper.handleExplicitName(nameSource.getExplicitName(), buildingContext) : namingStrategyHelper.determineImplicitName(buildingContext);
        return TableBinder.buildAndFillTable(schema, catalog, logicalName, isAbstract, uniqueConstraints, jpaIndexHolders, constraints, buildingContext, subselect, denormalizedSuperTableXref);
    }

    public static Table buildAndFillTable(String schema, String catalog, Identifier logicalName, boolean isAbstract, List<UniqueConstraintHolder> uniqueConstraints, List<JPAIndexHolder> jpaIndexHolders, String constraints, MetadataBuildingContext buildingContext, String subselect, InFlightMetadataCollector.EntityTableXref denormalizedSuperTableXref) {
        schema = BinderHelper.isEmptyOrNullAnnotationValue(schema) ? null : schema;
        catalog = BinderHelper.isEmptyOrNullAnnotationValue(catalog) ? null : catalog;
        Table table = denormalizedSuperTableXref != null ? buildingContext.getMetadataCollector().addDenormalizedTable(schema, catalog, logicalName.render(), isAbstract, subselect, denormalizedSuperTableXref.getPrimaryTable(), buildingContext) : buildingContext.getMetadataCollector().addTable(schema, catalog, logicalName.render(), subselect, isAbstract, buildingContext);
        if (CollectionHelper.isNotEmpty(uniqueConstraints)) {
            buildingContext.getMetadataCollector().addUniqueConstraintHolders(table, uniqueConstraints);
        }
        if (CollectionHelper.isNotEmpty(jpaIndexHolders)) {
            buildingContext.getMetadataCollector().addJpaIndexHolders(table, jpaIndexHolders);
        }
        if (constraints != null) {
            table.addCheckConstraint(constraints);
        }
        buildingContext.getMetadataCollector().addTableNameBinding(logicalName, table);
        return table;
    }

    @Deprecated(since="6.1")
    @Remove
    public static void bindFk(PersistentClass referencedEntity, PersistentClass destinationEntity, AnnotatedJoinColumn[] columns, SimpleValue value, boolean unique, MetadataBuildingContext buildingContext) {
        TableBinder.bindForeignKey(referencedEntity, destinationEntity, columns, value, unique, buildingContext);
    }

    public static void bindForeignKey(PersistentClass referencedEntity, PersistentClass destinationEntity, AnnotatedJoinColumn[] columns, SimpleValue value, boolean unique, MetadataBuildingContext buildingContext) {
        PropertyHolder holder;
        PersistentClass associatedClass = destinationEntity != null ? destinationEntity : ((holder = columns[0].getPropertyHolder()) == null ? null : holder.getPersistentClass());
        String mappedByProperty = columns[0].getMappedBy();
        if (StringHelper.isNotEmpty(mappedByProperty)) {
            TableBinder.bindUnownedAssociation(columns, value, associatedClass, mappedByProperty);
        } else if (columns[0].isImplicit()) {
            TableBinder.bindImplicitColumns(referencedEntity, columns, value);
        } else {
            TableBinder.bindExplicitColumns(referencedEntity, columns, value, buildingContext, associatedClass);
        }
        value.createForeignKey();
        if (unique) {
            value.createUniqueKey();
        }
    }

    private static void bindExplicitColumns(PersistentClass referencedEntity, AnnotatedJoinColumn[] columns, SimpleValue value, MetadataBuildingContext buildingContext, PersistentClass associatedClass) {
        switch (AnnotatedJoinColumn.checkReferencedColumnsType(columns, referencedEntity, buildingContext)) {
            case 2: {
                TableBinder.bindNonPkReference(referencedEntity, columns, value);
                break;
            }
            case 0: {
                TableBinder.bindImplicitPkReference(referencedEntity, columns, value, associatedClass);
                break;
            }
            default: {
                TableBinder.bindPkReference(referencedEntity, columns, value, associatedClass, buildingContext);
            }
        }
    }

    private static void bindImplicitPkReference(PersistentClass referencedEntity, AnnotatedJoinColumn[] columns, SimpleValue value, PersistentClass associatedClass) {
        if (columns.length != referencedEntity.getIdentifier().getColumnSpan()) {
            throw new AnnotationException("An association that targets entity '" + referencedEntity.getEntityName() + "' from entity '" + associatedClass.getEntityName() + "' has " + columns.length + " '@JoinColumn's but the primary key has " + referencedEntity.getIdentifier().getColumnSpan() + " columns");
        }
        TableBinder.linkJoinColumnWithValueOverridingNameIfImplicit(referencedEntity, referencedEntity.getIdentifier(), columns, value);
        if (value instanceof SortableValue) {
            ((SortableValue)((Object)value)).sortProperties();
        }
    }

    private static void bindPkReference(PersistentClass referencedEntity, AnnotatedJoinColumn[] columns, SimpleValue value, PersistentClass associatedClass, MetadataBuildingContext buildingContext) {
        KeyValue key = referencedEntity.getKey();
        if (key instanceof Component) {
            ((Component)key).sortProperties();
        }
        Dialect dialect = buildingContext.getMetadataCollector().getDatabase().getJdbcEnvironment().getDialect();
        for (Column col : key.getColumns()) {
            boolean match = false;
            String colName = col.getQuotedName(dialect);
            for (AnnotatedJoinColumn joinCol : columns) {
                String referencedColumn = buildingContext.getMetadataCollector().getPhysicalColumnName(referencedEntity.getTable(), joinCol.getReferencedColumn());
                if (!referencedColumn.equalsIgnoreCase(colName)) continue;
                if (joinCol.isNameDeferred()) {
                    joinCol.linkValueUsingDefaultColumnNaming(col, referencedEntity, value);
                } else {
                    joinCol.linkWithValue(value);
                }
                joinCol.overrideFromReferencedColumnIfNecessary(col);
                match = true;
                break;
            }
            if (match) continue;
            throw new AnnotationException("An association that targets entity '" + referencedEntity.getEntityName() + "' from entity '" + associatedClass.getEntityName() + "' has no '@JoinColumn' referencing column '" + col.getName());
        }
        if (value instanceof ToOne) {
            ((ToOne)value).setSorted(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void bindNonPkReference(PersistentClass referencedEntity, AnnotatedJoinColumn[] columns, SimpleValue value) {
        String referencedPropertyName;
        if (value instanceof ToOne) {
            referencedPropertyName = ((ToOne)value).getReferencedPropertyName();
        } else {
            if (!(value instanceof DependantValue)) throw new AssertionFailure("Property ref to an unexpected Value type: " + value.getClass().getName());
            String propertyName = columns[0].getPropertyName();
            if (propertyName == null) throw new AnnotationException("The '@JoinColumn' for a secondary table must reference the primary key");
            Collection collection = (Collection)referencedEntity.getRecursiveProperty(propertyName).getValue();
            referencedPropertyName = collection.getReferencedPropertyName();
        }
        if (referencedPropertyName == null) {
            throw new AssertionFailure("No property ref found");
        }
        Property synthProp = referencedEntity.getReferencedProperty(referencedPropertyName);
        if (synthProp == null) {
            throw new AssertionFailure("Cannot find synthetic property: " + referencedEntity.getEntityName() + "." + referencedPropertyName);
        }
        TableBinder.linkJoinColumnWithValueOverridingNameIfImplicit(referencedEntity, synthProp.getValue(), columns, value);
        ((SortableValue)((Object)value)).sortProperties();
    }

    private static void bindImplicitColumns(PersistentClass referencedEntity, AnnotatedJoinColumn[] columns, SimpleValue value) {
        List<Column> idColumns = referencedEntity instanceof JoinedSubclass ? referencedEntity.getKey().getColumns() : referencedEntity.getIdentifier().getColumns();
        for (Column column : idColumns) {
            columns[0].linkValueUsingDefaultColumnNaming(column, referencedEntity, value);
            columns[0].overrideFromReferencedColumnIfNecessary(column);
        }
    }

    private static void bindUnownedAssociation(AnnotatedJoinColumn[] columns, SimpleValue value, PersistentClass associatedClass, String mappedByProperty) {
        for (Column column : TableBinder.mappedByColumns(associatedClass, mappedByProperty)) {
            columns[0].overrideFromReferencedColumnIfNecessary(column);
            columns[0].linkValueUsingAColumnCopy(column, value);
        }
    }

    private static List<Column> mappedByColumns(PersistentClass associatedClass, String mappedByProperty) {
        LOG.debugf("Retrieving property %s.%s", associatedClass.getEntityName(), mappedByProperty);
        Value value = associatedClass.getRecursiveProperty(mappedByProperty).getValue();
        if (value instanceof Collection) {
            Value element = ((Collection)value).getElement();
            if (element == null) {
                throw new AnnotationException("Both sides of the bidirectional association '" + associatedClass.getEntityName() + "." + mappedByProperty + "' specify 'mappedBy'");
            }
            return element.getColumns();
        }
        return value.getColumns();
    }

    public static void linkJoinColumnWithValueOverridingNameIfImplicit(PersistentClass referencedEntity, Value value, AnnotatedJoinColumn[] columns, SimpleValue simpleValue) {
        List<Column> valueColumns = value.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            AnnotatedJoinColumn joinCol = columns[i];
            Column synthCol = valueColumns.get(i);
            if (joinCol.isNameDeferred()) {
                joinCol.linkValueUsingDefaultColumnNaming(synthCol, referencedEntity, simpleValue);
                continue;
            }
            joinCol.linkWithValue(simpleValue);
            joinCol.overrideFromReferencedColumnIfNecessary(synthCol);
        }
    }

    public static void addIndexes(Table hibTable, Index[] indexes, MetadataBuildingContext buildingContext) {
        for (Index index : indexes) {
            buildingContext.getMetadataCollector().addSecondPass(new IndexOrUniqueKeySecondPass(hibTable, index.name(), index.columnNames(), buildingContext));
        }
    }

    public static void addIndexes(Table hibTable, jakarta.persistence.Index[] indexes, MetadataBuildingContext buildingContext) {
        buildingContext.getMetadataCollector().addJpaIndexHolders(hibTable, TableBinder.buildJpaIndexHolder(indexes));
    }

    public static List<JPAIndexHolder> buildJpaIndexHolder(jakarta.persistence.Index[] indexes) {
        ArrayList<JPAIndexHolder> holders = new ArrayList<JPAIndexHolder>(indexes.length);
        for (jakarta.persistence.Index index : indexes) {
            holders.add(new JPAIndexHolder(index));
        }
        return holders;
    }

    public static List<UniqueConstraintHolder> buildUniqueConstraintHolders(UniqueConstraint[] annotations) {
        List<UniqueConstraintHolder> result;
        if (annotations == null || annotations.length == 0) {
            result = Collections.emptyList();
        } else {
            result = CollectionHelper.arrayList(annotations.length);
            for (UniqueConstraint uc : annotations) {
                result.add(new UniqueConstraintHolder().setName(uc.name()).setColumns(uc.columnNames()));
            }
        }
        return result;
    }

    public void setDefaultName(String ownerClassName, String ownerEntity, String ownerJpaEntity, String ownerEntityTable, String associatedClassName, String associatedEntity, String associatedJpaEntity, String associatedEntityTable, String propertyName) {
        this.ownerClassName = ownerClassName;
        this.ownerEntity = ownerEntity;
        this.ownerJpaEntity = ownerJpaEntity;
        this.ownerEntityTable = ownerEntityTable;
        this.associatedClassName = associatedClassName;
        this.associatedEntity = associatedEntity;
        this.associatedJpaEntity = associatedJpaEntity;
        this.associatedEntityTable = associatedEntityTable;
        this.propertyName = propertyName;
        this.name = null;
    }

    private static class AssociationTableNameSource
    implements ObjectNameSource {
        private final String explicitName;
        private final String logicalName;

        private AssociationTableNameSource(String explicitName, String logicalName) {
            this.explicitName = explicitName;
            this.logicalName = logicalName;
        }

        @Override
        public String getExplicitName() {
            return this.explicitName;
        }

        @Override
        public String getLogicalName() {
            return this.logicalName;
        }
    }
}

