/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.lang.reflect.Constructor;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.boot.SchemaAutoTooling;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.boot.internal.DefaultCustomEntityDirtinessStrategy;
import org.hibernate.boot.internal.StandardEntityNotFoundDelegate;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelectionException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.internal.StandardTimestampsCacheFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsCacheFactory;
import org.hibernate.cfg.BaselineSessionEventsListenerBuilder;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.internal.ConfigurationServiceImpl;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.id.uuid.LocalObjectUuidHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.EmptyInterceptor;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.PropertiesHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.jpa.spi.MutableJpaCompliance;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.ImmutableEntityUpdateQueryHandlingMode;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.sqm.NullPrecedence;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.FormatMapper;
import org.hibernate.type.jackson.JacksonIntegration;
import org.hibernate.type.jakartajson.JakartaJsonIntegration;
import org.hibernate.type.jaxb.JaxbXmlFormatMapper;

public class SessionFactoryOptionsBuilder
implements SessionFactoryOptions {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SessionFactoryOptionsBuilder.class);
    private final String uuid = LocalObjectUuidHelper.generateLocalObjectUuid();
    private final StandardServiceRegistry serviceRegistry;
    private Object beanManagerReference;
    private Object validatorFactoryReference;
    private FormatMapper jsonFormatMapper;
    private FormatMapper xmlFormatMapper;
    private boolean jpaBootstrap;
    private String sessionFactoryName;
    private boolean sessionFactoryNameAlsoJndiName;
    private boolean flushBeforeCompletionEnabled;
    private boolean autoCloseSessionEnabled;
    private boolean jtaTransactionAccessEnabled;
    private boolean allowOutOfTransactionUpdateOperations;
    private boolean releaseResourcesOnCloseEnabled;
    private boolean allowRefreshDetachedEntity;
    private boolean jtaTrackByThread;
    private boolean preferUserTransaction;
    private boolean statisticsEnabled;
    private Interceptor interceptor;
    private Class<? extends Interceptor> statelessInterceptorClass;
    private Supplier<? extends Interceptor> statelessInterceptorSupplier;
    private StatementInspector statementInspector;
    private final List<SessionFactoryObserver> sessionFactoryObserverList = new ArrayList<SessionFactoryObserver>();
    private final BaselineSessionEventsListenerBuilder baselineSessionEventsListenerBuilder;
    private CustomEntityDirtinessStrategy customEntityDirtinessStrategy;
    private final List<EntityNameResolver> entityNameResolvers = new ArrayList<EntityNameResolver>();
    private EntityNotFoundDelegate entityNotFoundDelegate;
    private boolean identifierRollbackEnabled;
    private boolean checkNullability;
    private boolean initializeLazyStateOutsideTransactions;
    private TempTableDdlTransactionHandling tempTableDdlTransactionHandling;
    private BatchFetchStyle batchFetchStyle;
    private boolean delayBatchFetchLoaderCreations;
    private int defaultBatchFetchSize;
    private Integer maximumFetchDepth;
    private NullPrecedence defaultNullPrecedence;
    private boolean orderUpdatesEnabled;
    private boolean orderInsertsEnabled;
    private boolean postInsertIdentifierDelayed;
    private boolean collectionsInDefaultFetchGroupEnabled;
    private boolean callbacksEnabled;
    private boolean multiTenancyEnabled;
    private CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
    private HqlTranslator hqlTranslator;
    private SqmMultiTableMutationStrategy sqmMultiTableMutationStrategy;
    private SqmMultiTableInsertStrategy sqmMultiTableInsertStrategy;
    private SqmFunctionRegistry sqmFunctionRegistry;
    private SqmTranslatorFactory sqmTranslatorFactory;
    private Boolean useOfJdbcNamedParametersEnabled;
    private boolean namedQueryStartupCheckingEnabled;
    private final int preferredSqlTypeCodeForBoolean;
    private final int preferredSqlTypeCodeForDuration;
    private final int preferredSqlTypeCodeForUuid;
    private final int preferredSqlTypeCodeForInstant;
    private final int preferredSqlTypeCodeForArray;
    private final TimeZoneStorageStrategy defaultTimeZoneStorageStrategy;
    private boolean secondLevelCacheEnabled;
    private boolean queryCacheEnabled;
    private TimestampsCacheFactory timestampsCacheFactory;
    private String cacheRegionPrefix;
    private boolean minimalPutsEnabled;
    private boolean structuredCacheEntriesEnabled;
    private boolean directReferenceCacheEntriesEnabled;
    private boolean autoEvictCollectionCache;
    private SchemaAutoTooling schemaAutoTooling;
    private boolean getGeneratedKeysEnabled;
    private int jdbcBatchSize;
    private boolean jdbcBatchVersionedData;
    private Integer jdbcFetchSize;
    private boolean scrollableResultSetsEnabled;
    private boolean commentsEnabled;
    private PhysicalConnectionHandlingMode connectionHandlingMode;
    private boolean connectionProviderDisablesAutoCommit;
    private TimeZone jdbcTimeZone;
    private ValueHandlingMode criteriaValueHandlingMode;
    private boolean criteriaCopyTreeEnabled;
    private ImmutableEntityUpdateQueryHandlingMode immutableEntityUpdateQueryHandlingMode;
    private final String defaultCatalog;
    private final String defaultSchema;
    private Map<String, SqmFunctionDescriptor> sqlFunctions;
    private JpaCompliance jpaCompliance;
    private boolean failOnPaginationOverCollectionFetchEnabled;
    private boolean inClauseParameterPaddingEnabled;
    private int queryStatisticsMaxSize;

    public SessionFactoryOptionsBuilder(StandardServiceRegistry serviceRegistry, BootstrapContext context) {
        this.serviceRegistry = serviceRegistry;
        this.jpaBootstrap = context.isJpaBootstrap();
        StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
        ConfigurationService cfgService = serviceRegistry.getService(ConfigurationService.class);
        JdbcServices jdbcServices = serviceRegistry.getService(JdbcServices.class);
        HashMap<String, Object> configurationSettings = new HashMap<String, Object>();
        configurationSettings.putAll(PropertiesHelper.map(jdbcServices.getJdbcEnvironment().getDialect().getDefaultProperties()));
        configurationSettings.putAll(cfgService.getSettings());
        if (cfgService == null) {
            cfgService = new ConfigurationServiceImpl(configurationSettings);
            ((ConfigurationServiceImpl)cfgService).injectServices((ServiceRegistryImplementor)((Object)serviceRegistry));
        }
        this.beanManagerReference = NullnessHelper.coalesceSuppliedValues(() -> configurationSettings.get("jakarta.persistence.bean.manager"), () -> {
            Object value = configurationSettings.get("javax.persistence.bean.manager");
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.bean.manager", "jakarta.persistence.bean.manager");
            }
            return value;
        });
        this.validatorFactoryReference = configurationSettings.getOrDefault("javax.persistence.validation.factory", configurationSettings.get("jakarta.persistence.validation.factory"));
        this.jsonFormatMapper = SessionFactoryOptionsBuilder.determineJsonFormatMapper(configurationSettings.get("hibernate.type.json_format_mapper"), strategySelector);
        this.xmlFormatMapper = SessionFactoryOptionsBuilder.determineXmlFormatMapper(configurationSettings.get("hibernate.type.xml_format_mapper"), strategySelector);
        this.sessionFactoryName = (String)configurationSettings.get("hibernate.session_factory_name");
        this.sessionFactoryNameAlsoJndiName = cfgService.getSetting("hibernate.session_factory_name_is_jndi", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        this.jtaTransactionAccessEnabled = cfgService.getSetting("hibernate.jta.allowTransactionAccess", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        this.allowRefreshDetachedEntity = cfgService.getSetting("hibernate.allow_refresh_detached_entity", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        this.flushBeforeCompletionEnabled = cfgService.getSetting("hibernate.transaction.flush_before_completion", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        this.autoCloseSessionEnabled = cfgService.getSetting("hibernate.transaction.auto_close_session", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        this.statisticsEnabled = cfgService.getSetting("hibernate.generate_statistics", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        this.interceptor = SessionFactoryOptionsBuilder.determineInterceptor(configurationSettings, strategySelector);
        this.statelessInterceptorSupplier = SessionFactoryOptionsBuilder.determineStatelessInterceptor(configurationSettings, strategySelector);
        this.statementInspector = strategySelector.resolveStrategy(StatementInspector.class, configurationSettings.get("hibernate.session_factory.statement_inspector"));
        String autoSessionEventsListenerName = (String)configurationSettings.get("hibernate.session.events.auto");
        Class<SessionEventListener> autoSessionEventsListener = autoSessionEventsListenerName == null ? null : strategySelector.selectStrategyImplementor(SessionEventListener.class, autoSessionEventsListenerName);
        boolean logSessionMetrics = cfgService.getSetting("hibernate.session.events.log", StandardConverters.BOOLEAN, Boolean.valueOf(this.statisticsEnabled));
        this.baselineSessionEventsListenerBuilder = new BaselineSessionEventsListenerBuilder(logSessionMetrics, autoSessionEventsListener);
        this.customEntityDirtinessStrategy = strategySelector.resolveDefaultableStrategy(CustomEntityDirtinessStrategy.class, configurationSettings.get("hibernate.entity_dirtiness_strategy"), DefaultCustomEntityDirtinessStrategy.INSTANCE);
        this.entityNotFoundDelegate = StandardEntityNotFoundDelegate.INSTANCE;
        this.identifierRollbackEnabled = cfgService.getSetting("hibernate.use_identifier_rollback", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        this.checkNullability = cfgService.getSetting("hibernate.check_nullability", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        this.initializeLazyStateOutsideTransactions = cfgService.getSetting("hibernate.enable_lazy_load_no_trans", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        this.multiTenancyEnabled = serviceRegistry.getService(MultiTenantConnectionProvider.class) != null;
        this.currentTenantIdentifierResolver = strategySelector.resolveStrategy(CurrentTenantIdentifierResolver.class, configurationSettings.get("hibernate.tenant_identifier_resolver"));
        this.batchFetchStyle = BatchFetchStyle.interpret(configurationSettings.get("hibernate.batch_fetch_style"));
        this.delayBatchFetchLoaderCreations = cfgService.getSetting("hibernate.loader.delay_entity_loader_creations", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        this.defaultBatchFetchSize = ConfigurationHelper.getInt("hibernate.default_batch_fetch_size", configurationSettings, -1);
        this.maximumFetchDepth = ConfigurationHelper.getInteger("hibernate.max_fetch_depth", configurationSettings);
        String defaultNullPrecedence = ConfigurationHelper.getString("hibernate.order_by.default_null_ordering", configurationSettings, "none", "first", "last");
        this.defaultNullPrecedence = NullPrecedence.parse(defaultNullPrecedence);
        this.orderUpdatesEnabled = ConfigurationHelper.getBoolean("hibernate.order_updates", configurationSettings);
        this.orderInsertsEnabled = ConfigurationHelper.getBoolean("hibernate.order_inserts", configurationSettings);
        this.callbacksEnabled = ConfigurationHelper.getBoolean("hibernate.jpa_callbacks.enabled", configurationSettings, true);
        this.jtaTrackByThread = cfgService.getSetting("hibernate.jta.track_by_thread", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        String hqlTranslatorImplFqn = ConfigurationHelper.extractPropertyValue("hibernate.query.hql.translator", configurationSettings);
        this.hqlTranslator = this.resolveHqlTranslator(hqlTranslatorImplFqn, serviceRegistry, strategySelector);
        String sqmTranslatorFactoryImplFqn = ConfigurationHelper.extractPropertyValue("hibernate.query.sqm.translator", configurationSettings);
        this.sqmTranslatorFactory = this.resolveSqmTranslator(sqmTranslatorFactoryImplFqn, strategySelector);
        String sqmMutationStrategyImplName = ConfigurationHelper.extractPropertyValue("hibernate.query.mutation_strategy", configurationSettings);
        this.sqmMultiTableMutationStrategy = this.resolveSqmMutationStrategy(sqmMutationStrategyImplName, serviceRegistry, strategySelector);
        String sqmInsertStrategyImplName = ConfigurationHelper.extractValue("hibernate.query.insert_strategy", configurationSettings, () -> null);
        this.sqmMultiTableInsertStrategy = this.resolveSqmInsertStrategy(sqmInsertStrategyImplName, serviceRegistry, strategySelector);
        this.useOfJdbcNamedParametersEnabled = cfgService.getSetting("hibernate.query.proc.callable_named_params_enabled", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        this.namedQueryStartupCheckingEnabled = cfgService.getSetting("hibernate.query.startup_check", StandardConverters.BOOLEAN, Boolean.valueOf(true));
        this.preferredSqlTypeCodeForBoolean = ConfigurationHelper.getPreferredSqlTypeCodeForBoolean(serviceRegistry);
        this.preferredSqlTypeCodeForDuration = ConfigurationHelper.getPreferredSqlTypeCodeForDuration(serviceRegistry);
        this.preferredSqlTypeCodeForUuid = ConfigurationHelper.getPreferredSqlTypeCodeForUuid(serviceRegistry);
        this.preferredSqlTypeCodeForInstant = ConfigurationHelper.getPreferredSqlTypeCodeForInstant(serviceRegistry);
        this.preferredSqlTypeCodeForArray = ConfigurationHelper.getPreferredSqlTypeCodeForArray(serviceRegistry);
        this.defaultTimeZoneStorageStrategy = context.getMetadataBuildingOptions().getDefaultTimeZoneStorage();
        RegionFactory regionFactory = serviceRegistry.getService(RegionFactory.class);
        if (!(regionFactory instanceof NoCachingRegionFactory)) {
            this.secondLevelCacheEnabled = cfgService.getSetting("hibernate.cache.use_second_level_cache", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.queryCacheEnabled = cfgService.getSetting("hibernate.cache.use_query_cache", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.timestampsCacheFactory = strategySelector.resolveDefaultableStrategy(TimestampsCacheFactory.class, configurationSettings.get("hibernate.cache.query_cache_factory"), StandardTimestampsCacheFactory.INSTANCE);
            this.cacheRegionPrefix = ConfigurationHelper.extractPropertyValue("hibernate.cache.region_prefix", configurationSettings);
            this.minimalPutsEnabled = cfgService.getSetting("hibernate.cache.use_minimal_puts", StandardConverters.BOOLEAN, Boolean.valueOf(regionFactory.isMinimalPutsEnabledByDefault()));
            this.structuredCacheEntriesEnabled = cfgService.getSetting("hibernate.cache.use_structured_entries", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.directReferenceCacheEntriesEnabled = cfgService.getSetting("hibernate.cache.use_reference_entries", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.autoEvictCollectionCache = cfgService.getSetting("hibernate.cache.auto_evict_collection_cache", StandardConverters.BOOLEAN, Boolean.valueOf(false));
        } else {
            this.secondLevelCacheEnabled = false;
            this.queryCacheEnabled = false;
            this.timestampsCacheFactory = null;
            this.cacheRegionPrefix = null;
            this.minimalPutsEnabled = false;
            this.structuredCacheEntriesEnabled = false;
            this.directReferenceCacheEntriesEnabled = false;
            this.autoEvictCollectionCache = false;
        }
        try {
            this.schemaAutoTooling = SchemaAutoTooling.interpret((String)configurationSettings.get("hibernate.hbm2ddl.auto"));
        }
        catch (Exception e) {
            log.warn(e.getMessage() + "  Ignoring");
        }
        ExtractedDatabaseMetaData meta = jdbcServices.getExtractedMetaDataSupport();
        this.tempTableDdlTransactionHandling = TempTableDdlTransactionHandling.NONE;
        if (meta.doesDataDefinitionCauseTransactionCommit()) {
            this.tempTableDdlTransactionHandling = meta.supportsDataDefinitionInTransaction() ? TempTableDdlTransactionHandling.ISOLATE_AND_TRANSACT : TempTableDdlTransactionHandling.ISOLATE;
        }
        this.jdbcBatchSize = ConfigurationHelper.getInt("hibernate.jdbc.batch_size", configurationSettings, 1);
        if (!meta.supportsBatchUpdates()) {
            this.jdbcBatchSize = 0;
        }
        this.jdbcBatchVersionedData = ConfigurationHelper.getBoolean("hibernate.jdbc.batch_versioned_data", configurationSettings, true);
        this.scrollableResultSetsEnabled = ConfigurationHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", configurationSettings, meta.supportsScrollableResults());
        this.getGeneratedKeysEnabled = ConfigurationHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", configurationSettings, meta.supportsGetGeneratedKeys());
        this.jdbcFetchSize = ConfigurationHelper.getInteger("hibernate.jdbc.fetch_size", configurationSettings);
        this.connectionHandlingMode = this.interpretConnectionHandlingMode(configurationSettings, serviceRegistry);
        this.connectionProviderDisablesAutoCommit = ConfigurationHelper.getBoolean("hibernate.connection.provider_disables_autocommit", configurationSettings, false);
        this.commentsEnabled = ConfigurationHelper.getBoolean("hibernate.use_sql_comments", configurationSettings);
        this.preferUserTransaction = ConfigurationHelper.getBoolean("hibernate.jta.prefer_user_transaction", configurationSettings, false);
        this.allowOutOfTransactionUpdateOperations = ConfigurationHelper.getBoolean("hibernate.allow_update_outside_transaction", configurationSettings, false);
        this.releaseResourcesOnCloseEnabled = ConfigurationHelper.getBoolean("hibernate.discard_pc_on_close", configurationSettings, false);
        Object jdbcTimeZoneValue = configurationSettings.get("hibernate.jdbc.time_zone");
        if (jdbcTimeZoneValue instanceof TimeZone) {
            this.jdbcTimeZone = (TimeZone)jdbcTimeZoneValue;
        } else if (jdbcTimeZoneValue instanceof ZoneId) {
            this.jdbcTimeZone = TimeZone.getTimeZone((ZoneId)jdbcTimeZoneValue);
        } else if (jdbcTimeZoneValue instanceof String) {
            this.jdbcTimeZone = TimeZone.getTimeZone(ZoneId.of((String)jdbcTimeZoneValue));
        } else if (jdbcTimeZoneValue != null) {
            throw new IllegalArgumentException("Configuration property hibernate.jdbc.time_zone value [" + jdbcTimeZoneValue + "] is not supported");
        }
        this.criteriaValueHandlingMode = ValueHandlingMode.interpret(configurationSettings.get("hibernate.criteria.value_handling_mode"));
        this.criteriaCopyTreeEnabled = ConfigurationHelper.getBoolean("hibernate.criteria.copy_tree", configurationSettings, this.jpaBootstrap);
        this.jpaCompliance = context.getJpaCompliance();
        this.failOnPaginationOverCollectionFetchEnabled = ConfigurationHelper.getBoolean("hibernate.query.fail_on_pagination_over_collection_fetch", configurationSettings, false);
        this.immutableEntityUpdateQueryHandlingMode = ImmutableEntityUpdateQueryHandlingMode.interpret(configurationSettings.get("hibernate.query.immutable_entity_update_query_handling_mode"));
        this.defaultCatalog = ConfigurationHelper.getString("hibernate.default_catalog", configurationSettings);
        this.defaultSchema = ConfigurationHelper.getString("hibernate.default_schema", configurationSettings);
        this.inClauseParameterPaddingEnabled = ConfigurationHelper.getBoolean("hibernate.query.in_clause_parameter_padding", configurationSettings, false);
        this.queryStatisticsMaxSize = ConfigurationHelper.getInt("hibernate.statistics.query_max_size", configurationSettings, 5000);
    }

    private SqmMultiTableMutationStrategy resolveSqmMutationStrategy(String strategyName, StandardServiceRegistry serviceRegistry, StrategySelector strategySelector) {
        if (strategyName == null) {
            return null;
        }
        return strategySelector.resolveStrategy(SqmMultiTableMutationStrategy.class, (Object)strategyName, (SqmMultiTableMutationStrategy)null, strategyClass -> {
            Constructor<?> dialectConstructor = null;
            Constructor<?> emptyConstructor = null;
            for (Constructor<?> declaredConstructor : strategyClass.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = declaredConstructor.getParameterTypes();
                if (parameterTypes.length == 1 && parameterTypes[0] == Dialect.class) {
                    dialectConstructor = declaredConstructor;
                    break;
                }
                if (parameterTypes.length != 0) continue;
                emptyConstructor = declaredConstructor;
            }
            try {
                if (dialectConstructor != null) {
                    return (SqmMultiTableMutationStrategy)dialectConstructor.newInstance(serviceRegistry.getService(JdbcServices.class).getDialect());
                }
                if (emptyConstructor != null) {
                    return (SqmMultiTableMutationStrategy)emptyConstructor.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw new StrategySelectionException(String.format("Could not instantiate named strategy class [%s]", strategyClass.getName()), e);
            }
            throw new IllegalArgumentException("Cannot instantiate the class [" + strategyClass.getName() + "] because it does not have a constructor that accepts a dialect or an empty constructor");
        });
    }

    private SqmMultiTableInsertStrategy resolveSqmInsertStrategy(String strategyName, StandardServiceRegistry serviceRegistry, StrategySelector strategySelector) {
        if (strategyName == null) {
            return null;
        }
        return strategySelector.resolveStrategy(SqmMultiTableInsertStrategy.class, (Object)strategyName, (SqmMultiTableInsertStrategy)null, strategyClass -> {
            Constructor<?> dialectConstructor = null;
            Constructor<?> emptyConstructor = null;
            for (Constructor<?> declaredConstructor : strategyClass.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = declaredConstructor.getParameterTypes();
                if (parameterTypes.length == 1 && parameterTypes[0] == Dialect.class) {
                    dialectConstructor = declaredConstructor;
                    break;
                }
                if (parameterTypes.length != 0) continue;
                emptyConstructor = declaredConstructor;
            }
            try {
                if (dialectConstructor != null) {
                    return (SqmMultiTableInsertStrategy)dialectConstructor.newInstance(serviceRegistry.getService(JdbcServices.class).getDialect());
                }
                if (emptyConstructor != null) {
                    return (SqmMultiTableInsertStrategy)emptyConstructor.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw new StrategySelectionException(String.format("Could not instantiate named strategy class [%s]", strategyClass.getName()), e);
            }
            throw new IllegalArgumentException("Cannot instantiate the class [" + strategyClass.getName() + "] because it does not have a constructor that accepts a dialect or an empty constructor");
        });
    }

    private HqlTranslator resolveHqlTranslator(final String producerName, final StandardServiceRegistry serviceRegistry, StrategySelector strategySelector) {
        if (StringHelper.isEmpty(producerName)) {
            return null;
        }
        return strategySelector.resolveDefaultableStrategy(HqlTranslator.class, (Object)producerName, new Callable<HqlTranslator>(){

            @Override
            public HqlTranslator call() throws Exception {
                ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
                return (HqlTranslator)classLoaderService.classForName(producerName).newInstance();
            }
        });
    }

    private SqmTranslatorFactory resolveSqmTranslator(String translatorImplFqn, StrategySelector strategySelector) {
        if (StringHelper.isEmpty(translatorImplFqn)) {
            return null;
        }
        return strategySelector.resolveStrategy(SqmTranslatorFactory.class, translatorImplFqn);
    }

    private static Interceptor determineInterceptor(Map<String, Object> configurationSettings, StrategySelector strategySelector) {
        Object setting = configurationSettings.get("hibernate.session_factory.interceptor");
        if (setting == null && (setting = configurationSettings.get("hibernate.session_factory.interceptor")) != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.session_factory.interceptor", "hibernate.session_factory.interceptor");
        }
        return strategySelector.resolveStrategy(Interceptor.class, setting);
    }

    private static Supplier<? extends Interceptor> determineStatelessInterceptor(Map<String, Object> configurationSettings, StrategySelector strategySelector) {
        Object setting = configurationSettings.get("hibernate.session_factory.session_scoped_interceptor");
        if (setting == null) {
            return null;
        }
        if (setting instanceof Supplier) {
            return (Supplier)setting;
        }
        if (setting instanceof Class) {
            Class clazz = (Class)setting;
            return SessionFactoryOptionsBuilder.interceptorSupplier(clazz);
        }
        return SessionFactoryOptionsBuilder.interceptorSupplier(strategySelector.selectStrategyImplementor(Interceptor.class, setting.toString()));
    }

    private static Supplier<? extends Interceptor> interceptorSupplier(Class<? extends Interceptor> clazz) {
        return () -> {
            try {
                return (Interceptor)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new HibernateException("Could not supply session-scoped SessionFactory Interceptor", e);
            }
        };
    }

    private PhysicalConnectionHandlingMode interpretConnectionHandlingMode(Map<String, Object> configurationSettings, StandardServiceRegistry serviceRegistry) {
        PhysicalConnectionHandlingMode specifiedHandlingMode = PhysicalConnectionHandlingMode.interpret(configurationSettings.get("hibernate.connection.handling_mode"));
        if (specifiedHandlingMode != null) {
            return specifiedHandlingMode;
        }
        TransactionCoordinatorBuilder transactionCoordinatorBuilder = serviceRegistry.getService(TransactionCoordinatorBuilder.class);
        return transactionCoordinatorBuilder.getDefaultConnectionHandlingMode();
    }

    private static FormatMapper determineJsonFormatMapper(Object setting, StrategySelector strategySelector) {
        return strategySelector.resolveDefaultableStrategy(FormatMapper.class, setting, () -> {
            FormatMapper jsonJacksonFormatMapper = JacksonIntegration.getJsonJacksonFormatMapperOrNull();
            if (jsonJacksonFormatMapper != null) {
                return jsonJacksonFormatMapper;
            }
            return JakartaJsonIntegration.getJakartaJsonBFormatMapperOrNull();
        });
    }

    private static FormatMapper determineXmlFormatMapper(Object setting, StrategySelector strategySelector) {
        return strategySelector.resolveDefaultableStrategy(FormatMapper.class, setting, () -> {
            FormatMapper jacksonFormatMapper = JacksonIntegration.getXMLJacksonFormatMapperOrNull();
            if (jacksonFormatMapper != null) {
                return jacksonFormatMapper;
            }
            return new JaxbXmlFormatMapper();
        });
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public StandardServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public boolean isJpaBootstrap() {
        return this.jpaBootstrap;
    }

    @Override
    public boolean isJtaTransactionAccessEnabled() {
        return this.jtaTransactionAccessEnabled;
    }

    @Override
    public boolean isAllowRefreshDetachedEntity() {
        return this.allowRefreshDetachedEntity;
    }

    @Override
    public boolean isAllowOutOfTransactionUpdateOperations() {
        return this.allowOutOfTransactionUpdateOperations;
    }

    @Override
    public boolean isReleaseResourcesOnCloseEnabled() {
        return this.releaseResourcesOnCloseEnabled;
    }

    @Override
    public Object getBeanManagerReference() {
        return this.beanManagerReference;
    }

    @Override
    public Object getValidatorFactoryReference() {
        return this.validatorFactoryReference;
    }

    @Override
    public String getSessionFactoryName() {
        return this.sessionFactoryName;
    }

    @Override
    public boolean isSessionFactoryNameAlsoJndiName() {
        return this.sessionFactoryNameAlsoJndiName;
    }

    @Override
    public boolean isFlushBeforeCompletionEnabled() {
        return this.flushBeforeCompletionEnabled;
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.autoCloseSessionEnabled;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public Interceptor getInterceptor() {
        return this.interceptor == null ? EmptyInterceptor.INSTANCE : this.interceptor;
    }

    @Override
    public Supplier<? extends Interceptor> getStatelessInterceptorImplementorSupplier() {
        return this.statelessInterceptorSupplier;
    }

    @Override
    public HqlTranslator getCustomHqlTranslator() {
        return this.hqlTranslator;
    }

    @Override
    public SqmTranslatorFactory getCustomSqmTranslatorFactory() {
        return this.sqmTranslatorFactory;
    }

    @Override
    public SqmMultiTableMutationStrategy getCustomSqmMultiTableMutationStrategy() {
        return this.sqmMultiTableMutationStrategy;
    }

    @Override
    public SqmMultiTableInsertStrategy getCustomSqmMultiTableInsertStrategy() {
        return this.sqmMultiTableInsertStrategy;
    }

    @Override
    public boolean isUseOfJdbcNamedParametersEnabled() {
        return this.useOfJdbcNamedParametersEnabled;
    }

    @Override
    public SqmFunctionRegistry getCustomSqmFunctionRegistry() {
        return this.sqmFunctionRegistry;
    }

    @Override
    public StatementInspector getStatementInspector() {
        return this.statementInspector;
    }

    @Override
    public SessionFactoryObserver[] getSessionFactoryObservers() {
        return this.sessionFactoryObserverList.toArray(new SessionFactoryObserver[0]);
    }

    @Override
    public BaselineSessionEventsListenerBuilder getBaselineSessionEventsListenerBuilder() {
        return this.baselineSessionEventsListenerBuilder;
    }

    @Override
    public boolean isIdentifierRollbackEnabled() {
        return this.identifierRollbackEnabled;
    }

    @Override
    public boolean isCheckNullability() {
        return this.checkNullability;
    }

    @Override
    public boolean isInitializeLazyStateOutsideTransactionsEnabled() {
        return this.initializeLazyStateOutsideTransactions;
    }

    @Override
    public TempTableDdlTransactionHandling getTempTableDdlTransactionHandling() {
        return this.tempTableDdlTransactionHandling;
    }

    @Override
    public BatchFetchStyle getBatchFetchStyle() {
        return this.batchFetchStyle;
    }

    @Override
    public boolean isDelayBatchFetchLoaderCreationsEnabled() {
        return this.delayBatchFetchLoaderCreations;
    }

    @Override
    public int getDefaultBatchFetchSize() {
        return this.defaultBatchFetchSize;
    }

    @Override
    public Integer getMaximumFetchDepth() {
        return this.maximumFetchDepth;
    }

    @Override
    public NullPrecedence getDefaultNullPrecedence() {
        return this.defaultNullPrecedence;
    }

    @Override
    public boolean isOrderUpdatesEnabled() {
        return this.orderUpdatesEnabled;
    }

    @Override
    public boolean isOrderInsertsEnabled() {
        return this.orderInsertsEnabled;
    }

    @Override
    public boolean isMultiTenancyEnabled() {
        return this.multiTenancyEnabled;
    }

    @Override
    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.currentTenantIdentifierResolver;
    }

    @Override
    public boolean isJtaTrackByThread() {
        return this.jtaTrackByThread;
    }

    @Override
    public boolean isNamedQueryStartupCheckingEnabled() {
        return this.namedQueryStartupCheckingEnabled;
    }

    @Override
    public boolean isSecondLevelCacheEnabled() {
        return this.secondLevelCacheEnabled;
    }

    @Override
    public boolean isQueryCacheEnabled() {
        return this.queryCacheEnabled;
    }

    @Override
    public TimestampsCacheFactory getTimestampsCacheFactory() {
        return this.timestampsCacheFactory;
    }

    @Override
    public String getCacheRegionPrefix() {
        return this.cacheRegionPrefix;
    }

    @Override
    public boolean isMinimalPutsEnabled() {
        return this.minimalPutsEnabled;
    }

    @Override
    public boolean isStructuredCacheEntriesEnabled() {
        return this.structuredCacheEntriesEnabled;
    }

    @Override
    public boolean isDirectReferenceCacheEntriesEnabled() {
        return this.directReferenceCacheEntriesEnabled;
    }

    @Override
    public boolean isAutoEvictCollectionCache() {
        return this.autoEvictCollectionCache;
    }

    @Override
    public SchemaAutoTooling getSchemaAutoTooling() {
        return this.schemaAutoTooling;
    }

    @Override
    public int getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    @Override
    public boolean isJdbcBatchVersionedData() {
        return this.jdbcBatchVersionedData;
    }

    @Override
    public boolean isScrollableResultSetsEnabled() {
        return this.scrollableResultSetsEnabled;
    }

    @Override
    public boolean isGetGeneratedKeysEnabled() {
        return this.getGeneratedKeysEnabled;
    }

    @Override
    public Integer getJdbcFetchSize() {
        return this.jdbcFetchSize;
    }

    @Override
    public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
        return this.connectionHandlingMode;
    }

    @Override
    public void setCheckNullability(boolean enabled) {
        this.checkNullability = enabled;
    }

    @Override
    public boolean doesConnectionProviderDisableAutoCommit() {
        return this.connectionProviderDisablesAutoCommit;
    }

    @Override
    public boolean isCommentsEnabled() {
        return this.commentsEnabled;
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.customEntityDirtinessStrategy;
    }

    @Override
    public EntityNameResolver[] getEntityNameResolvers() {
        return this.entityNameResolvers.toArray(new EntityNameResolver[0]);
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    @Override
    public Map<String, SqmFunctionDescriptor> getCustomSqlFunctionMap() {
        return this.sqlFunctions == null ? Collections.emptyMap() : this.sqlFunctions;
    }

    @Override
    public boolean isPreferUserTransaction() {
        return this.preferUserTransaction;
    }

    @Override
    public TimeZone getJdbcTimeZone() {
        return this.jdbcTimeZone;
    }

    @Override
    public ValueHandlingMode getCriteriaValueHandlingMode() {
        return this.criteriaValueHandlingMode;
    }

    @Override
    public boolean isCriteriaCopyTreeEnabled() {
        return this.criteriaCopyTreeEnabled;
    }

    @Override
    public ImmutableEntityUpdateQueryHandlingMode getImmutableEntityUpdateQueryHandlingMode() {
        return this.immutableEntityUpdateQueryHandlingMode;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public boolean isFailOnPaginationOverCollectionFetchEnabled() {
        return this.failOnPaginationOverCollectionFetchEnabled;
    }

    @Override
    public boolean inClauseParameterPaddingEnabled() {
        return this.inClauseParameterPaddingEnabled;
    }

    @Override
    public JpaCompliance getJpaCompliance() {
        return this.jpaCompliance;
    }

    @Override
    public int getQueryStatisticsMaxSize() {
        return this.queryStatisticsMaxSize;
    }

    @Override
    public boolean areJPACallbacksEnabled() {
        return this.callbacksEnabled;
    }

    @Override
    public boolean isCollectionsInDefaultFetchGroupEnabled() {
        return this.collectionsInDefaultFetchGroupEnabled;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.preferredSqlTypeCodeForBoolean;
    }

    @Override
    public int getPreferredSqlTypeCodeForDuration() {
        return this.preferredSqlTypeCodeForDuration;
    }

    @Override
    public int getPreferredSqlTypeCodeForUuid() {
        return this.preferredSqlTypeCodeForUuid;
    }

    @Override
    public int getPreferredSqlTypeCodeForInstant() {
        return this.preferredSqlTypeCodeForInstant;
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return this.preferredSqlTypeCodeForArray;
    }

    @Override
    public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return this.defaultTimeZoneStorageStrategy;
    }

    @Override
    public FormatMapper getJsonFormatMapper() {
        return this.jsonFormatMapper;
    }

    @Override
    public FormatMapper getXmlFormatMapper() {
        return this.xmlFormatMapper;
    }

    public void applyBeanManager(Object beanManager) {
        this.beanManagerReference = beanManager;
    }

    public void applyValidatorFactory(Object validatorFactory) {
        this.validatorFactoryReference = validatorFactory;
    }

    public void applySessionFactoryName(String sessionFactoryName) {
        this.sessionFactoryName = sessionFactoryName;
    }

    public void enableSessionFactoryNameAsJndiName(boolean isJndiName) {
        this.sessionFactoryNameAlsoJndiName = isJndiName;
    }

    public void enableSessionAutoClosing(boolean autoClosingEnabled) {
        this.autoCloseSessionEnabled = autoClosingEnabled;
    }

    public void enableSessionAutoFlushing(boolean flushBeforeCompletionEnabled) {
        this.flushBeforeCompletionEnabled = flushBeforeCompletionEnabled;
    }

    public void enableJtaTrackingByThread(boolean enabled) {
        this.jtaTrackByThread = enabled;
    }

    public void enablePreferUserTransaction(boolean preferUserTransaction) {
        this.preferUserTransaction = preferUserTransaction;
    }

    public void enableStatisticsSupport(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    public void addSessionFactoryObservers(SessionFactoryObserver ... observers) {
        Collections.addAll(this.sessionFactoryObserverList, observers);
    }

    public void applyInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void applyStatelessInterceptor(Class<? extends Interceptor> statelessInterceptorClass) {
        this.statelessInterceptorClass = statelessInterceptorClass;
        this.applyStatelessInterceptorSupplier(() -> {
            try {
                return (Interceptor)statelessInterceptorClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new HibernateException(String.format("Could not supply stateless Interceptor of class %s", statelessInterceptorClass.getName()), e);
            }
        });
    }

    public void applyStatelessInterceptorSupplier(Supplier<? extends Interceptor> statelessInterceptorSupplier) {
        this.statelessInterceptorSupplier = statelessInterceptorSupplier;
    }

    public void applySqmFunctionRegistry(SqmFunctionRegistry sqmFunctionRegistry) {
        this.sqmFunctionRegistry = sqmFunctionRegistry;
    }

    public void applyStatementInspector(StatementInspector statementInspector) {
        this.statementInspector = statementInspector;
    }

    public void applyCustomEntityDirtinessStrategy(CustomEntityDirtinessStrategy strategy) {
        this.customEntityDirtinessStrategy = strategy;
    }

    public void addEntityNameResolvers(EntityNameResolver ... entityNameResolvers) {
        Collections.addAll(this.entityNameResolvers, entityNameResolvers);
    }

    public void applyEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.entityNotFoundDelegate = entityNotFoundDelegate;
    }

    public void enableIdentifierRollbackSupport(boolean enabled) {
        this.identifierRollbackEnabled = enabled;
    }

    public void enableNullabilityChecking(boolean enabled) {
        this.checkNullability = enabled;
    }

    public void allowLazyInitializationOutsideTransaction(boolean enabled) {
        this.initializeLazyStateOutsideTransactions = enabled;
    }

    public void applyTempTableDdlTransactionHandling(TempTableDdlTransactionHandling handling) {
        this.tempTableDdlTransactionHandling = handling;
    }

    @Deprecated(since="6.0")
    public void applyBatchFetchStyle(BatchFetchStyle style) {
        this.batchFetchStyle = style;
    }

    public void applyDelayedEntityLoaderCreations(boolean delay) {
        this.delayBatchFetchLoaderCreations = delay;
    }

    public void applyDefaultBatchFetchSize(int size) {
        this.defaultBatchFetchSize = size;
    }

    public void applyMaximumFetchDepth(int depth) {
        this.maximumFetchDepth = depth;
    }

    public void applyDefaultNullPrecedence(NullPrecedence nullPrecedence) {
        this.defaultNullPrecedence = nullPrecedence;
    }

    public void enableOrderingOfInserts(boolean enabled) {
        this.orderInsertsEnabled = enabled;
    }

    public void enableOrderingOfUpdates(boolean enabled) {
        this.orderUpdatesEnabled = enabled;
    }

    public void enableDelayedIdentityInserts(boolean enabled) {
        this.postInsertIdentifierDelayed = enabled;
    }

    public void applyMultiTenancy(boolean enabled) {
        this.multiTenancyEnabled = enabled;
    }

    public void applyCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver resolver) {
        this.currentTenantIdentifierResolver = resolver;
    }

    public void enableNamedQueryCheckingOnStartup(boolean enabled) {
        this.namedQueryStartupCheckingEnabled = enabled;
    }

    public void enableSecondLevelCacheSupport(boolean enabled) {
        this.secondLevelCacheEnabled = enabled;
    }

    public void enableQueryCacheSupport(boolean enabled) {
        this.queryCacheEnabled = enabled;
    }

    public void applyTimestampsCacheFactory(TimestampsCacheFactory factory) {
        this.timestampsCacheFactory = factory;
    }

    public void applyCacheRegionPrefix(String prefix) {
        this.cacheRegionPrefix = prefix;
    }

    public void enableMinimalPuts(boolean enabled) {
        this.minimalPutsEnabled = enabled;
    }

    public void enabledStructuredCacheEntries(boolean enabled) {
        this.structuredCacheEntriesEnabled = enabled;
    }

    public void allowDirectReferenceCacheEntries(boolean enabled) {
        this.directReferenceCacheEntriesEnabled = enabled;
    }

    public void enableAutoEvictCollectionCaches(boolean enabled) {
        this.autoEvictCollectionCache = enabled;
    }

    public void applyJdbcBatchSize(int size) {
        this.jdbcBatchSize = size;
    }

    public void enableJdbcBatchingForVersionedEntities(boolean enabled) {
        this.jdbcBatchVersionedData = enabled;
    }

    public void enableScrollableResultSupport(boolean enabled) {
        this.scrollableResultSetsEnabled = enabled;
    }

    public void enableGeneratedKeysSupport(boolean enabled) {
        this.getGeneratedKeysEnabled = enabled;
    }

    public void applyJdbcFetchSize(int size) {
        this.jdbcFetchSize = size;
    }

    public void applyConnectionHandlingMode(PhysicalConnectionHandlingMode mode) {
        this.connectionHandlingMode = mode;
    }

    public void applyConnectionProviderDisablesAutoCommit(boolean providerDisablesAutoCommit) {
        this.connectionProviderDisablesAutoCommit = providerDisablesAutoCommit;
    }

    public void enableCommentsSupport(boolean enabled) {
        this.commentsEnabled = enabled;
    }

    public void applySqlFunction(String registrationName, SqmFunctionDescriptor sqlFunction) {
        if (this.sqlFunctions == null) {
            this.sqlFunctions = new HashMap<String, SqmFunctionDescriptor>();
        }
        this.sqlFunctions.put(registrationName, sqlFunction);
    }

    public void allowOutOfTransactionUpdateOperations(boolean allow) {
        this.allowOutOfTransactionUpdateOperations = allow;
    }

    public void enableReleaseResourcesOnClose(boolean enable) {
        this.releaseResourcesOnCloseEnabled = enable;
    }

    public void enableJpaQueryCompliance(boolean enabled) {
        this.mutableJpaCompliance().setQueryCompliance(enabled);
    }

    private MutableJpaCompliance mutableJpaCompliance() {
        if (!(this.jpaCompliance instanceof MutableJpaCompliance)) {
            throw new IllegalStateException("JpaCompliance is no longer mutable");
        }
        return (MutableJpaCompliance)this.jpaCompliance;
    }

    public void enableJpaTransactionCompliance(boolean enabled) {
        this.mutableJpaCompliance().setTransactionCompliance(enabled);
    }

    public void enableJpaListCompliance(boolean enabled) {
        this.mutableJpaCompliance().setListCompliance(enabled);
    }

    public void enableJpaClosedCompliance(boolean enabled) {
        this.mutableJpaCompliance().setClosedCompliance(enabled);
    }

    public void enableJpaProxyCompliance(boolean enabled) {
        this.mutableJpaCompliance().setProxyCompliance(enabled);
    }

    public void enableJpaCachingCompliance(boolean enabled) {
        this.mutableJpaCompliance().setCachingCompliance(enabled);
    }

    public void enableJpaOrderByMappingCompliance(boolean enabled) {
        this.mutableJpaCompliance().setOrderByMappingCompliance(enabled);
    }

    public void enableGeneratorNameScopeCompliance(boolean enabled) {
        this.mutableJpaCompliance().setGeneratorNameScopeCompliance(enabled);
    }

    public void enableCollectionInDefaultFetchGroup(boolean enabled) {
        this.collectionsInDefaultFetchGroupEnabled = enabled;
    }

    public void disableRefreshDetachedEntity() {
        this.allowRefreshDetachedEntity = false;
    }

    public void disableJtaTransactionAccess() {
        this.jtaTransactionAccessEnabled = false;
    }

    public SessionFactoryOptions buildOptions() {
        if (this.jpaCompliance instanceof MutableJpaCompliance) {
            this.jpaCompliance = this.mutableJpaCompliance().immutableCopy();
        }
        return this;
    }
}

