/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl.toJavaPortable;

import com.sun.tools.corba.ee.idl.EnumEntry;
import com.sun.tools.corba.ee.idl.InterfaceEntry;
import com.sun.tools.corba.ee.idl.StringEntry;
import com.sun.tools.corba.ee.idl.StructEntry;
import com.sun.tools.corba.ee.idl.SymtabEntry;
import com.sun.tools.corba.ee.idl.TypedefEntry;
import com.sun.tools.corba.ee.idl.UnionEntry;
import com.sun.tools.corba.ee.idl.toJavaPortable.Util;
import java.util.Enumeration;
import java.util.Hashtable;

public class TCOffsets {
    private Hashtable tcs = new Hashtable();
    private int offset = 0;

    public int offset(String name) {
        Integer value = (Integer)this.tcs.get(name);
        return value == null ? -1 : value;
    }

    public void set(SymtabEntry entry) {
        if (entry == null) {
            this.offset += 8;
        } else {
            this.tcs.put(entry.fullName(), this.offset);
            this.offset += 4;
            String repID = Util.stripLeadingUnderscoresFromID(entry.repositoryID().ID());
            if (entry instanceof InterfaceEntry) {
                this.offset += this.alignStrLen(repID) + this.alignStrLen(entry.name());
            } else if (entry instanceof StructEntry) {
                this.offset += this.alignStrLen(repID) + this.alignStrLen(entry.name()) + 4;
            } else if (entry instanceof UnionEntry) {
                this.offset += this.alignStrLen(repID) + this.alignStrLen(entry.name()) + 12;
            } else if (entry instanceof EnumEntry) {
                this.offset += this.alignStrLen(repID) + this.alignStrLen(entry.name()) + 4;
                Enumeration e = ((EnumEntry)entry).elements().elements();
                while (e.hasMoreElements()) {
                    this.offset += this.alignStrLen((String)e.nextElement());
                }
            } else if (entry instanceof StringEntry) {
                this.offset += 4;
            } else if (entry instanceof TypedefEntry) {
                this.offset += this.alignStrLen(repID) + this.alignStrLen(entry.name());
                if (((TypedefEntry)entry).arrayInfo().size() != 0) {
                    this.offset += 8;
                }
            }
        }
    }

    public int alignStrLen(String string) {
        int len = string.length() + 1;
        int align = 4 - len % 4;
        if (align == 4) {
            align = 0;
        }
        return len + align + 4;
    }

    public void setMember(SymtabEntry entry) {
        this.offset += this.alignStrLen(entry.name());
        if (((TypedefEntry)entry).arrayInfo().size() != 0) {
            this.offset += 4;
        }
    }

    public int currentOffset() {
        return this.offset;
    }

    public void bumpCurrentOffset(int value) {
        this.offset += value;
    }
}

