/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl.toJavaPortable;

import com.sun.tools.corba.ee.idl.AttributeEntry;
import com.sun.tools.corba.ee.idl.GenFileStream;
import com.sun.tools.corba.ee.idl.InterfaceEntry;
import com.sun.tools.corba.ee.idl.MethodEntry;
import com.sun.tools.corba.ee.idl.SymtabEntry;
import com.sun.tools.corba.ee.idl.ValueEntry;
import com.sun.tools.corba.ee.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.ee.idl.toJavaPortable.AuxGen;
import com.sun.tools.corba.ee.idl.toJavaPortable.Compile;
import com.sun.tools.corba.ee.idl.toJavaPortable.MethodGen;
import com.sun.tools.corba.ee.idl.toJavaPortable.NameModifier;
import com.sun.tools.corba.ee.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Skeleton
implements AuxGen {
    private NameModifier skeletonNameModifier;
    private NameModifier tieNameModifier;
    protected Hashtable symbolTable = null;
    protected InterfaceEntry i = null;
    protected PrintWriter stream = null;
    protected String tieClassName = null;
    protected String skeletonClassName = null;
    protected boolean tie = false;
    protected boolean poa = false;
    protected Vector methodList = null;
    protected String intfName = "";

    @Override
    public void generate(Hashtable symbolTable, SymtabEntry entry) {
        ValueEntry v;
        if (entry instanceof ValueEntry && ((v = (ValueEntry)entry).supports().size() == 0 || ((InterfaceEntry)v.supports().elementAt(0)).isAbstract())) {
            return;
        }
        if (((InterfaceEntry)entry).isAbstract()) {
            return;
        }
        this.symbolTable = symbolTable;
        this.i = (InterfaceEntry)entry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.tie = ((Arguments)Compile.compiler.arguments).TIEServer;
        this.poa = ((Arguments)Compile.compiler.arguments).POAServer;
        this.skeletonNameModifier = ((Arguments)Compile.compiler.arguments).skeletonNameModifier;
        this.tieNameModifier = ((Arguments)Compile.compiler.arguments).tieNameModifier;
        this.tieClassName = this.tieNameModifier.makeName(this.i.name());
        this.skeletonClassName = this.skeletonNameModifier.makeName(this.i.name());
        this.intfName = Util.javaName(this.i);
        if (this.i instanceof ValueEntry) {
            ValueEntry v = (ValueEntry)this.i;
            InterfaceEntry intf = (InterfaceEntry)v.supports().elementAt(0);
            this.intfName = Util.javaName(intf);
        }
    }

    protected void openStream() {
        this.stream = this.tie ? Util.stream(this.i, this.tieNameModifier, ".java") : Util.stream(this.i, this.skeletonNameModifier, ".java");
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.i, (short)1);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.i.comment() != null) {
            this.i.comment().generate("", this.stream);
        }
        this.writeClassDeclaration();
        this.stream.println('{');
        this.stream.println();
    }

    protected void writeClassDeclaration() {
        if (this.tie) {
            this.stream.println("public class " + this.tieClassName + " extends " + this.skeletonClassName);
        } else if (this.poa) {
            this.stream.println("public abstract class " + this.skeletonClassName + " extends org.omg.PortableServer.Servant");
            this.stream.print(" implements " + this.intfName + "Operations, ");
            this.stream.println("org.omg.CORBA.portable.InvokeHandler");
        } else {
            this.stream.println("public abstract class " + this.skeletonClassName + " extends org.omg.CORBA.portable.ObjectImpl");
            this.stream.print("                implements " + this.intfName + ", ");
            this.stream.println("org.omg.CORBA.portable.InvokeHandler");
        }
    }

    protected void writeBody() {
        this.writeCtors();
        if (this.i instanceof ValueEntry) {
            ValueEntry v = (ValueEntry)this.i;
            this.i = (InterfaceEntry)v.supports().elementAt(0);
        }
        this.buildMethodList();
        if (this.tie) {
            if (this.poa) {
                this.writeMethods();
                this.stream.println("  private " + this.intfName + "Operations _impl;");
                this.stream.println("  private org.omg.PortableServer.POA _poa;");
            } else {
                this.writeMethods();
                this.stream.println("  private " + this.intfName + "Operations _impl;");
            }
        } else if (this.poa) {
            this.writeMethodTable();
            this.writeDispatchMethod();
            this.writeCORBAOperations();
        } else {
            this.writeMethodTable();
            this.writeDispatchMethod();
            this.writeCORBAOperations();
        }
        this.writeOperations();
    }

    protected void writeClosing() {
        this.stream.println();
        if (this.tie) {
            this.stream.println("} // class " + this.tieClassName);
        } else {
            this.stream.println("} // class " + this.skeletonClassName);
        }
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeCtors() {
        this.stream.println("  // Constructors");
        if (!this.poa) {
            if (this.tie) {
                this.stream.println("  public " + this.tieClassName + " ()");
                this.stream.println("  {");
                this.stream.println("  }");
            } else {
                this.stream.println("  public " + this.skeletonClassName + " ()");
                this.stream.println("  {");
                this.stream.println("  }");
            }
        }
        this.stream.println();
        if (this.tie) {
            if (this.poa) {
                this.writePOATieCtors();
                this.writePOATieFieldAccessMethods();
            } else {
                this.stream.println("  public " + this.tieClassName + " (" + this.intfName + "Operations impl)");
                this.stream.println("  {");
                if (((InterfaceEntry)this.i.derivedFrom().firstElement()).state() != null) {
                    this.stream.println("    super (impl);");
                } else {
                    this.stream.println("    super ();");
                }
                this.stream.println("    _impl = impl;");
                this.stream.println("  }");
                this.stream.println();
            }
        } else if (this.poa) {
            // empty if block
        }
    }

    private void writePOATieCtors() {
        this.stream.println("  public " + this.tieClassName + " ( " + this.intfName + "Operations delegate ) {");
        this.stream.println("      this._impl = delegate;");
        this.stream.println("  }");
        this.stream.println("  public " + this.tieClassName + " ( " + this.intfName + "Operations delegate , org.omg.PortableServer.POA poa ) {");
        this.stream.println("      this._impl = delegate;");
        this.stream.println("      this._poa      = poa;");
        this.stream.println("  }");
    }

    private void writePOATieFieldAccessMethods() {
        this.stream.println("  public " + this.intfName + "Operations _delegate() {");
        this.stream.println("      return this._impl;");
        this.stream.println("  }");
        this.stream.println("  public void _delegate (" + this.intfName + "Operations delegate ) {");
        this.stream.println("      this._impl = delegate;");
        this.stream.println("  }");
        this.stream.println("  public org.omg.PortableServer.POA _default_POA() {");
        this.stream.println("      if(_poa != null) {");
        this.stream.println("          return _poa;");
        this.stream.println("      }");
        this.stream.println("      else {");
        this.stream.println("          return super._default_POA();");
        this.stream.println("      }");
        this.stream.println("  }");
    }

    protected void buildMethodList() {
        this.methodList = new Vector();
        this.buildMethodList(this.i);
    }

    private void buildMethodList(InterfaceEntry entry) {
        Enumeration locals = entry.methods().elements();
        while (locals.hasMoreElements()) {
            this.addMethod((MethodEntry)locals.nextElement());
        }
        Enumeration parents = entry.derivedFrom().elements();
        while (parents.hasMoreElements()) {
            InterfaceEntry parent = (InterfaceEntry)parents.nextElement();
            if (parent.name().equals("Object")) continue;
            this.buildMethodList(parent);
        }
    }

    private void addMethod(MethodEntry method) {
        if (!this.methodList.contains(method)) {
            this.methodList.addElement(method);
        }
    }

    protected void writeDispatchMethod() {
        String indent = "                                ";
        this.stream.println("  public org.omg.CORBA.portable.OutputStream _invoke (String $method,");
        this.stream.println(indent + "org.omg.CORBA.portable.InputStream in,");
        this.stream.println(indent + "org.omg.CORBA.portable.ResponseHandler $rh)");
        this.stream.println("  {");
        boolean isLocalInterface = false;
        if (this.i instanceof InterfaceEntry) {
            isLocalInterface = this.i.isLocalServant();
        }
        if (!isLocalInterface) {
            this.stream.println("    org.omg.CORBA.portable.OutputStream out = null;");
            this.stream.println("    java.lang.Integer __method = _methods.get($method);");
            this.stream.println("    if (__method == null)");
            this.stream.println("      throw new org.omg.CORBA.BAD_OPERATION (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
            this.stream.println();
            if (this.methodList.size() > 0) {
                this.stream.println("    switch (__method.intValue ())");
                this.stream.println("    {");
                int realI = 0;
                for (int i = 0; i < this.methodList.size(); ++i) {
                    MethodEntry method = (MethodEntry)this.methodList.elementAt(i);
                    ((MethodGen)method.generator()).dispatchSkeleton(this.symbolTable, method, this.stream, realI);
                    if (method instanceof AttributeEntry && !((AttributeEntry)method).readOnly()) {
                        realI += 2;
                        continue;
                    }
                    ++realI;
                }
                indent = "       ";
                this.stream.println(indent + "default:");
                this.stream.println(indent + "  throw new org.omg.CORBA.BAD_OPERATION (0, org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);");
                this.stream.println("    }");
                this.stream.println();
            }
            this.stream.println("    return out;");
        } else {
            this.stream.println("    throw new org.omg.CORBA.BAD_OPERATION();");
        }
        this.stream.println("  } // _invoke");
        this.stream.println();
    }

    protected void writeMethodTable() {
        this.stream.println("  private static java.util.Map<String,Integer> _methods = new java.util.HashMap<String,Integer> ();");
        this.stream.println("  static");
        this.stream.println("  {");
        int count = -1;
        Enumeration e = this.methodList.elements();
        while (e.hasMoreElements()) {
            MethodEntry method = (MethodEntry)e.nextElement();
            if (method instanceof AttributeEntry) {
                this.stream.println("    _methods.put (\"_get_" + Util.stripLeadingUnderscores(method.name()) + "\", " + ++count + ");");
                if (((AttributeEntry)method).readOnly()) continue;
                this.stream.println("    _methods.put (\"_set_" + Util.stripLeadingUnderscores(method.name()) + "\", " + ++count + ");");
                continue;
            }
            this.stream.println("    _methods.put (\"" + Util.stripLeadingUnderscores(method.name()) + "\", " + ++count + ");");
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeMethods() {
        int realI = 0;
        for (int i = 0; i < this.methodList.size(); ++i) {
            MethodEntry method = (MethodEntry)this.methodList.elementAt(i);
            ((MethodGen)method.generator()).skeleton(this.symbolTable, method, this.stream, realI);
            realI = method instanceof AttributeEntry && !((AttributeEntry)method).readOnly() ? (realI += 2) : ++realI;
            this.stream.println();
        }
    }

    private void writeIDs() {
        Vector list = new Vector();
        this.buildIDList(this.i, list);
        Enumeration e = list.elements();
        boolean first = true;
        while (e.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                this.stream.println(", ");
            }
            this.stream.print("    \"" + (String)e.nextElement() + '\"');
        }
    }

    private void buildIDList(InterfaceEntry entry, Vector list) {
        if (!entry.fullName().equals("org/omg/CORBA/Object")) {
            String id = Util.stripLeadingUnderscoresFromID(entry.repositoryID().ID());
            if (!list.contains(id)) {
                list.addElement(id);
            }
            Enumeration e = entry.derivedFrom().elements();
            while (e.hasMoreElements()) {
                this.buildIDList((InterfaceEntry)e.nextElement(), list);
            }
        }
    }

    protected void writeCORBAOperations() {
        this.stream.println("  // Type-specific CORBA::Object operations");
        this.stream.println("  private static String[] __ids = {");
        this.writeIDs();
        this.stream.println("};");
        this.stream.println();
        if (this.poa) {
            this.writePOACORBAOperations();
        } else {
            this.writeNonPOACORBAOperations();
        }
    }

    protected void writePOACORBAOperations() {
        this.stream.println("  public String[] _all_interfaces (org.omg.PortableServer.POA poa, byte[] objectId)");
        this.stream.println("  {");
        this.stream.println("    return (String[])__ids.clone ();");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public " + this.i.name() + " _this() ");
        this.stream.println("  {");
        this.stream.println("    return " + this.i.name() + "Helper.narrow(");
        this.stream.println("    super._this_object());");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public " + this.i.name() + " _this(org.omg.CORBA.ORB orb) ");
        this.stream.println("  {");
        this.stream.println("    return " + this.i.name() + "Helper.narrow(");
        this.stream.println("    super._this_object(orb));");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeNonPOACORBAOperations() {
        this.stream.println("  public String[] _ids ()");
        this.stream.println("  {");
        this.stream.println("    return (String[])__ids.clone ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeOperations() {
    }
}

