/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl.toJavaPortable;

import com.sun.tools.corba.ee.idl.AttributeEntry;
import com.sun.tools.corba.ee.idl.ExceptionEntry;
import com.sun.tools.corba.ee.idl.InterfaceEntry;
import com.sun.tools.corba.ee.idl.InterfaceState;
import com.sun.tools.corba.ee.idl.MethodEntry;
import com.sun.tools.corba.ee.idl.ParameterEntry;
import com.sun.tools.corba.ee.idl.PrimitiveEntry;
import com.sun.tools.corba.ee.idl.SequenceEntry;
import com.sun.tools.corba.ee.idl.StringEntry;
import com.sun.tools.corba.ee.idl.SymtabEntry;
import com.sun.tools.corba.ee.idl.TypedefEntry;
import com.sun.tools.corba.ee.idl.ValueBoxEntry;
import com.sun.tools.corba.ee.idl.ValueEntry;
import com.sun.tools.corba.ee.idl.constExpr.Expression;
import com.sun.tools.corba.ee.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.ee.idl.toJavaPortable.Compile;
import com.sun.tools.corba.ee.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class MethodGen
implements com.sun.tools.corba.ee.idl.MethodGen {
    private static final String ONE_INDENT = "    ";
    private static final String TWO_INDENT = "        ";
    private static final String THREE_INDENT = "            ";
    private static final String FOUR_INDENT = "                ";
    private static final String FIVE_INDENT = "                    ";
    private static final int ATTRIBUTE_METHOD_PREFIX_LENGTH = 5;
    protected int methodIndex = 0;
    protected String realName = "";
    protected Hashtable symbolTable = null;
    protected MethodEntry m = null;
    protected PrintWriter stream = null;
    protected boolean localOptimization = false;
    protected boolean isAbstract = false;

    @Override
    public void generate(Hashtable symbolTable, MethodEntry m, PrintWriter stream) {
    }

    protected void interfaceMethod(Hashtable symbolTable, MethodEntry m, PrintWriter stream) {
        this.symbolTable = symbolTable;
        this.m = m;
        this.stream = stream;
        if (m.comment() != null) {
            m.comment().generate("", stream);
        }
        stream.print("  ");
        SymtabEntry container = m.container();
        boolean isAbstract = false;
        boolean valueContainer = false;
        if (container instanceof ValueEntry) {
            isAbstract = ((ValueEntry)container).isAbstract();
            valueContainer = true;
        }
        if (valueContainer && !isAbstract) {
            stream.print("public ");
        }
        this.writeMethodSignature();
        if (valueContainer && !isAbstract) {
            stream.println();
            stream.println("  {");
            stream.println("  }");
            stream.println();
        } else {
            stream.println(";");
        }
    }

    protected void stub(String className, boolean isAbstract, Hashtable symbolTable, MethodEntry m, PrintWriter stream, int index) {
        this.localOptimization = ((Arguments)Compile.compiler.arguments).LocalOptimization;
        this.isAbstract = isAbstract;
        this.symbolTable = symbolTable;
        this.m = m;
        this.stream = stream;
        this.methodIndex = index;
        if (m.comment() != null) {
            m.comment().generate("  ", stream);
        }
        stream.print("  public ");
        this.writeMethodSignature();
        stream.println();
        stream.println("  {");
        this.writeStubBody(className);
        stream.println("  } // " + m.name());
        stream.println();
    }

    protected void localstub(Hashtable symbolTable, MethodEntry m, PrintWriter stream, int index, InterfaceEntry i) {
        this.symbolTable = symbolTable;
        this.m = m;
        this.stream = stream;
        this.methodIndex = index;
        if (m.comment() != null) {
            m.comment().generate("  ", stream);
        }
        stream.print("  public ");
        this.writeMethodSignature();
        stream.println();
        stream.println("  {");
        this.writeLocalStubBody(i);
        stream.println("  } // " + m.name());
        stream.println();
    }

    protected void skeleton(Hashtable symbolTable, MethodEntry m, PrintWriter stream, int index) {
        this.symbolTable = symbolTable;
        this.m = m;
        this.stream = stream;
        this.methodIndex = index;
        if (m.comment() != null) {
            m.comment().generate("  ", stream);
        }
        stream.print("  public ");
        this.writeMethodSignature();
        stream.println();
        stream.println("  {");
        this.writeSkeletonBody();
        stream.println("  } // " + m.name());
    }

    protected void dispatchSkeleton(Hashtable symbolTable, MethodEntry m, PrintWriter stream, int index) {
        this.symbolTable = symbolTable;
        this.m = m;
        this.stream = stream;
        this.methodIndex = index;
        if (m.comment() != null) {
            m.comment().generate("  ", stream);
        }
        this.writeDispatchCall();
    }

    protected boolean isValueInitializer() {
        MethodEntry currentInit = null;
        if (this.m.container() instanceof ValueEntry) {
            Enumeration e = ((ValueEntry)this.m.container()).initializers().elements();
            while (currentInit != this.m && e.hasMoreElements()) {
                currentInit = (MethodEntry)e.nextElement();
            }
        }
        return currentInit == this.m && null != this.m;
    }

    protected void writeMethodSignature() {
        boolean isValueInitializer = this.isValueInitializer();
        if (this.m.type() == null) {
            if (!isValueInitializer) {
                this.stream.print("void");
            }
        } else {
            this.stream.print(Util.javaName(this.m.type()));
        }
        if (isValueInitializer) {
            this.stream.print(' ' + this.m.container().name() + " (");
        } else {
            this.stream.print(' ' + this.m.name() + " (");
        }
        boolean firstTime = true;
        Enumeration e = this.m.parameters().elements();
        while (e.hasMoreElements()) {
            if (firstTime) {
                firstTime = false;
            } else {
                this.stream.print(", ");
            }
            ParameterEntry parm = (ParameterEntry)e.nextElement();
            this.writeParmType(parm.type(), parm.passType());
            this.stream.print(' ' + parm.name());
        }
        if (this.m.contexts().size() > 0) {
            if (!firstTime) {
                this.stream.print(", ");
            }
            this.stream.print("org.omg.CORBA.Context $context");
        }
        if (this.m.exceptions().size() > 0) {
            this.stream.print(") throws ");
            e = this.m.exceptions().elements();
            firstTime = true;
            while (e.hasMoreElements()) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    this.stream.print(", ");
                }
                this.stream.print(Util.javaName((SymtabEntry)e.nextElement()));
            }
        } else {
            this.stream.print(')');
        }
    }

    protected void writeParmType(SymtabEntry parm, int passType) {
        if (passType != 0) {
            parm = Util.typeOf(parm);
            this.stream.print(Util.holderName(parm));
        } else {
            this.stream.print(Util.javaName(parm));
        }
    }

    protected void writeDispatchCall() {
        ParameterEntry parm;
        String indent = "       ";
        String fullMethodName = this.m.fullName();
        if (this.m instanceof AttributeEntry) {
            int index = fullMethodName.lastIndexOf(47) + 1;
            fullMethodName = this.m.type() == null ? fullMethodName.substring(0, index) + "_set_" + this.m.name() : fullMethodName.substring(0, index) + "_get_" + this.m.name();
        }
        this.stream.println(indent + "case " + this.methodIndex + ":  // " + fullMethodName);
        this.stream.println(indent + "{");
        indent = indent + "  ";
        if (this.m.exceptions().size() > 0) {
            this.stream.println(indent + "try {");
            indent = indent + "  ";
        }
        SymtabEntry mtype = Util.typeOf(this.m.type());
        Enumeration parms = this.m.parameters().elements();
        parms = this.m.parameters().elements();
        while (parms.hasMoreElements()) {
            ParameterEntry parm2 = (ParameterEntry)parms.nextElement();
            String name = parm2.name();
            String anyName = '_' + name;
            SymtabEntry type = parm2.type();
            int passType = parm2.passType();
            if (passType == 0) {
                Util.writeInitializer(indent, name, "", type, this.writeInputStreamRead("in", type), this.stream);
                continue;
            }
            String holderName = Util.holderName(type);
            this.stream.println(indent + holderName + ' ' + name + " = new " + holderName + " ();");
            if (passType != 1) continue;
            if (type instanceof ValueBoxEntry) {
                ValueBoxEntry v = (ValueBoxEntry)type;
                TypedefEntry member = ((InterfaceState)v.state().elementAt((int)0)).entry;
                SymtabEntry mType = member.type();
                if (mType instanceof PrimitiveEntry) {
                    this.stream.println(indent + name + ".value = (" + this.writeInputStreamRead("in", parm2.type()) + ").value;");
                    continue;
                }
                this.stream.println(indent + name + ".value = " + this.writeInputStreamRead("in", parm2.type()) + ";");
                continue;
            }
            this.stream.println(indent + name + ".value = " + this.writeInputStreamRead("in", parm2.type()) + ";");
        }
        if (this.m.contexts().size() > 0) {
            this.stream.println(indent + "org.omg.CORBA.Context $context = in.read_Context ();");
        }
        if (mtype != null) {
            Util.writeInitializer(indent, "$result", "", mtype, this.stream);
        }
        this.writeMethodCall(indent);
        parms = this.m.parameters().elements();
        boolean firstTime = true;
        while (parms.hasMoreElements()) {
            parm = (ParameterEntry)parms.nextElement();
            if (firstTime) {
                firstTime = false;
            } else {
                this.stream.print(", ");
            }
            this.stream.print(parm.name());
        }
        if (this.m.contexts().size() > 0) {
            if (!firstTime) {
                this.stream.print(", ");
            }
            this.stream.print("$context");
        }
        this.stream.println(");");
        this.writeCreateReply(indent);
        if (mtype != null) {
            this.writeOutputStreamWrite(indent, "out", "$result", mtype, this.stream);
        }
        parms = this.m.parameters().elements();
        while (parms.hasMoreElements()) {
            parm = (ParameterEntry)parms.nextElement();
            int passType = parm.passType();
            if (passType == 0) continue;
            this.writeOutputStreamWrite(indent, "out", parm.name() + ".value", parm.type(), this.stream);
        }
        if (this.m.exceptions().size() > 0) {
            Enumeration exceptions = this.m.exceptions().elements();
            while (exceptions.hasMoreElements()) {
                indent = "         ";
                ExceptionEntry exc = (ExceptionEntry)exceptions.nextElement();
                String fullName = Util.javaQualifiedName(exc);
                this.stream.println(indent + "} catch (" + fullName + " $ex) {");
                indent = indent + "  ";
                this.stream.println(indent + "out = $rh.createExceptionReply ();");
                this.stream.println(indent + Util.helperName(exc, true) + ".write (out, $ex);");
            }
            indent = "         ";
            this.stream.println(indent + "}");
        }
        this.stream.println("         break;");
        this.stream.println("       }");
        this.stream.println();
    }

    protected void writeStubBody(String className) {
        StringEntry string;
        ParameterEntry parm;
        ParameterEntry parm2;
        String methodName = Util.stripLeadingUnderscores(this.m.name());
        if (this.m instanceof AttributeEntry) {
            methodName = this.m.type() == null ? "_set_" + methodName : "_get_" + methodName;
        }
        if (this.localOptimization && !this.isAbstract) {
            this.stream.println("    while(true) {");
            this.stream.println("        if(!this._is_local()) {");
        }
        this.stream.println("            org.omg.CORBA.portable.InputStream $in = null;");
        this.stream.println("            try {");
        this.stream.println("                org.omg.CORBA.portable.OutputStream $out = _request (\"" + methodName + "\", " + !this.m.oneway() + ");");
        Enumeration parms = this.m.parameters().elements();
        while (parms.hasMoreElements()) {
            StringEntry string2;
            parm2 = (ParameterEntry)parms.nextElement();
            SymtabEntry parmType = Util.typeOf(parm2.type());
            if (!(parmType instanceof StringEntry) || parm2.passType() != 0 && parm2.passType() != 1 || (string2 = (StringEntry)parmType).maxSize() == null) continue;
            this.stream.print("            if (" + parm2.name());
            if (parm2.passType() == 1) {
                this.stream.print(".value");
            }
            this.stream.print(" == null || " + parm2.name());
            if (parm2.passType() == 1) {
                this.stream.print(".value");
            }
            this.stream.println(".length () > (" + Util.parseExpression(string2.maxSize()) + "))");
            this.stream.println("            throw new org.omg.CORBA.BAD_PARAM (0, org.omg.CORBA.CompletionStatus.COMPLETED_NO);");
        }
        parms = this.m.parameters().elements();
        while (parms.hasMoreElements()) {
            parm2 = (ParameterEntry)parms.nextElement();
            if (parm2.passType() == 0) {
                this.writeOutputStreamWrite(FOUR_INDENT, "$out", parm2.name(), parm2.type(), this.stream);
                continue;
            }
            if (parm2.passType() != 1) continue;
            this.writeOutputStreamWrite(FOUR_INDENT, "$out", parm2.name() + ".value", parm2.type(), this.stream);
        }
        if (this.m.contexts().size() > 0) {
            this.stream.println("                org.omg.CORBA.ContextList $contextList =_orb ().create_context_list ();");
            for (int cnt = 0; cnt < this.m.contexts().size(); ++cnt) {
                this.stream.println("                $contextList.add (\"" + this.m.contexts().elementAt(cnt) + "\");");
            }
            this.stream.println("                $out.write_Context ($context, $contextList);");
        }
        this.stream.println("                $in = _invoke ($out);");
        SymtabEntry mtype = this.m.type();
        if (mtype != null) {
            Util.writeInitializer(FOUR_INDENT, "$result", "", mtype, this.writeInputStreamRead("$in", mtype), this.stream);
        }
        parms = this.m.parameters().elements();
        while (parms.hasMoreElements()) {
            parm = (ParameterEntry)parms.nextElement();
            if (parm.passType() == 0) continue;
            if (parm.type() instanceof ValueBoxEntry) {
                ValueBoxEntry v = (ValueBoxEntry)parm.type();
                TypedefEntry member = ((InterfaceState)v.state().elementAt((int)0)).entry;
                SymtabEntry mType = member.type();
                if (mType instanceof PrimitiveEntry) {
                    this.stream.println(FOUR_INDENT + parm.name() + ".value = (" + this.writeInputStreamRead("$in", parm.type()) + ").value;");
                    continue;
                }
                this.stream.println(FOUR_INDENT + parm.name() + ".value = " + this.writeInputStreamRead("$in", parm.type()) + ";");
                continue;
            }
            this.stream.println(FOUR_INDENT + parm.name() + ".value = " + this.writeInputStreamRead("$in", parm.type()) + ";");
        }
        parms = this.m.parameters().elements();
        while (parms.hasMoreElements()) {
            StringEntry string3;
            parm = (ParameterEntry)parms.nextElement();
            SymtabEntry parmType = Util.typeOf(parm.type());
            if (!(parmType instanceof StringEntry) || parm.passType() != 2 && parm.passType() != 1 || (string3 = (StringEntry)parmType).maxSize() == null) continue;
            this.stream.print("                if (" + parm.name() + ".value.length ()");
            this.stream.println("         > (" + Util.parseExpression(string3.maxSize()) + "))");
            this.stream.println("                    throw new org.omg.CORBA.MARSHAL(0,org.omg.CORBA.CompletionStatus.COMPLETED_NO);");
        }
        if (mtype instanceof StringEntry && (string = (StringEntry)mtype).maxSize() != null) {
            this.stream.println("                if ($result.length () > (" + Util.parseExpression(string.maxSize()) + "))");
            this.stream.println("                    throw new org.omg.CORBA.MARSHAL (0, org.omg.CORBA.CompletionStatus.COMPLETED_NO);");
        }
        if (mtype != null) {
            this.stream.println("                return $result;");
        } else {
            this.stream.println("                return;");
        }
        this.stream.println("            } catch (org.omg.CORBA.portable.ApplicationException $ex) {");
        this.stream.println("                $in = $ex.getInputStream ();");
        this.stream.println("                String _id = $ex.getId ();");
        if (this.m.exceptions().size() > 0) {
            Enumeration exceptions = this.m.exceptions().elements();
            boolean firstExc = true;
            while (exceptions.hasMoreElements()) {
                ExceptionEntry exc = (ExceptionEntry)exceptions.nextElement();
                if (firstExc) {
                    this.stream.print("                if ");
                    firstExc = false;
                } else {
                    this.stream.print("                else if ");
                }
                this.stream.println("(_id.equals (\"" + exc.repositoryID().ID() + "\"))");
                this.stream.println("                    throw " + Util.helperName(exc, false) + ".read ($in);");
            }
            this.stream.println("                else");
            this.stream.println("                    throw new org.omg.CORBA.MARSHAL (_id);");
        } else {
            this.stream.println("                throw new org.omg.CORBA.MARSHAL (_id);");
        }
        this.stream.println("            } catch (org.omg.CORBA.portable.RemarshalException $rm) {");
        this.stream.print(FOUR_INDENT);
        if (this.m.type() != null) {
            this.stream.print("return ");
        }
        this.stream.print(this.m.name() + " (");
        boolean firstTime = true;
        Enumeration e = this.m.parameters().elements();
        while (e.hasMoreElements()) {
            if (firstTime) {
                firstTime = false;
            } else {
                this.stream.print(", ");
            }
            ParameterEntry parm3 = (ParameterEntry)e.nextElement();
            this.stream.print(parm3.name());
        }
        if (this.m.contexts().size() > 0) {
            if (!firstTime) {
                this.stream.print(", ");
            }
            this.stream.print("$context");
        }
        this.stream.println("        );");
        this.stream.println("            } finally {");
        this.stream.println("                _releaseReply ($in);");
        this.stream.println("            }");
        if (this.localOptimization && !this.isAbstract) {
            this.stream.println("        }");
            this.writeStubBodyForLocalInvocation(className, methodName);
        }
    }

    private void writeStubBodyForLocalInvocation(String className, String methodName) {
        boolean voidReturnType;
        this.stream.println("        else {");
        this.stream.println("            org.omg.CORBA.portable.ServantObject _so =");
        this.stream.println("                _servant_preinvoke(\"" + methodName + "\", _opsClass);");
        this.stream.println("            if (_so == null ) {");
        this.stream.println("                continue;");
        this.stream.println("            }");
        this.stream.println(THREE_INDENT + className + "Operations _self =");
        this.stream.println("                (" + className + "Operations) _so.servant;");
        this.stream.println("            try {");
        Enumeration parms = this.m.parameters().elements();
        if (this.m instanceof AttributeEntry) {
            methodName = methodName.substring(5);
        }
        boolean bl = voidReturnType = this.m.type() == null;
        if (!voidReturnType) {
            this.stream.println(FOUR_INDENT + Util.javaName(this.m.type()) + " $result;");
        }
        if (!this.isValueInitializer()) {
            if (voidReturnType) {
                this.stream.print("                _self." + methodName + "( ");
            } else {
                this.stream.print("                $result = _self." + methodName + "( ");
            }
            while (parms.hasMoreElements()) {
                ParameterEntry param = (ParameterEntry)parms.nextElement();
                if (parms.hasMoreElements()) {
                    this.stream.print(" " + param.name() + ",");
                    continue;
                }
                this.stream.print(" " + param.name());
            }
            this.stream.print(");");
            this.stream.println(" ");
            if (voidReturnType) {
                this.stream.println("                return;");
            } else {
                this.stream.println("                return $result;");
            }
        }
        this.stream.println(" ");
        this.stream.println("            }");
        this.stream.println("            finally {");
        this.stream.println("                _servant_postinvoke(_so);");
        this.stream.println("            }");
        this.stream.println("        }");
        this.stream.println("    }");
    }

    protected void writeLocalStubBody(InterfaceEntry i) {
        String methodName = Util.stripLeadingUnderscores(this.m.name());
        if (this.m instanceof AttributeEntry) {
            methodName = this.m.type() == null ? "_set_" + methodName : "_get_" + methodName;
        }
        this.stream.println("      org.omg.CORBA.portable.ServantObject $so = _servant_preinvoke (\"" + methodName + "\", " + "_opsClass);");
        String opsName = i.name() + "Operations";
        this.stream.println("      " + opsName + "  $self = " + "(" + opsName + ") " + "$so.servant;");
        this.stream.println();
        this.stream.println("      try {");
        this.stream.print("         ");
        if (this.m.type() != null) {
            this.stream.print("return ");
        }
        this.stream.print("$self." + this.m.name() + " (");
        boolean firstTime = true;
        Enumeration e = this.m.parameters().elements();
        while (e.hasMoreElements()) {
            if (firstTime) {
                firstTime = false;
            } else {
                this.stream.print(", ");
            }
            ParameterEntry parm = (ParameterEntry)e.nextElement();
            this.stream.print(parm.name());
        }
        if (this.m.contexts().size() > 0) {
            if (!firstTime) {
                this.stream.print(", ");
            }
            this.stream.print("$context");
        }
        this.stream.println(");");
        this.stream.println("      } finally {");
        this.stream.println("          _servant_postinvoke ($so);");
        this.stream.println("      }");
    }

    private void writeInsert(String indent, String target, String source, SymtabEntry type, PrintWriter stream) {
        String typeName = type.name();
        if (type instanceof PrimitiveEntry) {
            if (typeName.equals("long long")) {
                stream.println(indent + source + ".insert_longlong (" + target + ");");
            } else if (typeName.equals("unsigned short")) {
                stream.println(indent + source + ".insert_ushort (" + target + ");");
            } else if (typeName.equals("unsigned long")) {
                stream.println(indent + source + ".insert_ulong (" + target + ");");
            } else if (typeName.equals("unsigned long long")) {
                stream.println(indent + source + ".insert_ulonglong (" + target + ");");
            } else {
                stream.println(indent + source + ".insert_" + typeName + " (" + target + ");");
            }
        } else if (type instanceof StringEntry) {
            stream.println(indent + source + ".insert_" + typeName + " (" + target + ");");
        } else {
            stream.println(indent + Util.helperName(type, true) + ".insert (" + source + ", " + target + ");");
        }
    }

    private void writeType(String indent, String name, SymtabEntry type, PrintWriter stream) {
        if (type instanceof PrimitiveEntry) {
            if (type.name().equals("long long")) {
                stream.println(indent + name + " (org.omg.CORBA.ORB.init ().get_primitive_tc (org.omg.CORBA.TCKind.tk_longlong));");
            } else if (type.name().equals("unsigned short")) {
                stream.println(indent + name + " (org.omg.CORBA.ORB.init ().get_primitive_tc (org.omg.CORBA.TCKind.tk_ushort));");
            } else if (type.name().equals("unsigned long")) {
                stream.println(indent + name + " (org.omg.CORBA.ORB.init ().get_primitive_tc (org.omg.CORBA.TCKind.tk_ulong));");
            } else if (type.name().equals("unsigned long long")) {
                stream.println(indent + name + " (org.omg.CORBA.ORB.init ().get_primitive_tc (org.omg.CORBA.TCKind.tk_ulonglong));");
            } else {
                stream.println(indent + name + " (org.omg.CORBA.ORB.init ().get_primitive_tc (org.omg.CORBA.TCKind.tk_" + type.name() + "));");
            }
        } else if (type instanceof StringEntry) {
            StringEntry s = (StringEntry)type;
            Expression e = s.maxSize();
            if (e == null) {
                stream.println(indent + name + " (org.omg.CORBA.ORB.init ().create_" + type.name() + "_tc (" + Util.parseExpression(e) + "));");
            } else {
                stream.println(indent + name + " (org.omg.CORBA.ORB.init ().create_" + type.name() + "_tc (0));");
            }
        } else {
            stream.println(indent + name + '(' + Util.helperName(type, true) + ".type ());");
        }
    }

    private void writeExtract(String indent, String target, String source, SymtabEntry type, PrintWriter stream) {
        if (type instanceof PrimitiveEntry) {
            if (type.name().equals("long long")) {
                stream.println(indent + target + " = " + source + ".extract_longlong ();");
            } else if (type.name().equals("unsigned short")) {
                stream.println(indent + target + " = " + source + ".extract_ushort ();");
            } else if (type.name().equals("unsigned long")) {
                stream.println(indent + target + " = " + source + ".extract_ulong ();");
            } else if (type.name().equals("unsigned long long")) {
                stream.println(indent + target + " = " + source + ".extract_ulonglong ();");
            } else {
                stream.println(indent + target + " = " + source + ".extract_" + type.name() + " ();");
            }
        } else if (type instanceof StringEntry) {
            stream.println(indent + target + " = " + source + ".extract_" + type.name() + " ();");
        } else {
            stream.println(indent + target + " = " + Util.helperName(type, true) + ".extract (" + source + ");");
        }
    }

    private String writeExtract(String source, SymtabEntry type) {
        String extract = type instanceof PrimitiveEntry ? (type.name().equals("long long") ? source + ".extract_longlong ()" : (type.name().equals("unsigned short") ? source + ".extract_ushort ()" : (type.name().equals("unsigned long") ? source + ".extract_ulong ()" : (type.name().equals("unsigned long long") ? source + ".extract_ulonglong ()" : source + ".extract_" + type.name() + " ()")))) : (type instanceof StringEntry ? source + ".extract_" + type.name() + " ()" : Util.helperName(type, true) + ".extract (" + source + ')');
        return extract;
    }

    private void writeSkeletonBody() {
        SymtabEntry mtype = Util.typeOf(this.m.type());
        this.stream.print(ONE_INDENT);
        if (mtype != null) {
            this.stream.print("return ");
        }
        this.stream.print("_impl." + this.m.name() + '(');
        Enumeration parms = this.m.parameters().elements();
        boolean first = true;
        while (parms.hasMoreElements()) {
            ParameterEntry parm = (ParameterEntry)parms.nextElement();
            if (first) {
                first = false;
            } else {
                this.stream.print(", ");
            }
            this.stream.print(parm.name());
        }
        if (this.m.contexts().size() != 0) {
            if (!first) {
                this.stream.print(", ");
            }
            this.stream.print("$context");
        }
        this.stream.println(");");
    }

    protected String passType(int passType) {
        String type;
        switch (passType) {
            case 1: {
                type = "org.omg.CORBA.ARG_INOUT.value";
                break;
            }
            case 2: {
                type = "org.omg.CORBA.ARG_OUT.value";
                break;
            }
            default: {
                type = "org.omg.CORBA.ARG_IN.value";
            }
        }
        return type;
    }

    protected void serverMethodName(String name) {
        this.realName = name == null ? "" : name;
    }

    private void writeOutputStreamWrite(String indent, String oStream, String name, SymtabEntry type, PrintWriter stream) {
        String typeName = type.name();
        stream.print(indent);
        if (type instanceof PrimitiveEntry) {
            if (typeName.equals("long long")) {
                stream.println(oStream + ".write_longlong (" + name + ");");
            } else if (typeName.equals("unsigned short")) {
                stream.println(oStream + ".write_ushort (" + name + ");");
            } else if (typeName.equals("unsigned long")) {
                stream.println(oStream + ".write_ulong (" + name + ");");
            } else if (typeName.equals("unsigned long long")) {
                stream.println(oStream + ".write_ulonglong (" + name + ");");
            } else {
                stream.println(oStream + ".write_" + typeName + " (" + name + ");");
            }
        } else if (type instanceof StringEntry) {
            stream.println(oStream + ".write_" + typeName + " (" + name + ");");
        } else if (type instanceof SequenceEntry) {
            stream.println(oStream + ".write_" + type.type().name() + " (" + name + ");");
        } else if (type instanceof ValueBoxEntry) {
            ValueBoxEntry v = (ValueBoxEntry)type;
            TypedefEntry member = ((InterfaceState)v.state().elementAt((int)0)).entry;
            SymtabEntry mType = member.type();
            if (mType instanceof PrimitiveEntry && name.endsWith(".value")) {
                stream.println(Util.helperName(type, true) + ".write (" + oStream + ", " + " new " + Util.javaQualifiedName(type) + " (" + name + "));");
            } else {
                stream.println(Util.helperName(type, true) + ".write (" + oStream + ", " + name + ");");
            }
        } else if (type instanceof ValueEntry) {
            stream.println(Util.helperName(type, true) + ".write (" + oStream + ", " + name + ");");
        } else {
            stream.println(Util.helperName(type, true) + ".write (" + oStream + ", " + name + ");");
        }
    }

    private String writeInputStreamRead(String source, SymtabEntry type) {
        String read = "";
        read = type instanceof PrimitiveEntry ? (type.name().equals("long long") ? source + ".read_longlong ()" : (type.name().equals("unsigned short") ? source + ".read_ushort ()" : (type.name().equals("unsigned long") ? source + ".read_ulong ()" : (type.name().equals("unsigned long long") ? source + ".read_ulonglong ()" : source + ".read_" + type.name() + " ()")))) : (type instanceof StringEntry ? source + ".read_" + type.name() + " ()" : Util.helperName(type, true) + ".read (" + source + ')');
        return read;
    }

    protected void writeMethodCall(String indent) {
        SymtabEntry mtype = Util.typeOf(this.m.type());
        if (mtype == null) {
            this.stream.print(indent + "this." + this.m.name() + " (");
        } else {
            this.stream.print(indent + "$result = this." + this.m.name() + " (");
        }
    }

    protected void writeCreateReply(String indent) {
        this.stream.println(indent + "out = $rh.createReply();");
    }
}

