/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl.constExpr;

import com.sun.tools.corba.ee.idl.Util;
import com.sun.tools.corba.ee.idl.constExpr.EvaluationException;
import com.sun.tools.corba.ee.idl.constExpr.Expression;
import com.sun.tools.corba.ee.idl.constExpr.UnaryExpr;
import java.math.BigInteger;

public class Negative
extends UnaryExpr {
    protected Negative(Expression operand) {
        super("-", operand);
    }

    @Override
    public Object evaluate() throws EvaluationException {
        try {
            Number op = (Number)this.operand().evaluate();
            if (op instanceof Float || op instanceof Double) {
                this.value(new Double(-op.doubleValue()));
            } else {
                BigInteger tmpOp = (BigInteger)op;
                this.value(tmpOp.multiply(BigInteger.valueOf(-1L)));
            }
        }
        catch (ClassCastException e) {
            String[] parameters = new String[]{Util.getMessage("EvaluationException.neg"), this.operand().value().getClass().getName()};
            throw new EvaluationException(Util.getMessage("EvaluationException.2", parameters));
        }
        return this.value();
    }
}

