/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl;

import com.sun.tools.corba.ee.idl.SymtabEntry;
import java.security.MessageDigest;
import java.util.Hashtable;

public class ValueRepositoryId {
    private MessageDigest sha;
    private int index;
    private Hashtable types;
    private String hashcode;

    public ValueRepositoryId() {
        try {
            this.sha = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.index = 0;
        this.types = new Hashtable();
        this.hashcode = null;
    }

    public void addValue(int value) {
        this.sha.update((byte)(value >> 24 & 0xF));
        this.sha.update((byte)(value >> 16 & 0xF));
        this.sha.update((byte)(value >> 8 & 0xF));
        this.sha.update((byte)(value & 0xF));
        ++this.index;
    }

    public void addType(SymtabEntry entry) {
        this.types.put(entry, new Integer(this.index));
    }

    public boolean isNewType(SymtabEntry entry) {
        Object index = this.types.get(entry);
        if (index == null) {
            this.addType(entry);
            return true;
        }
        this.addValue(-1);
        this.addValue((Integer)index);
        return false;
    }

    public String getHashcode() {
        if (this.hashcode == null) {
            byte[] digest = this.sha.digest();
            this.hashcode = ValueRepositoryId.hexOf(digest[0]) + ValueRepositoryId.hexOf(digest[1]) + ValueRepositoryId.hexOf(digest[2]) + ValueRepositoryId.hexOf(digest[3]) + ValueRepositoryId.hexOf(digest[4]) + ValueRepositoryId.hexOf(digest[5]) + ValueRepositoryId.hexOf(digest[6]) + ValueRepositoryId.hexOf(digest[7]);
        }
        return this.hashcode;
    }

    private static String hexOf(byte value) {
        int d1 = value >> 4 & 0xF;
        int d2 = value & 0xF;
        return "0123456789ABCDEF".substring(d1, d1 + 1) + "0123456789ABCDEF".substring(d2, d2 + 1);
    }
}

