/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.ee.idl;

import com.sun.tools.corba.ee.idl.Comment;
import com.sun.tools.corba.ee.idl.IncludeEntry;
import com.sun.tools.corba.ee.idl.InvalidCharacter;
import com.sun.tools.corba.ee.idl.ParseException;
import com.sun.tools.corba.ee.idl.Parser;
import com.sun.tools.corba.ee.idl.ScannerData;
import com.sun.tools.corba.ee.idl.SymtabEntry;
import com.sun.tools.corba.ee.idl.Token;
import com.sun.tools.corba.ee.idl.Util;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

class Scanner {
    static final int Star = 0;
    static final int Plus = 1;
    static final int Dot = 2;
    static final int None = 3;
    private int BOL;
    private ScannerData data = new ScannerData();
    private Stack dataStack = new Stack();
    private Vector keywords = new Vector();
    private Vector openEndedKeywords = new Vector();
    private Vector wildcardKeywords = new Vector();
    private boolean verbose;
    boolean escapedOK = true;
    private boolean emitAll;
    private float corbaLevel;
    private boolean debug;

    Scanner(IncludeEntry file, String[] keywords, boolean vbose, boolean emitAllIncludes, float cLevel, boolean debug) throws IOException {
        this.readFile(file);
        this.verbose = vbose;
        this.emitAll = emitAllIncludes;
        this.sortKeywords(keywords);
        this.corbaLevel = cLevel;
        this.debug = debug;
    }

    void sortKeywords(String[] keywords) {
        for (int i = 0; i < keywords.length; ++i) {
            if (this.wildcardAtEitherEnd(keywords[i])) {
                this.openEndedKeywords.addElement(keywords[i]);
                continue;
            }
            if (this.wildcardsInside(keywords[i])) {
                this.wildcardKeywords.addElement(keywords[i]);
                continue;
            }
            this.keywords.addElement(keywords[i]);
        }
    }

    private boolean wildcardAtEitherEnd(String string) {
        return string.startsWith("*") || string.startsWith("+") || string.startsWith(".") || string.endsWith("*") || string.endsWith("+") || string.endsWith(".");
    }

    private boolean wildcardsInside(String string) {
        return string.indexOf("*") > 0 || string.indexOf("+") > 0 || string.indexOf(".") > 0;
    }

    void readFile(IncludeEntry file) throws IOException {
        String filename = file.name();
        filename = filename.substring(1, filename.length() - 1);
        this.readFile(file, filename);
    }

    void readFile(IncludeEntry file, String filename) throws IOException {
        this.data.fileEntry = file;
        this.data.filename = filename;
        File idlFile = new File(this.data.filename);
        int len = (int)idlFile.length();
        FileReader fileReader = new FileReader(idlFile);
        String EOL = System.getProperty("line.separator");
        this.data.fileBytes = new char[len + EOL.length()];
        fileReader.read(this.data.fileBytes, 0, len);
        fileReader.close();
        for (int i = 0; i < EOL.length(); ++i) {
            this.data.fileBytes[len + i] = EOL.charAt(i);
        }
        this.readChar();
    }

    Token getToken() throws IOException {
        Token token = null;
        String commentText = new String("");
        while (token == null) {
            try {
                this.data.oldIndex = this.data.fileIndex;
                this.data.oldLine = this.data.line;
                if (this.data.ch <= ' ') {
                    this.skipWhiteSpace();
                    continue;
                }
                if (this.data.ch == 'L') {
                    this.readChar();
                    if (this.data.ch == '\'') {
                        token = this.getCharacterToken(true);
                        this.readChar();
                        continue;
                    }
                    if (this.data.ch == '\"') {
                        this.readChar();
                        token = new Token(204, this.getUntil('\"'), true);
                        this.readChar();
                        continue;
                    }
                    this.unread(this.data.ch);
                    this.unread('L');
                    this.readChar();
                }
                if (this.data.ch >= 'a' && this.data.ch <= 'z' || this.data.ch >= 'A' && this.data.ch <= 'Z' || this.data.ch == '_' || Character.isLetter(this.data.ch)) {
                    token = this.getString();
                    continue;
                }
                if (this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch == '.') {
                    token = this.getNumber();
                    continue;
                }
                switch (this.data.ch) {
                    case ';': {
                        token = new Token(100);
                        break;
                    }
                    case '{': {
                        token = new Token(101);
                        break;
                    }
                    case '}': {
                        token = new Token(102);
                        break;
                    }
                    case ':': {
                        this.readChar();
                        if (this.data.ch == ':') {
                            token = new Token(124);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(103);
                        break;
                    }
                    case ',': {
                        token = new Token(104);
                        break;
                    }
                    case '=': {
                        this.readChar();
                        if (this.data.ch == '=') {
                            token = new Token(130);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(105);
                        break;
                    }
                    case '+': {
                        token = new Token(106);
                        break;
                    }
                    case '-': {
                        token = new Token(107);
                        break;
                    }
                    case '(': {
                        token = new Token(108);
                        break;
                    }
                    case ')': {
                        token = new Token(109);
                        break;
                    }
                    case '<': {
                        this.readChar();
                        if (this.data.ch == '<') {
                            token = new Token(125);
                            break;
                        }
                        if (this.data.ch == '=') {
                            token = new Token(133);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(110);
                        break;
                    }
                    case '>': {
                        this.readChar();
                        if (this.data.ch == '>') {
                            token = new Token(126);
                            break;
                        }
                        if (this.data.ch == '=') {
                            token = new Token(132);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(111);
                        break;
                    }
                    case '[': {
                        token = new Token(112);
                        break;
                    }
                    case ']': {
                        token = new Token(113);
                        break;
                    }
                    case '\'': {
                        token = this.getCharacterToken(false);
                        break;
                    }
                    case '\"': {
                        this.readChar();
                        token = new Token(204, this.getUntil('\"', false, false, false));
                        break;
                    }
                    case '\\': {
                        this.readChar();
                        if (this.data.ch == '\n' || this.data.ch == '\r') {
                            token = null;
                            break;
                        }
                        token = new Token(116);
                        break;
                    }
                    case '|': {
                        this.readChar();
                        if (this.data.ch == '|') {
                            token = new Token(134);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(117);
                        break;
                    }
                    case '^': {
                        token = new Token(118);
                        break;
                    }
                    case '&': {
                        this.readChar();
                        if (this.data.ch == '&') {
                            token = new Token(135);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(119);
                        break;
                    }
                    case '*': {
                        token = new Token(120);
                        break;
                    }
                    case '/': {
                        this.readChar();
                        if (this.data.ch == '/') {
                            commentText = this.getLineComment();
                            break;
                        }
                        if (this.data.ch == '*') {
                            commentText = this.getBlockComment();
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(121);
                        break;
                    }
                    case '%': {
                        token = new Token(122);
                        break;
                    }
                    case '~': {
                        token = new Token(123);
                        break;
                    }
                    case '#': {
                        token = this.getDirective();
                        break;
                    }
                    case '!': {
                        this.readChar();
                        if (this.data.ch == '=') {
                            token = new Token(131);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(129);
                        break;
                    }
                    case '?': {
                        try {
                            token = this.replaceTrigraph();
                            break;
                        }
                        catch (InvalidCharacter e) {
                            // empty catch block
                        }
                    }
                    default: {
                        throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
                    }
                }
                this.readChar();
            }
            catch (EOFException e) {
                token = new Token(999);
            }
        }
        token.comment = new Comment(commentText);
        if (this.debug) {
            System.out.println("Token: " + token);
        }
        return token;
    }

    void scanString(String string) {
        this.dataStack.push(this.data);
        this.data = new ScannerData(this.data);
        this.data.fileIndex = 0;
        this.data.oldIndex = 0;
        int strLen = string.length();
        this.data.fileBytes = new char[strLen];
        string.getChars(0, strLen, this.data.fileBytes, 0);
        this.data.macrodata = true;
        try {
            this.readChar();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void scanIncludedFile(IncludeEntry file, String filename, boolean includeIsImport) throws IOException {
        this.dataStack.push(this.data);
        this.data = new ScannerData();
        this.data.indent = ((ScannerData)this.dataStack.peek()).indent + ' ';
        this.data.includeIsImport = includeIsImport;
        try {
            this.readFile(file, filename);
            if (!this.emitAll && includeIsImport) {
                SymtabEntry.enteringInclude();
            }
            Parser.enteringInclude();
            if (this.verbose) {
                System.out.println(this.data.indent + Util.getMessage("Compile.parsing", filename));
            }
        }
        catch (IOException e) {
            this.data = (ScannerData)this.dataStack.pop();
            throw e;
        }
    }

    private void unread(char ch) {
        if (ch == '\n' && !this.data.macrodata) {
            --this.data.line;
        }
        --this.data.fileIndex;
    }

    void readChar() throws IOException {
        if (this.data.fileIndex >= this.data.fileBytes.length) {
            if (this.dataStack.empty()) {
                throw new EOFException();
            }
            if (!this.data.macrodata) {
                if (!this.emitAll && this.data.includeIsImport) {
                    SymtabEntry.exitingInclude();
                }
                Parser.exitingInclude();
            }
            if (this.verbose && !this.data.macrodata) {
                System.out.println(this.data.indent + Util.getMessage("Compile.parseDone", this.data.filename));
            }
            this.data = (ScannerData)this.dataStack.pop();
        } else {
            this.data.ch = (char)(this.data.fileBytes[this.data.fileIndex++] & 0xFF);
            if (this.data.ch == '\n' && !this.data.macrodata) {
                ++this.data.line;
            }
        }
    }

    private String getWString() throws IOException {
        this.readChar();
        StringBuffer result = new StringBuffer();
        while (this.data.ch != '\"') {
            if (this.data.ch == '\\') {
                this.readChar();
                if (this.data.ch == 'u') {
                    int num = this.getNDigitHexNumber(4);
                    System.out.println("Got num: " + num);
                    System.out.println("Which is: " + (char)num);
                    result.append((char)num);
                    continue;
                }
                if (this.data.ch >= '0' && this.data.ch <= '7') {
                    result.append((char)this.get3DigitOctalNumber());
                    continue;
                }
                result.append('\\');
                result.append(this.data.ch);
            } else {
                result.append(this.data.ch);
            }
            this.readChar();
        }
        return result.toString();
    }

    private Token getCharacterToken(boolean isWide) throws IOException {
        Token token = null;
        this.readChar();
        if (this.data.ch == '\\') {
            this.readChar();
            if (this.data.ch == 'x' || this.data.ch == 'u') {
                char charType = this.data.ch;
                int hexNum = this.getNDigitHexNumber(charType == 'x' ? 2 : 4);
                return new Token(201, (char)hexNum + "\\" + charType + Integer.toString(hexNum, 16), isWide);
            }
            if (this.data.ch >= '0' && this.data.ch <= '7') {
                int octNum = this.get3DigitOctalNumber();
                return new Token(201, (char)octNum + "\\" + Integer.toString(octNum, 8), isWide);
            }
            return this.singleCharEscapeSequence(isWide);
        }
        token = new Token(201, "" + this.data.ch + this.data.ch, isWide);
        this.readChar();
        return token;
    }

    private Token singleCharEscapeSequence(boolean isWide) throws IOException {
        Token token;
        if (this.data.ch == 'n') {
            token = new Token(201, "\n\\n", isWide);
        } else if (this.data.ch == 't') {
            token = new Token(201, "\t\\t", isWide);
        } else if (this.data.ch == 'v') {
            token = new Token(201, "\u000b\\v", isWide);
        } else if (this.data.ch == 'b') {
            token = new Token(201, "\b\\b", isWide);
        } else if (this.data.ch == 'r') {
            token = new Token(201, "\r\\r", isWide);
        } else if (this.data.ch == 'f') {
            token = new Token(201, "\f\\f", isWide);
        } else if (this.data.ch == 'a') {
            token = new Token(201, "\u0007\\a", isWide);
        } else if (this.data.ch == '\\') {
            token = new Token(201, "\\\\\\", isWide);
        } else if (this.data.ch == '?') {
            token = new Token(201, "?\\?", isWide);
        } else if (this.data.ch == '\'') {
            token = new Token(201, "'\\'", isWide);
        } else if (this.data.ch == '\"') {
            token = new Token(201, "\"\\\"", isWide);
        } else {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        this.readChar();
        return token;
    }

    private Token getString() throws IOException {
        Token result;
        StringBuffer sbuf = new StringBuffer();
        boolean escaped = false;
        boolean[] collidesWithKeyword = new boolean[]{false};
        if (this.data.ch == '_') {
            sbuf.append(this.data.ch);
            this.readChar();
            escaped = this.escapedOK;
            if (escaped && this.data.ch == '_') {
                throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
            }
        }
        while (Character.isLetterOrDigit(this.data.ch) || this.data.ch == '_') {
            sbuf.append(this.data.ch);
            this.readChar();
        }
        String string = sbuf.toString();
        if (!escaped && (result = Token.makeKeywordToken(string, this.corbaLevel, this.escapedOK, collidesWithKeyword)) != null) {
            return result;
        }
        string = this.getIdentifier(string);
        if (this.data.ch == '(') {
            this.readChar();
            return new Token(81, string, escaped, collidesWithKeyword[0], false);
        }
        return new Token(80, string, escaped, collidesWithKeyword[0], false);
    }

    private boolean matchesClosedWildKeyword(String string) {
        boolean found = true;
        String tmpString = string;
        Enumeration e = this.wildcardKeywords.elements();
        while (e.hasMoreElements()) {
            String token;
            int wildcard = 3;
            StringTokenizer tokens = new StringTokenizer((String)e.nextElement(), "*+.", true);
            if (!tokens.hasMoreTokens() || !tmpString.startsWith(token = tokens.nextToken())) continue;
            tmpString = tmpString.substring(token.length());
            while (tokens.hasMoreTokens() && found) {
                int index;
                token = tokens.nextToken();
                if (token.equals("*")) {
                    wildcard = 0;
                    continue;
                }
                if (token.equals("+")) {
                    wildcard = 1;
                    continue;
                }
                if (token.equals(".")) {
                    wildcard = 2;
                    continue;
                }
                if (wildcard == 0) {
                    index = tmpString.indexOf(token);
                    if (index >= 0) {
                        tmpString = tmpString.substring(index + token.length());
                        continue;
                    }
                    found = false;
                    continue;
                }
                if (wildcard == 1) {
                    index = tmpString.indexOf(token);
                    if (index > 0) {
                        tmpString = tmpString.substring(index + token.length());
                        continue;
                    }
                    found = false;
                    continue;
                }
                if (wildcard != 2) continue;
                index = tmpString.indexOf(token);
                if (index == 1) {
                    tmpString = tmpString.substring(1 + token.length());
                    continue;
                }
                found = false;
            }
            if (!found || !tmpString.equals("")) continue;
            break;
        }
        return found && tmpString.equals("");
    }

    private String matchesOpenWildcard(String string) {
        Enumeration e = this.openEndedKeywords.elements();
        String prepend = "";
        while (e.hasMoreElements()) {
            int wildcard = 3;
            boolean found = true;
            String tmpString = string;
            StringTokenizer tokens = new StringTokenizer((String)e.nextElement(), "*+.", true);
            while (tokens.hasMoreTokens() && found) {
                int index;
                String token = tokens.nextToken();
                if (token.equals("*")) {
                    wildcard = 0;
                    continue;
                }
                if (token.equals("+")) {
                    wildcard = 1;
                    continue;
                }
                if (token.equals(".")) {
                    wildcard = 2;
                    continue;
                }
                if (wildcard == 0) {
                    wildcard = 3;
                    index = tmpString.lastIndexOf(token);
                    if (index >= 0) {
                        tmpString = this.blankOutMatch(tmpString, index, token.length());
                        continue;
                    }
                    found = false;
                    continue;
                }
                if (wildcard == 1) {
                    wildcard = 3;
                    index = tmpString.lastIndexOf(token);
                    if (index > 0) {
                        tmpString = this.blankOutMatch(tmpString, index, token.length());
                        continue;
                    }
                    found = false;
                    continue;
                }
                if (wildcard == 2) {
                    wildcard = 3;
                    index = tmpString.lastIndexOf(token);
                    if (index == 1) {
                        tmpString = this.blankOutMatch(tmpString, 1, token.length());
                        continue;
                    }
                    found = false;
                    continue;
                }
                if (wildcard != 3) continue;
                if (tmpString.startsWith(token)) {
                    tmpString = this.blankOutMatch(tmpString, 0, token.length());
                    continue;
                }
                found = false;
            }
            if (!(!found || wildcard == 0 || wildcard == 1 && tmpString.lastIndexOf(32) != tmpString.length() - 1 || wildcard == 2 && tmpString.lastIndexOf(32) == tmpString.length() - 2 || wildcard == 3 && tmpString.lastIndexOf(32) == tmpString.length() - 1)) {
                found = false;
            }
            if (!found) continue;
            prepend = prepend + "_" + this.matchesOpenWildcard(tmpString.trim());
            break;
        }
        return prepend;
    }

    private String blankOutMatch(String string, int start, int length) {
        char[] blanks = new char[length];
        for (int i = 0; i < length; ++i) {
            blanks[i] = 32;
        }
        return string.substring(0, start) + new String(blanks) + string.substring(start + length);
    }

    private String getIdentifier(String string) {
        if (this.keywords.contains(string)) {
            string = '_' + string;
        } else {
            String prepend = "";
            prepend = this.matchesClosedWildKeyword(string) ? "_" : this.matchesOpenWildcard(string);
            string = prepend + string;
        }
        return string;
    }

    private Token getDirective() throws IOException {
        this.readChar();
        String string = new String();
        while (this.data.ch >= 'a' && this.data.ch <= 'z' || this.data.ch >= 'A' && this.data.ch <= 'Z') {
            string = string + this.data.ch;
            this.readChar();
        }
        this.unread(this.data.ch);
        for (int i = 0; i < Token.Directives.length; ++i) {
            if (!string.equals(Token.Directives[i])) continue;
            return new Token(300 + i);
        }
        return new Token(313, string);
    }

    private Token getNumber() throws IOException {
        if (this.data.ch == '.') {
            return this.getFractionNoInteger();
        }
        if (this.data.ch == '0') {
            return this.isItHex();
        }
        return this.getInteger();
    }

    private Token getFractionNoInteger() throws IOException {
        this.readChar();
        if (this.data.ch >= '0' && this.data.ch <= '9') {
            return this.getFraction(".");
        }
        return new Token(127);
    }

    private Token getFraction(String string) throws IOException {
        while (this.data.ch >= '0' && this.data.ch <= '9') {
            string = string + this.data.ch;
            this.readChar();
        }
        if (this.data.ch == 'e' || this.data.ch == 'E') {
            return this.getExponent(string + 'E');
        }
        return new Token(203, string);
    }

    private Token getExponent(String string) throws IOException {
        this.readChar();
        if (this.data.ch == '+' || this.data.ch == '-') {
            string = string + this.data.ch;
            this.readChar();
        } else if (this.data.ch < '0' || this.data.ch > '9') {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        while (this.data.ch >= '0' && this.data.ch <= '9') {
            string = string + this.data.ch;
            this.readChar();
        }
        return new Token(203, string);
    }

    private Token isItHex() throws IOException {
        this.readChar();
        if (this.data.ch == '.') {
            this.readChar();
            return this.getFraction("0.");
        }
        if (this.data.ch == 'x' || this.data.ch == 'X') {
            return this.getHexNumber("0x");
        }
        if (this.data.ch == '8' || this.data.ch == '9') {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        if (this.data.ch >= '0' && this.data.ch <= '7') {
            return this.getOctalNumber();
        }
        if (this.data.ch == 'e' || this.data.ch == 'E') {
            return this.getExponent("0E");
        }
        return new Token(202, "0");
    }

    private Token getOctalNumber() throws IOException {
        String string = "0" + this.data.ch;
        this.readChar();
        while (this.data.ch >= '0' && this.data.ch <= '9') {
            if (this.data.ch == '8' || this.data.ch == '9') {
                throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
            }
            string = string + this.data.ch;
            this.readChar();
        }
        return new Token(202, string);
    }

    private Token getHexNumber(String string) throws IOException {
        this.readChar();
        if (!(this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch >= 'a' && this.data.ch <= 'f' || this.data.ch >= 'A' && this.data.ch <= 'F')) {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        while (this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch >= 'a' && this.data.ch <= 'f' || this.data.ch >= 'A' && this.data.ch <= 'F') {
            string = string + this.data.ch;
            this.readChar();
        }
        return new Token(202, string);
    }

    private int getNDigitHexNumber(int n) throws IOException {
        this.readChar();
        if (!this.isHexChar(this.data.ch)) {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        String string = "" + this.data.ch;
        this.readChar();
        for (int i = 2; i <= n && this.isHexChar(this.data.ch); ++i) {
            string = string + this.data.ch;
            this.readChar();
        }
        try {
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private boolean isHexChar(char hex) {
        return this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch >= 'a' && this.data.ch <= 'f' || this.data.ch >= 'A' && this.data.ch <= 'F';
    }

    private int get3DigitOctalNumber() throws IOException {
        char firstDigit = this.data.ch;
        String string = "" + this.data.ch;
        this.readChar();
        if (this.data.ch >= '0' && this.data.ch <= '7') {
            string = string + this.data.ch;
            this.readChar();
            if (this.data.ch >= '0' && this.data.ch <= '7') {
                string = string + this.data.ch;
                if (firstDigit > '3') {
                    throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), firstDigit);
                }
                this.readChar();
            }
        }
        int ret = 0;
        try {
            ret = Integer.parseInt(string, 8);
        }
        catch (NumberFormatException e) {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), string.charAt(0));
        }
        return ret;
    }

    private Token getInteger() throws IOException {
        String string = "" + this.data.ch;
        this.readChar();
        if (this.data.ch == '.') {
            this.readChar();
            return this.getFraction(string + '.');
        }
        if (this.data.ch == 'e' || this.data.ch == 'E') {
            return this.getExponent(string + 'E');
        }
        if (this.data.ch >= '0' && this.data.ch <= '9') {
            while (this.data.ch >= '0' && this.data.ch <= '9') {
                string = string + this.data.ch;
                this.readChar();
                if (this.data.ch != '.') continue;
                this.readChar();
                return this.getFraction(string + '.');
            }
        }
        return new Token(202, string);
    }

    private Token replaceTrigraph() throws IOException {
        this.readChar();
        if (this.data.ch == '?') {
            this.readChar();
            if (this.data.ch == '=') {
                this.data.ch = (char)35;
            } else if (this.data.ch == '/') {
                this.data.ch = (char)92;
            } else if (this.data.ch == '\'') {
                this.data.ch = (char)94;
            } else if (this.data.ch == '(') {
                this.data.ch = (char)91;
            } else if (this.data.ch == ')') {
                this.data.ch = (char)93;
            } else if (this.data.ch == '!') {
                this.data.ch = (char)124;
            } else if (this.data.ch == '<') {
                this.data.ch = (char)123;
            } else if (this.data.ch == '>') {
                this.data.ch = (char)125;
            } else if (this.data.ch == '-') {
                this.data.ch = (char)126;
            } else {
                this.unread(this.data.ch);
                this.unread('?');
                throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
            }
            return this.getToken();
        }
        this.unread('?');
        throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
    }

    void skipWhiteSpace() throws IOException {
        while (this.data.ch <= ' ') {
            this.readChar();
        }
    }

    private void skipBlockComment() throws IOException {
        try {
            boolean done = false;
            this.readChar();
            while (!done) {
                while (this.data.ch != '*') {
                    this.readChar();
                }
                this.readChar();
                if (this.data.ch != '/') continue;
                done = true;
            }
        }
        catch (EOFException e) {
            ParseException.unclosedComment(this.data.filename);
            throw e;
        }
    }

    void skipLineComment() throws IOException {
        while (this.data.ch != '\n') {
            this.readChar();
        }
    }

    private String getLineComment() throws IOException {
        StringBuffer sb = new StringBuffer("/");
        while (this.data.ch != '\n') {
            if (this.data.ch != '\r') {
                sb.append(this.data.ch);
            }
            this.readChar();
        }
        return sb.toString();
    }

    private String getBlockComment() throws IOException {
        StringBuffer sb = new StringBuffer("/*");
        try {
            boolean done = false;
            this.readChar();
            sb.append(this.data.ch);
            while (!done) {
                while (this.data.ch != '*') {
                    this.readChar();
                    sb.append(this.data.ch);
                }
                this.readChar();
                sb.append(this.data.ch);
                if (this.data.ch != '/') continue;
                done = true;
            }
        }
        catch (EOFException e) {
            ParseException.unclosedComment(this.data.filename);
            throw e;
        }
        return sb.toString();
    }

    Token skipUntil(char c) throws IOException {
        while (this.data.ch != c) {
            if (this.data.ch == '/') {
                this.readChar();
                if (this.data.ch == '/') {
                    this.skipLineComment();
                    if (c != '\n') continue;
                    break;
                }
                if (this.data.ch != '*') continue;
                this.skipBlockComment();
                continue;
            }
            this.readChar();
        }
        return this.getToken();
    }

    String getUntil(char c) throws IOException {
        return this.getUntil(c, true, true, true);
    }

    String getUntil(char c, boolean allowQuote, boolean allowCharLit, boolean allowComment) throws IOException {
        String string = "";
        while (this.data.ch != c) {
            string = this.appendToString(string, allowQuote, allowCharLit, allowComment);
        }
        return string;
    }

    String getUntil(char c1, char c2) throws IOException {
        String string = "";
        while (this.data.ch != c1 && this.data.ch != c2) {
            string = this.appendToString(string, false, false, false);
        }
        return string;
    }

    private String appendToString(String string, boolean allowQuote, boolean allowCharLit, boolean allowComment) throws IOException {
        if (allowComment && this.data.ch == '/') {
            this.readChar();
            if (this.data.ch == '/') {
                this.skipLineComment();
            } else if (this.data.ch == '*') {
                this.skipBlockComment();
            } else {
                string = string + '/';
            }
        } else if (this.data.ch == '\\') {
            this.readChar();
            if (this.data.ch == '\n') {
                this.readChar();
            } else if (this.data.ch == '\r') {
                this.readChar();
                if (this.data.ch == '\n') {
                    this.readChar();
                }
            } else {
                string = string + '\\' + this.data.ch;
                this.readChar();
            }
        } else {
            if (allowCharLit && this.data.ch == '\"') {
                this.readChar();
                string = string + '\"';
                while (this.data.ch != '\"') {
                    string = this.appendToString(string, true, false, allowComment);
                }
            } else if (allowQuote && allowCharLit && this.data.ch == '(') {
                this.readChar();
                string = string + '(';
                while (this.data.ch != ')') {
                    string = this.appendToString(string, false, false, allowComment);
                }
            } else if (allowQuote && this.data.ch == '\'') {
                this.readChar();
                string = string + "'";
                while (this.data.ch != '\'') {
                    string = this.appendToString(string, false, true, allowComment);
                }
            }
            string = string + this.data.ch;
            this.readChar();
        }
        return string;
    }

    String getStringToEOL() throws IOException {
        String string = new String();
        while (this.data.ch != '\n') {
            if (this.data.ch == '\\') {
                this.readChar();
                if (this.data.ch == '\n') {
                    this.readChar();
                    continue;
                }
                if (this.data.ch == '\r') {
                    this.readChar();
                    if (this.data.ch != '\n') continue;
                    this.readChar();
                    continue;
                }
                string = string + this.data.ch;
                this.readChar();
                continue;
            }
            string = string + this.data.ch;
            this.readChar();
        }
        return string;
    }

    String filename() {
        return this.data.filename;
    }

    IncludeEntry fileEntry() {
        return this.data.fileEntry;
    }

    int currentLineNumber() {
        return this.data.line;
    }

    int lastTokenLineNumber() {
        return this.data.oldLine;
    }

    String currentLine() {
        this.BOL = this.data.fileIndex - 1;
        try {
            if (this.data.fileBytes[this.BOL - 1] == '\r' && this.data.fileBytes[this.BOL] == '\n') {
                this.BOL -= 2;
            } else if (this.data.fileBytes[this.BOL] == '\n') {
                --this.BOL;
            }
            while (this.data.fileBytes[this.BOL] != '\n') {
                --this.BOL;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.BOL = -1;
        }
        ++this.BOL;
        int EOL = this.data.fileIndex - 1;
        try {
            while (this.data.fileBytes[EOL] != '\n' && this.data.fileBytes[EOL] != '\r') {
                ++EOL;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            EOL = this.data.fileBytes.length;
        }
        if (this.BOL < EOL) {
            return new String(this.data.fileBytes, this.BOL, EOL - this.BOL);
        }
        return "";
    }

    String lastTokenLine() {
        int saveFileIndex = this.data.fileIndex;
        this.data.fileIndex = this.data.oldIndex;
        String ret = this.currentLine();
        this.data.fileIndex = saveFileIndex;
        return ret;
    }

    int currentLinePosition() {
        return this.data.fileIndex - this.BOL;
    }

    int lastTokenLinePosition() {
        return this.data.oldIndex - this.BOL;
    }
}

