/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.routing;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.river.RiverName;
import org.elasticsearch.river.routing.RiverRouting;

public class RiversRouting
implements Iterable<RiverRouting> {
    public static final RiversRouting EMPTY = RiversRouting.builder().build();
    private final ImmutableMap<RiverName, RiverRouting> rivers;

    private RiversRouting(ImmutableMap<RiverName, RiverRouting> rivers) {
        this.rivers = rivers;
    }

    public boolean isEmpty() {
        return this.rivers.isEmpty();
    }

    public RiverRouting routing(RiverName riverName) {
        return this.rivers.get(riverName);
    }

    public boolean hasRiverByName(String name) {
        for (RiverName riverName : this.rivers.keySet()) {
            if (!riverName.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<RiverRouting> iterator() {
        return ((ImmutableCollection)this.rivers.values()).iterator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private MapBuilder<RiverName, RiverRouting> rivers = MapBuilder.newMapBuilder();

        public Builder routing(RiversRouting routing) {
            this.rivers.putAll(routing.rivers);
            return this;
        }

        public Builder put(RiverRouting routing) {
            this.rivers.put(routing.riverName(), routing);
            return this;
        }

        public Builder remove(RiverRouting routing) {
            this.rivers.remove(routing.riverName());
            return this;
        }

        public Builder remove(RiverName riverName) {
            this.rivers.remove(riverName);
            return this;
        }

        public Builder remote(String riverName) {
            for (RiverName name : this.rivers.map().keySet()) {
                if (!name.name().equals(riverName)) continue;
                this.rivers.remove(name);
            }
            return this;
        }

        public RiversRouting build() {
            return new RiversRouting(this.rivers.immutableMap());
        }

        public static RiversRouting readFrom(StreamInput in) throws IOException {
            Builder builder = new Builder();
            int size = in.readVInt();
            for (int i = 0; i < size; ++i) {
                builder.put(RiverRouting.readRiverRouting(in));
            }
            return builder.build();
        }

        public static void writeTo(RiversRouting routing, StreamOutput out) throws IOException {
            out.writeVInt(routing.rivers.size());
            for (RiverRouting riverRouting : routing) {
                riverRouting.writeTo(out);
            }
        }
    }
}

