/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;

public class RestMultiSearchAction
extends BaseRestHandler {
    private final boolean allowExplicitIndex;

    @Inject
    public RestMultiSearchAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_msearch", this);
        controller.registerHandler(RestRequest.Method.POST, "/_msearch", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_msearch", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_msearch", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_msearch", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_msearch", this);
        this.allowExplicitIndex = settings.getAsBoolean("rest.action.multi.allow_explicit_index", (Boolean)true);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        multiSearchRequest.listenerThreaded(false);
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] types = Strings.splitStringByCommaToArray(request.param("type"));
        IndicesOptions indicesOptions = IndicesOptions.fromRequest(request, multiSearchRequest.indicesOptions());
        multiSearchRequest.add(RestActions.getRestContent(request), request.contentUnsafe(), indices, types, request.param("search_type"), request.param("routing"), indicesOptions, this.allowExplicitIndex);
        client.multiSearch(multiSearchRequest, new RestToXContentListener<MultiSearchResponse>(channel));
    }
}

