/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;

public class TypeFilterParser
implements FilterParser {
    public static final String NAME = "type";

    @Inject
    public TypeFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[type] filter should have a value field, and the type name");
        }
        String fieldName = parser.currentName();
        if (!fieldName.equals("value")) {
            throw new QueryParsingException(parseContext.index(), "[type] filter should have a value field, and the type name");
        }
        token = parser.nextToken();
        if (token != XContentParser.Token.VALUE_STRING) {
            throw new QueryParsingException(parseContext.index(), "[type] filter should have a value field, and the type name");
        }
        BytesRef type = parser.utf8Bytes();
        parser.nextToken();
        DocumentMapper documentMapper = parseContext.mapperService().documentMapper(type.utf8ToString());
        Object filter = documentMapper == null ? new TermFilter(new Term("_type", type)) : documentMapper.typeFilter();
        return parseContext.cacheFilter((Filter)filter, null);
    }
}

