/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.local;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.LegacyTranslogStream;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStream;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.TruncatedTranslogException;
import org.elasticsearch.index.translog.fs.FsTranslog;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class LocalIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    private static final int RECOVERY_TRANSLOG_RENAME_RETRIES = 3;
    private final ThreadPool threadPool;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final IndexService indexService;
    private final IndexShard indexShard;
    private final TimeValue waitForMappingUpdatePostRecovery;
    private volatile ScheduledFuture flushScheduler;
    private final TimeValue syncInterval;
    private final CancellableThreads cancellableThreads = new CancellableThreads();

    @Inject
    public LocalIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, MappingUpdatedAction mappingUpdatedAction, IndexService indexService, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.indexService = indexService;
        this.indexShard = indexShard;
        this.waitForMappingUpdatePostRecovery = this.componentSettings.getAsTime("wait_for_mapping_update_post_recovery", TimeValue.timeValueSeconds(30L));
        this.syncInterval = this.componentSettings.getAsTime("sync", TimeValue.timeValueSeconds(5L));
        if (this.syncInterval.millis() > 0L) {
            this.indexShard.translog().syncOnEachOperation(false);
            this.flushScheduler = threadPool.schedule(this.syncInterval, "same", new Sync());
        } else if (this.syncInterval.millis() == 0L) {
            this.flushScheduler = null;
            this.indexShard.translog().syncOnEachOperation(true);
        } else {
            this.flushScheduler = null;
        }
    }

    public String toString() {
        return "local";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void recover(boolean indexShouldExists, RecoveryState recoveryState) throws IndexShardGatewayRecoveryException {
        this.indexShard.prepareForIndexRecovery();
        long version = -1L;
        long translogId = -1L;
        SegmentInfos si = null;
        HashSet<String> typesToUpdate = Sets.newHashSet();
        this.indexShard.store().incRef();
        try {
            TranslogStream stream;
            block47: {
                try {
                    block46: {
                        this.indexShard.store().failIfCorrupted();
                        try {
                            si = Lucene.readSegmentInfos(this.indexShard.store().directory());
                        }
                        catch (Throwable e) {
                            String files = "_unknown_";
                            try {
                                files = Arrays.toString(this.indexShard.store().directory().listAll());
                            }
                            catch (Throwable e1) {
                                files = files + " (failure=" + ExceptionsHelper.detailedMessage(e1) + ")";
                            }
                            if (!indexShouldExists || !this.indexShard.indexService().store().persistent()) break block46;
                            throw new IndexShardGatewayRecoveryException(this.shardId(), "shard allocated for local recovery (post api), should exist, but doesn't, current files: " + files, e);
                        }
                    }
                    if (si == null) break block47;
                    if (indexShouldExists) {
                        version = si.getVersion();
                        translogId = si.getUserData().containsKey("translog_id") ? Long.parseLong((String)si.getUserData().get("translog_id")) : version;
                        this.logger.trace("using existing shard data, translog id [{}]", translogId);
                    } else {
                        this.logger.trace("cleaning existing shard, shouldn't exists", new Object[0]);
                        IndexWriter writer = new IndexWriter(this.indexShard.store().directory(), new IndexWriterConfig(Lucene.VERSION, (Analyzer)Lucene.STANDARD_ANALYZER).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
                        writer.close();
                    }
                }
                catch (Throwable e) {
                    throw new IndexShardGatewayRecoveryException(this.shardId(), "failed to fetch index version after copying it over", e);
                }
            }
            recoveryState.getIndex().updateVersion(version);
            try {
                RecoveryState.Index index = recoveryState.getIndex();
                if (si != null) {
                    Directory directory = this.indexShard.store().directory();
                    for (String name : Lucene.files(si)) {
                        long length = directory.fileLength(name);
                        index.addFileDetail(name, length, true);
                    }
                }
            }
            catch (IOException e) {
                this.logger.debug("failed to list file details", e, new Object[0]);
            }
            File recoveringTranslogFile = null;
            if (translogId == -1L) {
                this.logger.trace("no translog id set (indexShouldExist [{}])", indexShouldExists);
            } else {
                FsTranslog translog = (FsTranslog)this.indexShard.translog();
                String translogName = "translog-" + translogId;
                String recoverTranslogName = translogName + ".recovering";
                this.logger.trace("try recover from translog file {} locations: {}", translogName, Arrays.toString(translog.locations()));
                for (File translogLocation : translog.locations()) {
                    boolean success;
                    File tmpTranslogFile;
                    File tmpRecoveringFile;
                    block48: {
                        tmpRecoveringFile = new File(translogLocation, recoverTranslogName);
                        if (!tmpRecoveringFile.exists()) {
                            tmpTranslogFile = new File(translogLocation, translogName);
                            if (tmpTranslogFile.exists()) {
                                this.logger.trace("Translog file found in {} - renaming", translogLocation);
                                success = false;
                                break block48;
                            } else {
                                this.logger.trace("Translog file NOT found in {} - continue", translogLocation);
                                continue;
                            }
                        }
                        recoveringTranslogFile = tmpRecoveringFile;
                        break;
                    }
                    for (int i = 0; i < 3; ++i) {
                        if (!tmpTranslogFile.renameTo(tmpRecoveringFile)) continue;
                        recoveringTranslogFile = tmpRecoveringFile;
                        this.logger.trace("Renamed translog from {} to {}", tmpTranslogFile.getName(), recoveringTranslogFile.getName());
                        success = true;
                        break;
                    }
                    if (success) continue;
                    try {
                        Files.copy(tmpTranslogFile.toPath(), tmpRecoveringFile.toPath(), new CopyOption[0]);
                        recoveringTranslogFile = tmpRecoveringFile;
                        this.logger.trace("Copied translog from {} to {}", tmpTranslogFile.getName(), recoveringTranslogFile.getName());
                    }
                    catch (IOException ex) {
                        throw new ElasticsearchException("failed to copy recovery file", ex);
                    }
                }
            }
            this.indexShard.prepareForTranslogRecovery();
            if (recoveringTranslogFile == null || !recoveringTranslogFile.exists()) {
                recoveryState.getTranslog().totalOperations(0);
                recoveryState.getTranslog().totalOperationsOnStart(0);
                this.indexShard.finalizeRecovery();
                this.indexShard.postRecovery("post recovery from gateway, no translog");
                return;
            }
            StreamInput in = null;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("recovering translog file: {} length: {}", recoveringTranslogFile, recoveringTranslogFile.length());
            }
            try {
                stream = TranslogStreams.translogStreamFor(recoveringTranslogFile);
                try {
                    in = stream.openInput(recoveringTranslogFile);
                }
                catch (TruncatedTranslogException e) {
                    this.logger.trace("ignoring truncation exception, the translog is either empty or half-written", e, new Object[0]);
                }
            }
            catch (Throwable e) {
                try {
                    this.indexShard.translog().closeWithDelete();
                    throw new IndexShardGatewayRecoveryException(this.shardId, "failed to recover shard", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
            }
            while (in != null) {
                Translog.Operation operation;
                try {
                    if (stream instanceof LegacyTranslogStream) {
                        in.readInt();
                    }
                    operation = stream.read(in);
                }
                catch (EOFException | TruncatedTranslogException e) {
                    this.logger.trace("ignoring translog EOF exception, the last operation was not properly written", e, new Object[0]);
                    break;
                }
                catch (IOException e) {
                    this.logger.trace("ignoring translog IO exception, the last operation was not properly written", e, new Object[0]);
                    break;
                }
                try {
                    Engine.IndexingOperation potentialIndexOperation = this.indexShard.performRecoveryOperation(operation);
                    if (potentialIndexOperation != null && potentialIndexOperation.parsedDoc().mappingsModified() && !typesToUpdate.contains(potentialIndexOperation.docMapper().type())) {
                        typesToUpdate.add(potentialIndexOperation.docMapper().type());
                    }
                    recoveryState.getTranslog().incrementRecoveredOperations();
                }
                catch (ElasticsearchException e) {
                    if (e.status() != RestStatus.BAD_REQUEST) throw e;
                    this.logger.info("ignoring recovery of a corrupt translog entry", e, new Object[0]);
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
            try {
                FlushRequest flushRequest = new FlushRequest(new String[0]);
                flushRequest.force(false);
                flushRequest.waitIfOngoing(false);
                this.indexShard.flush(flushRequest);
            }
            catch (FlushNotAllowedEngineException e) {
                this.logger.debug("skipping flush at end of recovery (not allowed)", e, new Object[0]);
            }
            this.indexShard.finalizeRecovery();
            this.indexShard.postRecovery("post recovery from gateway");
            try {
                Files.deleteIfExists(recoveringTranslogFile.toPath());
            }
            catch (Exception ex) {
                this.logger.debug("Failed to delete recovering translog file {}", ex, recoveringTranslogFile);
            }
        }
        finally {
            this.indexShard.store().decRef();
        }
        Iterator i$ = typesToUpdate.iterator();
        while (i$.hasNext()) {
            final String type = (String)i$.next();
            final CountDownLatch latch = new CountDownLatch(1);
            this.mappingUpdatedAction.updateMappingOnMaster(this.indexService.index().name(), this.indexService.mapperService().documentMapper(type), this.indexService.indexUUID(), new MappingUpdatedAction.MappingUpdateListener(){

                @Override
                public void onMappingUpdate() {
                    latch.countDown();
                }

                @Override
                public void onFailure(Throwable t) {
                    latch.countDown();
                    LocalIndexShardGateway.this.logger.debug("failed to send mapping update post recovery to master for [{}]", t, type);
                }
            });
            this.cancellableThreads.execute(new CancellableThreads.Interruptable(){

                @Override
                public void run() throws InterruptedException {
                    try {
                        boolean waited = latch.await(LocalIndexShardGateway.this.waitForMappingUpdatePostRecovery.millis(), TimeUnit.MILLISECONDS);
                        if (!waited) {
                            LocalIndexShardGateway.this.logger.debug("waited for mapping update on master for [{}], yet timed out", type);
                        }
                    }
                    catch (InterruptedException e) {
                        LocalIndexShardGateway.this.logger.debug("interrupted while waiting for mapping update", new Object[0]);
                    }
                }
            });
        }
    }

    @Override
    public String type() {
        return "local";
    }

    @Override
    public void close() {
        FutureUtils.cancel(this.flushScheduler);
        this.cancellableThreads.cancel("closed");
    }

    class Sync
    implements Runnable {
        Sync() {
        }

        @Override
        public void run() {
            if (LocalIndexShardGateway.this.indexShard.state() == IndexShardState.CLOSED) {
                return;
            }
            if (LocalIndexShardGateway.this.indexShard.state() == IndexShardState.STARTED && LocalIndexShardGateway.this.indexShard.translog().syncNeeded()) {
                LocalIndexShardGateway.this.threadPool.executor("flush").execute(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                LocalIndexShardGateway.this.indexShard.translog().sync();
                            }
                            catch (Exception e) {
                                if (LocalIndexShardGateway.this.indexShard.state() != IndexShardState.STARTED) break block3;
                                LocalIndexShardGateway.this.logger.warn("failed to sync translog", e, new Object[0]);
                            }
                        }
                        if (LocalIndexShardGateway.this.indexShard.state() != IndexShardState.CLOSED) {
                            LocalIndexShardGateway.this.flushScheduler = LocalIndexShardGateway.this.threadPool.schedule(LocalIndexShardGateway.this.syncInterval, "same", Sync.this);
                        }
                    }
                });
            } else {
                LocalIndexShardGateway.this.flushScheduler = LocalIndexShardGateway.this.threadPool.schedule(LocalIndexShardGateway.this.syncInterval, "same", this);
            }
        }
    }
}

