/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.highlight.HighlightField;

public class PercolateResponse
extends BroadcastOperationResponse
implements Iterable<Match>,
ToXContent {
    public static final Match[] EMPTY = new Match[0];
    private long tookInMillis;
    private Match[] matches;
    private long count;
    private InternalFacets facets;
    private InternalAggregations aggregations;

    PercolateResponse(int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures, Match[] matches, long count, long tookInMillis, InternalFacets facets, InternalAggregations aggregations) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.tookInMillis = tookInMillis;
        this.matches = matches;
        this.count = count;
        this.facets = facets;
        this.aggregations = aggregations;
    }

    PercolateResponse(int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures, long tookInMillis, Match[] matches) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.tookInMillis = tookInMillis;
        this.matches = matches;
    }

    PercolateResponse() {
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public Match[] getMatches() {
        return this.matches;
    }

    public long getCount() {
        return this.count;
    }

    public InternalFacets getFacets() {
        return this.facets;
    }

    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public Iterator<Match> iterator() {
        return Arrays.asList(this.matches).iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.TOOK, this.tookInMillis);
        RestActions.buildBroadcastShardsHeader(builder, this);
        builder.field(Fields.TOTAL, this.count);
        if (this.matches != null) {
            builder.startArray(Fields.MATCHES);
            boolean justIds = "ids".equals(params.param("percolate_format"));
            if (justIds) {
                for (Match match : this.matches) {
                    builder.value(match.getId());
                }
            } else {
                for (Match match : this.matches) {
                    builder.startObject();
                    builder.field(Fields._INDEX, match.getIndex());
                    builder.field(Fields._ID, match.getId());
                    float score = match.getScore();
                    if (score != Float.NEGATIVE_INFINITY) {
                        builder.field(Fields._SCORE, match.getScore());
                    }
                    if (match.getHighlightFields() != null) {
                        builder.startObject(Fields.HIGHLIGHT);
                        for (HighlightField field : match.getHighlightFields().values()) {
                            builder.field(field.name());
                            if (field.fragments() == null) {
                                builder.nullValue();
                                continue;
                            }
                            builder.startArray();
                            for (Text fragment : field.fragments()) {
                                builder.value(fragment);
                            }
                            builder.endArray();
                        }
                        builder.endObject();
                    }
                    builder.endObject();
                }
            }
            builder.endArray();
        }
        if (this.facets != null) {
            this.facets.toXContent(builder, params);
        }
        if (this.aggregations != null) {
            this.aggregations.toXContent(builder, params);
        }
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tookInMillis = in.readVLong();
        this.count = in.readVLong();
        int size = in.readVInt();
        if (size != -1) {
            this.matches = new Match[size];
            for (int i = 0; i < size; ++i) {
                this.matches[i] = new Match();
                this.matches[i].readFrom(in);
            }
        }
        this.facets = InternalFacets.readOptionalFacets(in);
        this.aggregations = InternalAggregations.readOptionalAggregations(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.tookInMillis);
        out.writeVLong(this.count);
        if (this.matches == null) {
            out.writeVInt(-1);
        } else {
            out.writeVInt(this.matches.length);
            for (Match match : this.matches) {
                match.writeTo(out);
            }
        }
        out.writeOptionalStreamable(this.facets);
        out.writeOptionalStreamable(this.aggregations);
    }

    static final class Fields {
        static final XContentBuilderString TOOK = new XContentBuilderString("took");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MATCHES = new XContentBuilderString("matches");
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _SCORE = new XContentBuilderString("_score");
        static final XContentBuilderString HIGHLIGHT = new XContentBuilderString("highlight");

        Fields() {
        }
    }

    public static class Match
    implements Streamable {
        private Text index;
        private Text id;
        private float score;
        private Map<String, HighlightField> hl;

        public Match(Text index, Text id, float score, Map<String, HighlightField> hl) {
            this.id = id;
            this.score = score;
            this.index = index;
            this.hl = hl;
        }

        public Match(Text index, Text id, float score) {
            this.id = id;
            this.score = score;
            this.index = index;
        }

        Match() {
        }

        public Text getIndex() {
            return this.index;
        }

        public Text getId() {
            return this.id;
        }

        public float getScore() {
            return this.score;
        }

        @Nullable
        public Map<String, HighlightField> getHighlightFields() {
            return this.hl;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.id = in.readText();
            this.index = in.readText();
            this.score = in.readFloat();
            int size = in.readVInt();
            if (size > 0) {
                this.hl = new HashMap<String, HighlightField>(size);
                for (int j = 0; j < size; ++j) {
                    this.hl.put(in.readString(), HighlightField.readHighlightField(in));
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeText(this.id);
            out.writeText(this.index);
            out.writeFloat(this.score);
            if (this.hl != null) {
                out.writeVInt(this.hl.size());
                for (Map.Entry<String, HighlightField> entry : this.hl.entrySet()) {
                    out.writeString(entry.getKey());
                    entry.getValue().writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }
}

