/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;

public class ShardDeleteByQueryRequest
extends ShardReplicationOperationRequest<ShardDeleteByQueryRequest> {
    private int shardId;
    private BytesReference source;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private Set<String> routing;
    @Nullable
    private String[] filteringAliases;
    private long nowInMillis;
    private OriginalIndices originalIndices;

    ShardDeleteByQueryRequest(IndexDeleteByQueryRequest request, int shardId) {
        super(request);
        this.index = request.index();
        this.source = request.source();
        this.types = request.types();
        this.shardId = shardId;
        this.replicationType(request.replicationType());
        this.consistencyLevel(request.consistencyLevel());
        this.timeout = request.timeout();
        this.routing = request.routing();
        this.filteringAliases = request.filteringAliases();
        this.nowInMillis = request.nowInMillis();
        this.originalIndices = new OriginalIndices(request);
    }

    ShardDeleteByQueryRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.source == null) {
            ValidateActions.addValidationError("source is missing", validationException);
        }
        return validationException;
    }

    public int shardId() {
        return this.shardId;
    }

    BytesReference source() {
        return this.source;
    }

    public String[] types() {
        return this.types;
    }

    public Set<String> routing() {
        return this.routing;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    long nowInMillis() {
        return this.nowInMillis;
    }

    @Override
    public String[] indices() {
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.originalIndices.indicesOptions();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int aliasesSize;
        super.readFrom(in);
        this.source = in.readBytesReference();
        this.shardId = in.readVInt();
        this.types = in.readStringArray();
        int routingSize = in.readVInt();
        if (routingSize > 0) {
            this.routing = new HashSet<String>(routingSize);
            for (int i = 0; i < routingSize; ++i) {
                this.routing.add(in.readString());
            }
        }
        if ((aliasesSize = in.readVInt()) > 0) {
            this.filteringAliases = new String[aliasesSize];
            for (int i = 0; i < aliasesSize; ++i) {
                this.filteringAliases[i] = in.readString();
            }
        }
        this.nowInMillis = in.getVersion().onOrAfter(Version.V_1_2_0) ? in.readVLong() : System.currentTimeMillis();
        this.originalIndices = OriginalIndices.readOptionalOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.source);
        out.writeVInt(this.shardId);
        out.writeStringArray(this.types);
        if (this.routing != null) {
            out.writeVInt(this.routing.size());
            for (String r : this.routing) {
                out.writeString(r);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.filteringAliases != null) {
            out.writeVInt(this.filteringAliases.length);
            for (String alias : this.filteringAliases) {
                out.writeString(alias);
            }
        } else {
            out.writeVInt(0);
        }
        if (out.getVersion().onOrAfter(Version.V_1_2_0)) {
            out.writeVLong(this.nowInMillis);
        }
        OriginalIndices.writeOptionalOriginalIndices(this.originalIndices, out);
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "delete_by_query {[" + this.index + "]" + Arrays.toString(this.types) + ", query [" + sSource + "]}";
    }
}

