/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersResponse;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class GetIndexResponse
extends ActionResponse {
    private ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> warmers = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, ImmutableList<AliasMetaData>> aliases = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, Settings> settings = ImmutableOpenMap.of();
    private String[] indices;

    GetIndexResponse(String[] indices, ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> warmers, ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings, ImmutableOpenMap<String, ImmutableList<AliasMetaData>> aliases, ImmutableOpenMap<String, Settings> settings) {
        this.indices = indices;
        if (warmers != null) {
            this.warmers = warmers;
        }
        if (mappings != null) {
            this.mappings = mappings;
        }
        if (aliases != null) {
            this.aliases = aliases;
        }
        if (settings != null) {
            this.settings = settings;
        }
    }

    GetIndexResponse() {
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> warmers() {
        return this.warmers;
    }

    public ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> getWarmers() {
        return this.warmers();
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> getMappings() {
        return this.mappings();
    }

    public ImmutableOpenMap<String, ImmutableList<AliasMetaData>> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, ImmutableList<AliasMetaData>> getAliases() {
        return this.aliases();
    }

    public ImmutableOpenMap<String, Settings> settings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, Settings> getSettings() {
        return this.settings();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        int warmersSize = in.readVInt();
        ImmutableOpenMap.Builder<String, ImmutableCollection> warmersMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < warmersSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ImmutableList.Builder warmerEntryBuilder = ImmutableList.builder();
            for (int j = 0; j < valueSize; ++j) {
                warmerEntryBuilder.add(new IndexWarmersMetaData.Entry(in.readString(), in.readStringArray(), in.readOptionalBoolean(), in.readBytesReference()));
            }
            warmersMapBuilder.put(key, warmerEntryBuilder.build());
        }
        this.warmers = warmersMapBuilder.build();
        int mappingsSize = in.readVInt();
        ImmutableOpenMap.Builder mappingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < mappingsSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ImmutableOpenMap.Builder<String, MappingMetaData> mappingEntryBuilder = ImmutableOpenMap.builder();
            for (int j = 0; j < valueSize; ++j) {
                mappingEntryBuilder.put(in.readString(), MappingMetaData.readFrom(in));
            }
            mappingsMapBuilder.put(key, mappingEntryBuilder.build());
        }
        this.mappings = mappingsMapBuilder.build();
        int aliasesSize = in.readVInt();
        ImmutableOpenMap.Builder<String, ImmutableCollection> aliasesMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < aliasesSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ImmutableList.Builder aliasEntryBuilder = ImmutableList.builder();
            for (int j = 0; j < valueSize; ++j) {
                aliasEntryBuilder.add(AliasMetaData.Builder.readFrom(in));
            }
            aliasesMapBuilder.put(key, aliasEntryBuilder.build());
        }
        this.aliases = aliasesMapBuilder.build();
        int settingsSize = in.readVInt();
        ImmutableOpenMap.Builder<String, Settings> settingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < settingsSize; ++i) {
            String key = in.readString();
            settingsMapBuilder.put(key, ImmutableSettings.readSettingsFromStream(in));
        }
        this.settings = settingsMapBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeVInt(this.warmers.size());
        for (ObjectObjectCursor<String, ImmutableList<IndexWarmersMetaData.Entry>> objectObjectCursor : this.warmers) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableList)objectObjectCursor.value).size());
            for (IndexWarmersMetaData.Entry warmerEntry : (ImmutableList)objectObjectCursor.value) {
                out.writeString(warmerEntry.name());
                out.writeStringArray(warmerEntry.types());
                out.writeOptionalBoolean(warmerEntry.queryCache());
                out.writeBytesReference(warmerEntry.source());
            }
        }
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, Iterable<IndexWarmersMetaData.Entry>> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableOpenMap)objectObjectCursor.value).size());
            for (ObjectObjectCursor mappingEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                out.writeString((String)mappingEntry.key);
                MappingMetaData.writeTo((MappingMetaData)mappingEntry.value, out);
            }
        }
        out.writeVInt(this.aliases.size());
        for (ObjectObjectCursor<String, Iterable<IndexWarmersMetaData.Entry>> objectObjectCursor : this.aliases) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableList)objectObjectCursor.value).size());
            for (AliasMetaData aliasEntry : (ImmutableList)objectObjectCursor.value) {
                AliasMetaData.Builder.writeTo(aliasEntry, out);
            }
        }
        out.writeVInt(this.settings.size());
        for (ObjectObjectCursor<String, Object> objectObjectCursor : this.settings) {
            out.writeString((String)objectObjectCursor.key);
            ImmutableSettings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static GetIndexResponse convertResponses(GetAliasesResponse aliasesResponse, GetMappingsResponse mappingsResponse, GetSettingsResponse settingsResponse, GetWarmersResponse warmersResponse) {
        void var9_21;
        void var8_13;
        ImmutableOpenMap<String, Settings> immutableOpenMap;
        ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> immutableOpenMap2;
        ImmutableOpenMap<String, List<AliasMetaData>> returnedAliasesMap;
        HashSet indices = new HashSet();
        ImmutableOpenMap.Builder aliasesBuilder = ImmutableOpenMap.builder();
        if (aliasesResponse != null && (returnedAliasesMap = aliasesResponse.getAliases()) != null) {
            for (ObjectObjectCursor<String, List<AliasMetaData>> objectObjectCursor : returnedAliasesMap) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.addAll((Iterable)objectObjectCursor.value);
                aliasesBuilder.put(objectObjectCursor.key, builder.build());
                indices.add(objectObjectCursor.key);
            }
        }
        ImmutableOpenMap<String, ImmutableList<AliasMetaData>> aliases = aliasesBuilder.build();
        ImmutableOpenMap<String, ImmutableList<IndexWarmersMetaData.Entry>> warmers = null;
        if (warmersResponse != null && (warmers = warmersResponse.getWarmers()) != null) {
            for (ObjectObjectCursor<String, ImmutableList<IndexWarmersMetaData.Entry>> objectObjectCursor : warmers) {
                indices.add(objectObjectCursor.key);
            }
        }
        Object var8_11 = null;
        if (mappingsResponse != null && (immutableOpenMap2 = mappingsResponse.getMappings()) != null) {
            for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetaData>> objectObjectCursor : immutableOpenMap2) {
                indices.add(objectObjectCursor.key);
            }
        }
        Object var9_19 = null;
        if (settingsResponse != null && (immutableOpenMap = settingsResponse.getIndexToSettings()) != null) {
            for (ObjectObjectCursor<String, Settings> objectObjectCursor : immutableOpenMap) {
                indices.add(objectObjectCursor.key);
            }
        }
        GetIndexResponse getIndexResponse = new GetIndexResponse(indices.toArray(new String[indices.size()]), warmers, (ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>>)var8_13, aliases, (ImmutableOpenMap<String, Settings>)var9_21);
        return getIndexResponse;
    }
}

