/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class FlushRequest
extends BroadcastOperationRequest<FlushRequest> {
    private boolean force = false;
    private boolean waitIfOngoing = false;

    FlushRequest() {
    }

    public FlushRequest(ActionRequest originalRequest) {
        super(originalRequest);
    }

    public FlushRequest(String ... indices) {
        super(indices);
    }

    public boolean waitIfOngoing() {
        return this.waitIfOngoing;
    }

    public FlushRequest waitIfOngoing(boolean waitIfOngoing) {
        this.waitIfOngoing = waitIfOngoing;
        return this;
    }

    public boolean force() {
        return this.force;
    }

    public FlushRequest force(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(false);
        out.writeBoolean(this.force);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeBoolean(this.waitIfOngoing);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        in.readBoolean();
        this.force = in.readBoolean();
        this.waitIfOngoing = in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) ? in.readBoolean() : false;
    }
}

