/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.state;

import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class StateRouterResult<T> {
    private final boolean needContinueRoute;
    private final BitList<T> result;
    private final String message;

    public StateRouterResult(BitList<T> result) {
        this.needContinueRoute = true;
        this.result = result;
        this.message = null;
    }

    public StateRouterResult(BitList<T> invokers, BitList<T> routedResult) {
        this.needContinueRoute = true;
        this.result = invokers.and(routedResult);
        this.message = null;
    }

    public StateRouterResult(BitList<T> result, String message) {
        this.needContinueRoute = true;
        this.result = result;
        this.message = message;
    }

    public StateRouterResult(BitList<T> invokers, BitList<T> routedResult, String message) {
        this.needContinueRoute = true;
        this.result = invokers.and(routedResult);
        this.message = message;
    }

    public StateRouterResult(boolean needContinueRoute, BitList<T> result) {
        this.needContinueRoute = needContinueRoute;
        this.result = result;
        this.message = null;
    }

    public StateRouterResult(boolean needContinueRoute, BitList<T> invokers, BitList<T> routedResult) {
        this.needContinueRoute = needContinueRoute;
        this.result = invokers.and(routedResult);
        this.message = null;
    }

    public StateRouterResult(boolean needContinueRoute, BitList<T> result, String message) {
        this.needContinueRoute = needContinueRoute;
        this.result = result;
        this.message = message;
    }

    public StateRouterResult(boolean needContinueRoute, BitList<T> invokers, BitList<T> routedResult, String message) {
        this.needContinueRoute = needContinueRoute;
        this.result = invokers.and(routedResult);
        this.message = message;
    }

    public boolean isNeedContinueRoute() {
        return this.needContinueRoute;
    }

    public BitList<T> getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }
}

