/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.stopmethods;

import eu.stamp_project.mutationtest.descartes.stopmethods.StopMethodInterceptor;
import eu.stamp_project.mutationtest.descartes.stopmethods.StopMethodMatcher;
import eu.stamp_project.mutationtest.descartes.stopmethods.StopMethodMatchers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParameter;

public class StopMethodMatcherInterceptorFactory
implements MutationInterceptorFactory {
    private FeatureParameter EXCEPT;
    private Map<String, StopMethodMatcher> availabeMatchers = new HashMap<String, StopMethodMatcher>();

    public StopMethodMatcherInterceptorFactory() {
        this.availabeMatchers.put("empty", StopMethodMatchers.isEmptyVoid());
        this.availabeMatchers.put("enum", StopMethodMatchers.isEnumGenerated());
        this.availabeMatchers.put("to_string", StopMethodMatchers.isToString());
        this.availabeMatchers.put("hash_code", StopMethodMatchers.isHashCode());
        this.availabeMatchers.put("deprecated", StopMethodMatchers.isDeprecated());
        this.availabeMatchers.put("synthetic", StopMethodMatchers.isSynthetic());
        this.availabeMatchers.put("getter", StopMethodMatchers.isSimpleGetter());
        this.availabeMatchers.put("setter", StopMethodMatchers.isSimpleSetter());
        this.availabeMatchers.put("constant", StopMethodMatchers.returnsAConstant());
        this.availabeMatchers.put("delegate", StopMethodMatchers.isDelegate());
        this.availabeMatchers.put("clinit", StopMethodMatchers.isStaticInitializer());
        this.availabeMatchers.put("empty_array", StopMethodMatchers.returnsAnEmptyArray());
        this.availabeMatchers.put("null_return", StopMethodMatchers.returnsNull());
        this.availabeMatchers.put("return_this", StopMethodMatchers.returnsThis());
        this.availabeMatchers.put("return_param", StopMethodMatchers.returnsAParameter());
        String description = "Allows to reinsert some stop methods into the analysis. Possible values are: ";
        description = description + this.availabeMatchers.keySet().stream().collect(Collectors.joining(", "));
        this.EXCEPT = FeatureParameter.named((String)"except").withDescription(description);
    }

    public MutationInterceptor createInterceptor(InterceptorParameters interceptorParameters) {
        Set<String> matchers = this.availabeMatchers.keySet();
        List exclusions = interceptorParameters.getList(this.EXCEPT);
        if (exclusions != null) {
            matchers.removeAll(exclusions);
        }
        return new StopMethodInterceptor(StopMethodMatcher.any(matchers.stream().map(key -> this.availabeMatchers.get(key)).collect(Collectors.toList())));
    }

    public Feature provides() {
        return Feature.named((String)"STOP_METHODS").withOnByDefault(true).withDescription("Filters out mutations in methods that are generally of no interest").withParameter(this.EXCEPT);
    }

    public String description() {
        return "Stop methods filter";
    }
}

