/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.reporting;

import eu.stamp_project.mutationtest.descartes.reporting.WriterState;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Stack;

public class JSONWriter {
    Writer out;
    Stack<WriterState> memory;
    WriterState state;
    private static final String[] ESCAPE_SEQUENCES = new String[128];

    public JSONWriter(Writer out) {
        this.out = out;
        this.state = WriterState.Initial;
        this.memory = new Stack();
    }

    public void beginObject() throws IOException {
        this.beginStructure();
        this.state = WriterState.EmptyObject;
        this.out.write(123);
    }

    public void beginObjectAttribute(String key) throws IOException {
        this.beginAttribute(key);
        this.beginObject();
    }

    public void endObject() throws IOException {
        if (this.state != WriterState.EmptyObject && this.state != WriterState.Object) {
            throw new IllegalStateException("Object not started");
        }
        this.out.write(125);
        this.endStructure();
    }

    private void beginStructure() throws IOException {
        switch (this.state) {
            case EmptyObject: 
            case Object: 
            case Final: {
                throw new IllegalStateException("Cant' start an object in the current state");
            }
            case Initial: {
                this.memory.push(WriterState.Final);
                break;
            }
            case List: {
                this.out.write(44);
            }
            case EmptyList: {
                this.memory.push(WriterState.List);
                break;
            }
            default: {
                this.memory.push(this.state);
            }
        }
    }

    private void endStructure() {
        this.state = this.memory.pop();
        if (this.state == WriterState.Value) {
            this.state = this.memory.pop();
        }
    }

    public void beginList() throws IOException {
        this.beginStructure();
        this.state = WriterState.EmptyList;
        this.out.write(91);
    }

    public void beginListAttribute(String key) throws IOException {
        this.beginAttribute(key);
        this.beginList();
    }

    public void endList() throws IOException {
        if (this.state != WriterState.EmptyList && this.state != WriterState.List) {
            throw new IllegalStateException("List not started");
        }
        this.out.write(93);
        this.endStructure();
    }

    public void writeStringList(Collection<String> values) throws IOException {
        this.beginList();
        for (String value : values) {
            this.write(value);
        }
        this.endList();
    }

    public void writeStringListAttribute(String key, Collection<String> values) throws IOException {
        this.beginAttribute(key);
        this.writeStringList(values);
    }

    public void beginAttribute(String key) throws IOException {
        if (this.state != WriterState.Object && this.state != WriterState.EmptyObject) {
            throw new IllegalStateException("Attributes can only be added to objects");
        }
        if (this.state == WriterState.Object) {
            this.out.write(44);
        }
        this.memory.push(WriterState.Object);
        this.state = WriterState.Value;
        this.out.write(String.format("\"%1$s\":", JSONWriter.escapeString(key)));
    }

    public void writeAttribute(String key, int value) throws IOException {
        this.beginAttribute(key);
        this.write(value);
    }

    public void writeAttribute(String key, long value) throws IOException {
        this.beginAttribute(key);
        this.write(value);
    }

    public void writeAttribute(String key, boolean value) throws IOException {
        this.beginAttribute(key);
        this.write(value);
    }

    public void writeAttribute(String key, String value) throws IOException {
        this.beginAttribute(key);
        this.write(value);
    }

    private void writeValue(String value) throws IOException {
        if (this.state != WriterState.List && this.state != WriterState.EmptyList && this.state != WriterState.Value) {
            throw new IllegalStateException("Can't place a value in current context");
        }
        if (this.state == WriterState.List) {
            this.out.write(44);
        }
        if (this.state == WriterState.EmptyList) {
            this.state = WriterState.List;
        }
        this.out.write(value);
        if (this.state == WriterState.Value) {
            this.state = this.memory.pop();
        }
    }

    public void write(String value) throws IOException {
        if (value == null) {
            this.writeValue("null");
        } else {
            this.writeValue(String.format("\"%1$s\"", JSONWriter.escapeString(value)));
        }
    }

    public void write(int value) throws IOException {
        this.writeValue(String.valueOf(value));
    }

    public void write(long value) throws IOException {
        this.writeValue(String.valueOf(value));
    }

    public void write(boolean value) throws IOException {
        this.writeValue(String.valueOf(value).toLowerCase());
    }

    public void close() throws IOException {
        if (this.state != WriterState.Final) {
            throw new IllegalStateException("JSON structure isn't finished");
        }
        this.out.close();
    }

    public static String escapeString(String value) {
        StringWriter result = new StringWriter(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String toWrite = null;
            if (c < '\u0080') {
                toWrite = ESCAPE_SEQUENCES[c];
            } else if (c == '\u2028') {
                toWrite = "\\u2028";
            } else if (c == '\u2029') {
                toWrite = "\\u2028";
            }
            if (toWrite == null) {
                result.write(c);
                continue;
            }
            result.write(toWrite);
        }
        return result.getBuffer().toString();
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JSONWriter.ESCAPE_SEQUENCES[i] = String.format("\\u%04x", i);
        }
        JSONWriter.ESCAPE_SEQUENCES[34] = "\\\"";
        JSONWriter.ESCAPE_SEQUENCES[92] = "\\\\";
        JSONWriter.ESCAPE_SEQUENCES[9] = "\\t";
        JSONWriter.ESCAPE_SEQUENCES[8] = "\\b";
        JSONWriter.ESCAPE_SEQUENCES[10] = "\\n";
        JSONWriter.ESCAPE_SEQUENCES[13] = "\\r";
        JSONWriter.ESCAPE_SEQUENCES[12] = "\\f";
    }
}

